/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.lds;

import com.kyc.nashidmrz.id_card.jmrtd.cbeff.BiometricDataBlock;
import com.kyc.nashidmrz.id_card.jmrtd.lds.DataGroup;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.tlv.TLVOutputStream;

public abstract class CBEFFDataGroup<R extends BiometricDataBlock>
extends DataGroup {
    private static final long serialVersionUID = 2702959939408371946L;
    protected static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private final Random random;
    private List<R> subRecords;

    protected CBEFFDataGroup(int dataGroupTag, List<R> subRecords) {
        super(dataGroupTag);
        this.addAll(subRecords);
        this.random = new Random();
    }

    protected CBEFFDataGroup(int dataGroupTag, InputStream inputStream) throws IOException {
        super(dataGroupTag, inputStream);
        this.random = new Random();
    }

    public void add(R record) {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        this.subRecords.add(record);
    }

    public void addAll(List<R> records) {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        this.subRecords.addAll(records);
    }

    public void remove(int index) {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        this.subRecords.remove(index);
    }

    @Override
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("CBEFFDataGroup [");
        if (this.subRecords == null) {
            result2.append("null");
        } else {
            boolean isFirst = true;
            for (BiometricDataBlock subRecord : this.subRecords) {
                if (!isFirst) {
                    result2.append(", ");
                } else {
                    isFirst = false;
                }
                result2.append(subRecord == null ? "null" : subRecord.toString());
            }
        }
        result2.append(']');
        return result2.toString();
    }

    public List<R> getSubRecords() {
        if (this.subRecords == null) {
            this.subRecords = new ArrayList<R>();
        }
        return new ArrayList<R>(this.subRecords);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof CBEFFDataGroup)) {
            return false;
        }
        try {
            CBEFFDataGroup otherDG = (CBEFFDataGroup)other;
            List<R> subRecords = this.getSubRecords();
            List<R> otherSubRecords = otherDG.getSubRecords();
            int subRecordCount = subRecords.size();
            if (subRecordCount != otherSubRecords.size()) {
                return false;
            }
            for (int i = 0; i < subRecordCount; ++i) {
                BiometricDataBlock subRecord = (BiometricDataBlock)subRecords.get(i);
                BiometricDataBlock otherSubRecord = (BiometricDataBlock)otherSubRecords.get(i);
                if (!(subRecord == null ? otherSubRecord != null : !subRecord.equals(otherSubRecord))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException cce) {
            LOGGER.log(Level.WARNING, "Wrong class", cce);
            return false;
        }
    }

    public int hashCode() {
        int result2 = 1234567891;
        List<R> subRecords = this.getSubRecords();
        for (BiometricDataBlock record : subRecords) {
            if (record == null) {
                result2 = 3 * result2 + 5;
                continue;
            }
            result2 = 5 * (result2 + record.hashCode()) + 7;
        }
        return 7 * result2 + 11;
    }

    protected void writeOptionalRandomData(OutputStream outputStream) throws IOException {
        if (!this.subRecords.isEmpty()) {
            return;
        }
        TLVOutputStream tlvOut = outputStream instanceof TLVOutputStream ? (TLVOutputStream)outputStream : new TLVOutputStream(outputStream);
        tlvOut.writeTag(83);
        byte[] value = new byte[8];
        this.random.nextBytes(value);
        tlvOut.writeValue(value);
    }
}

