/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.lds;

import com.kyc.nashidmrz.id_card.jmrtd.cert.CVCPrincipal;
import com.kyc.nashidmrz.id_card.jmrtd.lds.AbstractLDSFile;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CVCAFile
extends AbstractLDSFile {
    private static final long serialVersionUID = -1100904058684365703L;
    public static final byte CAR_TAG = 66;
    public static final int LENGTH = 36;
    private final short fid;
    private String caReference = null;
    private String altCaReference = null;

    public CVCAFile(InputStream inputStream) throws IOException {
        this(284, inputStream);
    }

    public CVCAFile(short fid, InputStream inputStream) throws IOException {
        this.fid = fid;
        this.readObject(inputStream);
    }

    public CVCAFile(String caReference, String altCaReference) {
        this(284, caReference, altCaReference);
    }

    public CVCAFile(short fid, String caReference, String altCaReference) {
        if (caReference == null || caReference.length() > 16 || altCaReference != null && altCaReference.length() > 16) {
            throw new IllegalArgumentException();
        }
        this.fid = fid;
        this.caReference = caReference;
        this.altCaReference = altCaReference;
    }

    public CVCAFile(short fid, String caReference) {
        this(fid, caReference, null);
    }

    public short getFID() {
        return this.fid;
    }

    @Override
    protected void readObject(InputStream inputStream) throws IOException {
        DataInputStream dataIn = new DataInputStream(inputStream);
        int tag = dataIn.read();
        if (tag != 66) {
            throw new IllegalArgumentException("Wrong tag, expected " + Integer.toHexString(66) + ", found " + Integer.toHexString(tag));
        }
        int length = dataIn.read();
        if (length > 16) {
            throw new IllegalArgumentException("Wrong length");
        }
        byte[] data = new byte[length];
        dataIn.readFully(data);
        this.caReference = new String(data);
        tag = dataIn.read();
        if (tag != 0 && tag != -1) {
            if (tag != 66) {
                throw new IllegalArgumentException("Wrong tag");
            }
            length = dataIn.read();
            if (length > 16) {
                throw new IllegalArgumentException("Wrong length");
            }
            data = new byte[length];
            dataIn.readFully(data);
            this.altCaReference = new String(data);
            tag = dataIn.read();
        }
        while (tag != -1) {
            if (tag != 0) {
                throw new IllegalArgumentException("Bad file padding");
            }
            tag = dataIn.read();
        }
    }

    @Override
    protected void writeObject(OutputStream outputStream) throws IOException {
        byte[] result2 = new byte[36];
        result2[0] = 66;
        result2[1] = (byte)this.caReference.length();
        System.arraycopy(this.caReference.getBytes(), 0, result2, 2, result2[1]);
        if (this.altCaReference != null) {
            int index = result2[1] + 2;
            result2[index] = 66;
            result2[index + 1] = (byte)this.altCaReference.length();
            System.arraycopy(this.altCaReference.getBytes(), 0, result2, index + 2, result2[index + 1]);
        }
        outputStream.write(result2);
    }

    public CVCPrincipal getCAReference() {
        return this.caReference == null ? null : new CVCPrincipal(this.caReference);
    }

    public CVCPrincipal getAltCAReference() {
        return this.altCaReference == null ? null : new CVCPrincipal(this.altCaReference);
    }

    public String toString() {
        return "CA reference: \"" + this.caReference + "\"" + (this.altCaReference != null ? ", Alternative CA reference: " + this.altCaReference : "");
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        CVCAFile otherCVCAFile = (CVCAFile)other;
        return this.caReference.equals(otherCVCAFile.caReference) && (this.altCaReference == null && otherCVCAFile.altCaReference == null || this.altCaReference != null && this.altCaReference.equals(otherCVCAFile.altCaReference));
    }

    public int hashCode() {
        return 11 * this.caReference.hashCode() + (this.altCaReference != null ? 13 * this.altCaReference.hashCode() : 0) + 5;
    }

    @Override
    public int getLength() {
        return 36;
    }
}

