/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.lds;

import com.kyc.nashidmrz.id_card.jmrtd.lds.ChipAuthenticationInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.ChipAuthenticationPublicKeyInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.PACEInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.SecurityInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.SignedDataUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;

public class CardSecurityFile
implements Serializable {
    private static final long serialVersionUID = -3535507558193769952L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final String CONTENT_TYPE_OID = "0.4.0.127.0.7.3.2.1";
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Set<SecurityInfo> securityInfos;
    private byte[] encryptedDigest;
    private X509Certificate certificate;

    public CardSecurityFile(String digestAlgorithm, String digestEncryptionAlgorithm, Collection<SecurityInfo> securityInfos, PrivateKey privateKey, X509Certificate certificate) {
        this(digestAlgorithm, digestEncryptionAlgorithm, securityInfos, privateKey, certificate, null);
    }

    public CardSecurityFile(String digestAlgorithm, String digestEncryptionAlgorithm, Collection<SecurityInfo> securityInfos, PrivateKey privateKey, X509Certificate certificate, String provider) {
        this(digestAlgorithm, digestEncryptionAlgorithm, securityInfos, (byte[])null, certificate);
        ContentInfo contentInfo = CardSecurityFile.toContentInfo(CONTENT_TYPE_OID, securityInfos);
        this.encryptedDigest = SignedDataUtil.signData(digestAlgorithm, digestEncryptionAlgorithm, CONTENT_TYPE_OID, contentInfo, privateKey, provider);
    }

    public CardSecurityFile(String digestAlgorithm, String digestEncryptionAlgorithm, Collection<SecurityInfo> securityInfos, byte[] encryptedDigest, X509Certificate certificate) {
        if (securityInfos == null) {
            throw new IllegalArgumentException("Null securityInfos");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("Null certificate");
        }
        this.digestAlgorithm = digestAlgorithm;
        this.digestEncryptionAlgorithm = digestEncryptionAlgorithm;
        this.securityInfos = new HashSet<SecurityInfo>(securityInfos);
        this.encryptedDigest = encryptedDigest;
        this.certificate = certificate;
    }

    public CardSecurityFile(InputStream inputStream) throws IOException {
        this.readContent(inputStream);
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest == null ? null : Arrays.copyOf(this.encryptedDigest, this.encryptedDigest.length);
    }

    protected void readContent(InputStream inputStream) throws IOException {
        SignedData signedData = SignedDataUtil.readSignedData(inputStream);
        this.digestAlgorithm = SignedDataUtil.getSignerInfoDigestAlgorithm(signedData);
        this.digestEncryptionAlgorithm = SignedDataUtil.getDigestEncryptionAlgorithm(signedData);
        List<X509Certificate> certificates = SignedDataUtil.getCertificates(signedData);
        this.certificate = certificates == null || certificates.isEmpty() ? null : certificates.get(certificates.size() - 1);
        this.securityInfos = CardSecurityFile.getSecurityInfos(signedData);
        this.encryptedDigest = SignedDataUtil.getEncryptedDigest(signedData);
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        try {
            ContentInfo contentInfo = CardSecurityFile.toContentInfo(CONTENT_TYPE_OID, this.securityInfos);
            SignedData signedData = SignedDataUtil.createSignedData(this.digestAlgorithm, this.digestEncryptionAlgorithm, CONTENT_TYPE_OID, contentInfo, this.encryptedDigest, this.certificate);
            SignedDataUtil.writeData(signedData, outputStream);
        }
        catch (CertificateException ce) {
            throw new IOException("Certificate exception during SignedData creation", ce);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException("Unsupported algorithm", nsae);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("General security exception", gse);
        }
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.writeContent(outputStream);
            outputStream.close();
            return outputStream.toByteArray();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Exception while encoding CardSecurityFile", ioe);
            return null;
        }
    }

    public Collection<SecurityInfo> getSecurityInfos() {
        return Collections.unmodifiableCollection(this.securityInfos);
    }

    @Deprecated
    public Collection<PACEInfo> getPACEInfos() {
        ArrayList<PACEInfo> paceInfos = new ArrayList<PACEInfo>(this.securityInfos.size());
        for (SecurityInfo securityInfo : this.securityInfos) {
            if (!(securityInfo instanceof PACEInfo)) continue;
            paceInfos.add((PACEInfo)securityInfo);
        }
        return paceInfos;
    }

    @Deprecated
    public Collection<ChipAuthenticationInfo> getChipAuthenticationInfos() {
        ArrayList<ChipAuthenticationInfo> chipAuthenticationInfos = new ArrayList<ChipAuthenticationInfo>(this.securityInfos.size());
        for (SecurityInfo securityInfo : this.securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationInfo)) continue;
            chipAuthenticationInfos.add((ChipAuthenticationInfo)securityInfo);
        }
        return chipAuthenticationInfos;
    }

    @Deprecated
    public Collection<ChipAuthenticationPublicKeyInfo> getChipAuthenticationPublicKeyInfos() {
        ArrayList<ChipAuthenticationPublicKeyInfo> chipAuthenticationPublicKeyInfos = new ArrayList<ChipAuthenticationPublicKeyInfo>(this.securityInfos.size());
        for (SecurityInfo securityInfo : this.securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationPublicKeyInfo)) continue;
            chipAuthenticationPublicKeyInfos.add((ChipAuthenticationPublicKeyInfo)securityInfo);
        }
        return chipAuthenticationPublicKeyInfos;
    }

    public String toString() {
        return "CardSecurityFile [" + this.securityInfos.toString() + "]";
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!otherObj.getClass().equals(this.getClass())) {
            return false;
        }
        CardSecurityFile other = (CardSecurityFile)otherObj;
        if (this.securityInfos == null) {
            return other.securityInfos == null;
        }
        if (other.securityInfos == null) {
            return this.securityInfos == null;
        }
        return this.securityInfos.equals(other.securityInfos);
    }

    public int hashCode() {
        return 3 * this.securityInfos.hashCode() + 63;
    }

    private static ContentInfo toContentInfo(String contentTypeOID, Collection<SecurityInfo> securityInfos) {
        try {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            for (SecurityInfo securityInfo : securityInfos) {
                vector.add((ASN1Encodable)securityInfo.getDERObject());
            }
            DLSet derSet = new DLSet(vector);
            return new ContentInfo(new ASN1ObjectIdentifier(contentTypeOID), (ASN1Encodable)new DEROctetString((ASN1Encodable)derSet));
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error creating signedData", ioe);
            throw new IllegalArgumentException("Error DER encoding the security infos");
        }
    }

    private static Set<SecurityInfo> getSecurityInfos(SignedData signedData) throws IOException {
        ASN1Primitive encapsulatedContent = SignedDataUtil.getContent(signedData);
        if (!(encapsulatedContent instanceof ASN1Set)) {
            throw new IOException("Was expecting an ASN1Set, found " + encapsulatedContent.getClass());
        }
        HashSet<SecurityInfo> securityInfos = new HashSet<SecurityInfo>();
        for (int i = 0; i < ((ASN1Set)encapsulatedContent).size(); ++i) {
            ASN1Primitive object = ((ASN1Set)encapsulatedContent).getObjectAt(i).toASN1Primitive();
            try {
                SecurityInfo securityInfo = SecurityInfo.getInstance(object);
                if (securityInfo == null) {
                    LOGGER.log(Level.WARNING, "Could not parse, skipping security info");
                    continue;
                }
                securityInfos.add(securityInfo);
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception while parsing, skipping security info", e);
            }
        }
        return securityInfos;
    }
}

