/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.lds;

import com.kyc.nashidmrz.id_card.jmrtd.Util;
import com.kyc.nashidmrz.id_card.jmrtd.lds.SecurityInfo;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.util.encoders.Hex;

public class PACEInfo
extends SecurityInfo {
    private static final long serialVersionUID = 7960925013249578359L;
    public static final int PARAM_ID_GFP_1024_160 = 0;
    public static final int PARAM_ID_GFP_2048_224 = 1;
    public static final int PARAM_ID_GFP_2048_256 = 2;
    public static final int PARAM_ID_ECP_NIST_P192_R1 = 8;
    public static final int PARAM_ID_ECP_BRAINPOOL_P192_R1 = 9;
    public static final int PARAM_ID_ECP_NIST_P224_R1 = 10;
    public static final int PARAM_ID_ECP_BRAINPOOL_P224_R1 = 11;
    public static final int PARAM_ID_ECP_NIST_P256_R1 = 12;
    public static final int PARAM_ID_ECP_BRAINPOOL_P256_R1 = 13;
    public static final int PARAM_ID_ECP_BRAINPOOL_P320_R1 = 14;
    public static final int PARAM_ID_ECP_NIST_P384_R1 = 15;
    public static final int PARAM_ID_ECP_BRAINPOOL_P384_R1 = 16;
    public static final int PARAM_ID_ECP_BRAINPOOL_P512_R1 = 17;
    public static final int PARAM_ID_ECP_NIST_P521_R1 = 18;
    private static final String rfc5114_1024_160_p = "B10B8F96A080E01DDE92DE5EAE5D54EC52C99FBCFB06A3C69A6A9DCA52D23B616073E28675A23D189838EF1E2EE652C013ECB4AEA906112324975C3CD49B83BFACCBDD7D90C4BD7098488E9C219A73724EFFD6FAE5644738FAA31A4FF55BCCC0A151AF5F0DC8B4BD45BF37DF365C1A65E68CFDA76D4DA708DF1FB2BC2E4A4371";
    private static final String rfc5114_1024_160_g = "A4D1CBD5C3FD34126765A442EFB99905F8104DD258AC507FD6406CFF14266D31266FEA1E5C41564B777E690F5504F213160217B4B01B886A5E91547F9E2749F4D7FBD7D3B9A92EE1909D0D2263F80A76A6A24C087A091F531DBF0A0169B6A28AD662A4D18E73AFA32D779D5918D08BC8858F4DCEF97C2A24855E6EEB22B3B2E5";
    private static final String rfc5114_1024_160_q = "F518AA8781A8DF278ABA4E7D64B7CB9D49462353";
    private static final DHParameterSpec PARAMS_GFP_1024_160 = Util.toExplicitDHParameterSpec(PACEInfo.fromPGQ("B10B8F96A080E01DDE92DE5EAE5D54EC52C99FBCFB06A3C69A6A9DCA52D23B616073E28675A23D189838EF1E2EE652C013ECB4AEA906112324975C3CD49B83BFACCBDD7D90C4BD7098488E9C219A73724EFFD6FAE5644738FAA31A4FF55BCCC0A151AF5F0DC8B4BD45BF37DF365C1A65E68CFDA76D4DA708DF1FB2BC2E4A4371", "A4D1CBD5C3FD34126765A442EFB99905F8104DD258AC507FD6406CFF14266D31266FEA1E5C41564B777E690F5504F213160217B4B01B886A5E91547F9E2749F4D7FBD7D3B9A92EE1909D0D2263F80A76A6A24C087A091F531DBF0A0169B6A28AD662A4D18E73AFA32D779D5918D08BC8858F4DCEF97C2A24855E6EEB22B3B2E5", "F518AA8781A8DF278ABA4E7D64B7CB9D49462353"));
    private static final String rfc5114_2048_224_p = "AD107E1E9123A9D0D660FAA79559C51FA20D64E5683B9FD1B54B1597B61D0A75E6FA141DF95A56DBAF9A3C407BA1DF15EB3D688A309C180E1DE6B85A1274A0A66D3F8152AD6AC2129037C9EDEFDA4DF8D91E8FEF55B7394B7AD5B7D0B6C12207C9F98D11ED34DBF6C6BA0B2C8BBC27BE6A00E0A0B9C49708B3BF8A317091883681286130BC8985DB1602E714415D9330278273C7DE31EFDC7310F7121FD5A07415987D9ADC0A486DCDF93ACC44328387315D75E198C641A480CD86A1B9E587E8BE60E69CC928B2B9C52172E413042E9B23F10B0E16E79763C9B53DCF4BA80A29E3FB73C16B8E75B97EF363E2FFA31F71CF9DE5384E71B81C0AC4DFFE0C10E64F";
    private static final String rfc5114_2048_224_g = "AC4032EF4F2D9AE39DF30B5C8FFDAC506CDEBE7B89998CAF74866A08CFE4FFE3A6824A4E10B9A6F0DD921F01A70C4AFAAB739D7700C29F52C57DB17C620A8652BE5E9001A8D66AD7C17669101999024AF4D027275AC1348BB8A762D0521BC98AE247150422EA1ED409939D54DA7460CDB5F6C6B250717CBEF180EB34118E98D119529A45D6F834566E3025E316A330EFBB77A86F0C1AB15B051AE3D428C8F8ACB70A8137150B8EEB10E183EDD19963DDD9E263E4770589EF6AA21E7F5F2FF381B539CCE3409D13CD566AFBB48D6C019181E1BCFE94B30269EDFE72FE9B6AA4BD7B5A0F1C71CFFF4C19C418E1F6EC017981BC087F2A7065B384B890D3191F2BFA";
    private static final String rfc5114_2048_256_p = "87A8E61DB4B6663CFFBBD19C651959998CEEF608660DD0F25D2CEED4435E3B00E00DF8F1D61957D4FAF7DF4561B2AA3016C3D91134096FAA3BF4296D830E9A7C209E0C6497517ABD5A8A9D306BCF67ED91F9E6725B4758C022E0B1EF4275BF7B6C5BFC11D45F9088B941F54EB1E59BB8BC39A0BF12307F5C4FDB70C581B23F76B63ACAE1CAA6B7902D52526735488A0EF13C6D9A51BFA4AB3AD8347796524D8EF6A167B5A41825D967E144E5140564251CCACB83E6B486F6B3CA3F7971506026C0B857F689962856DED4010ABD0BE621C3A3960A54E710C375F26375D7014103A4B54330C198AF126116D2276E11715F693877FAD7EF09CADB094AE91E1A1597";
    private static final String rfc5114_2048_256_g = "3FB32C9B73134D0B2E77506660EDBD484CA7B18F21EF205407F4793A1A0BA12510DBC15077BE463FFF4FED4AAC0BB555BE3A6C1B0C6B47B1BC3773BF7E8C6F62901228F8C28CBB18A55AE31341000A650196F931C77A57F2DDF463E5E9EC144B777DE62AAAB8A8628AC376D282D6ED3864E67982428EBC831D14348F6F2F9193B5045AF2767164E1DFC967C1FB3F2E55A4BD1BFFE83B9C80D052B985D182EA0ADB2A3B7313D3FE14C8484B1E052588B9B7D2BBD2DF016199ECD06E1557CD0915B3353BBB64E0EC377FD028370DF92B52C7891428CDC67EB6184B523D1DB246C32F63078490F00EF8D647D148D47954515E2327CFEF98C582664B4C0F6CC41659";
    private static final String rfc5114_2048_256_q = "8CF83642A709A097B447997640129DA299B1A47D1EB3750BA308B0FE64F5FBD3";
    private static final String rfc5114_2048_224_q = "801C0D34C58D93FE997177101F80535A4738CEBCBF389A99B36371EB";
    private static final DHParameterSpec PARAMS_GFP_2048_224 = Util.toExplicitDHParameterSpec(PACEInfo.fromPGQ("AD107E1E9123A9D0D660FAA79559C51FA20D64E5683B9FD1B54B1597B61D0A75E6FA141DF95A56DBAF9A3C407BA1DF15EB3D688A309C180E1DE6B85A1274A0A66D3F8152AD6AC2129037C9EDEFDA4DF8D91E8FEF55B7394B7AD5B7D0B6C12207C9F98D11ED34DBF6C6BA0B2C8BBC27BE6A00E0A0B9C49708B3BF8A317091883681286130BC8985DB1602E714415D9330278273C7DE31EFDC7310F7121FD5A07415987D9ADC0A486DCDF93ACC44328387315D75E198C641A480CD86A1B9E587E8BE60E69CC928B2B9C52172E413042E9B23F10B0E16E79763C9B53DCF4BA80A29E3FB73C16B8E75B97EF363E2FFA31F71CF9DE5384E71B81C0AC4DFFE0C10E64F", "AC4032EF4F2D9AE39DF30B5C8FFDAC506CDEBE7B89998CAF74866A08CFE4FFE3A6824A4E10B9A6F0DD921F01A70C4AFAAB739D7700C29F52C57DB17C620A8652BE5E9001A8D66AD7C17669101999024AF4D027275AC1348BB8A762D0521BC98AE247150422EA1ED409939D54DA7460CDB5F6C6B250717CBEF180EB34118E98D119529A45D6F834566E3025E316A330EFBB77A86F0C1AB15B051AE3D428C8F8ACB70A8137150B8EEB10E183EDD19963DDD9E263E4770589EF6AA21E7F5F2FF381B539CCE3409D13CD566AFBB48D6C019181E1BCFE94B30269EDFE72FE9B6AA4BD7B5A0F1C71CFFF4C19C418E1F6EC017981BC087F2A7065B384B890D3191F2BFA", "801C0D34C58D93FE997177101F80535A4738CEBCBF389A99B36371EB"));
    private static final DHParameterSpec PARAMS_GFP_2048_256 = Util.toExplicitDHParameterSpec(PACEInfo.fromPGQ("87A8E61DB4B6663CFFBBD19C651959998CEEF608660DD0F25D2CEED4435E3B00E00DF8F1D61957D4FAF7DF4561B2AA3016C3D91134096FAA3BF4296D830E9A7C209E0C6497517ABD5A8A9D306BCF67ED91F9E6725B4758C022E0B1EF4275BF7B6C5BFC11D45F9088B941F54EB1E59BB8BC39A0BF12307F5C4FDB70C581B23F76B63ACAE1CAA6B7902D52526735488A0EF13C6D9A51BFA4AB3AD8347796524D8EF6A167B5A41825D967E144E5140564251CCACB83E6B486F6B3CA3F7971506026C0B857F689962856DED4010ABD0BE621C3A3960A54E710C375F26375D7014103A4B54330C198AF126116D2276E11715F693877FAD7EF09CADB094AE91E1A1597", "3FB32C9B73134D0B2E77506660EDBD484CA7B18F21EF205407F4793A1A0BA12510DBC15077BE463FFF4FED4AAC0BB555BE3A6C1B0C6B47B1BC3773BF7E8C6F62901228F8C28CBB18A55AE31341000A650196F931C77A57F2DDF463E5E9EC144B777DE62AAAB8A8628AC376D282D6ED3864E67982428EBC831D14348F6F2F9193B5045AF2767164E1DFC967C1FB3F2E55A4BD1BFFE83B9C80D052B985D182EA0ADB2A3B7313D3FE14C8484B1E052588B9B7D2BBD2DF016199ECD06E1557CD0915B3353BBB64E0EC377FD028370DF92B52C7891428CDC67EB6184B523D1DB246C32F63078490F00EF8D647D148D47954515E2327CFEF98C582664B4C0F6CC41659", "8CF83642A709A097B447997640129DA299B1A47D1EB3750BA308B0FE64F5FBD3"));
    private static final ECParameterSpec PARAMS_ECP_NIST_P192_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"secp192r1"));
    private static final ECParameterSpec PARAMS_ECP_NIST_P224_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"secp224r1"));
    private static final ECParameterSpec PARAMS_ECP_NIST_P256_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"secp256r1"));
    private static final ECParameterSpec PARAMS_ECP_NIST_P384_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"secp384r1"));
    private static final ECParameterSpec PARAMS_ECP_NIST_P521_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"secp521r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P192_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"brainpoolp192r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P224_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"brainpoolp224r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P256_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"brainpoolp256r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P320_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"brainpoolp320r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P384_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"brainpoolp384r1"));
    private static final ECParameterSpec PARAMS_ECP_BRAINPOOL_P512_R1 = Util.toExplicitECParameterSpec(ECNamedCurveTable.getParameterSpec((String)"brainpoolp512r1"));
    private static final Set<String> ALLOWED_REQUIRED_IDENTIFIERS = new TreeSet<String>(Arrays.asList("0.4.0.127.0.7.2.2.4.1.1", "0.4.0.127.0.7.2.2.4.1.2", "0.4.0.127.0.7.2.2.4.1.3", "0.4.0.127.0.7.2.2.4.1.4", "0.4.0.127.0.7.2.2.4.3.1", "0.4.0.127.0.7.2.2.4.3.2", "0.4.0.127.0.7.2.2.4.3.3", "0.4.0.127.0.7.2.2.4.3.4", "0.4.0.127.0.7.2.2.4.2.1", "0.4.0.127.0.7.2.2.4.2.2", "0.4.0.127.0.7.2.2.4.2.3", "0.4.0.127.0.7.2.2.4.2.4", "0.4.0.127.0.7.2.2.4.4.1", "0.4.0.127.0.7.2.2.4.4.2", "0.4.0.127.0.7.2.2.4.4.3", "0.4.0.127.0.7.2.2.4.4.4", "0.4.0.127.0.7.2.2.4.6.2", "0.4.0.127.0.7.2.2.4.6.3", "0.4.0.127.0.7.2.2.4.6.4"));
    private final String protocolOID;
    private final int version;
    private final BigInteger parameterId;

    private static DHParameters fromPGQ(String hexP, String hexG, String hexQ) {
        return new DHParameters(PACEInfo.fromHex(hexP), PACEInfo.fromHex(hexG), PACEInfo.fromHex(hexQ));
    }

    private static BigInteger fromHex(String hex) {
        return new BigInteger(1, Hex.decode((String)hex));
    }

    public PACEInfo(String oid, int version, int parameterId) {
        this(oid, version, BigInteger.valueOf(parameterId));
    }

    public PACEInfo(String oid, int version, BigInteger parameterId) {
        if (!PACEInfo.checkRequiredIdentifier(oid)) {
            throw new IllegalArgumentException("Invalid OID");
        }
        if (version != 2) {
            throw new IllegalArgumentException("Invalid version, must be 2");
        }
        this.protocolOID = oid;
        this.version = version;
        this.parameterId = parameterId;
    }

    public static PACEInfo createPACEInfo(byte[] paceInfoBytes) {
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)paceInfoBytes);
        String oid = ((ASN1ObjectIdentifier)sequence.getObjectAt(0)).getId();
        ASN1Primitive requiredData = sequence.getObjectAt(1).toASN1Primitive();
        ASN1Primitive optionalData = null;
        if (sequence.size() == 3) {
            optionalData = sequence.getObjectAt(2).toASN1Primitive();
        }
        int version = ((ASN1Integer)requiredData).getValue().intValue();
        BigInteger parameterId = null;
        if (optionalData != null) {
            parameterId = ((ASN1Integer)optionalData).getValue();
        }
        return new PACEInfo(oid, version, parameterId);
    }

    @Override
    public String getObjectIdentifier() {
        return this.protocolOID;
    }

    @Override
    public String getProtocolOIDString() {
        return this.toProtocolOIDString(this.protocolOID);
    }

    public int getVersion() {
        return this.version;
    }

    public BigInteger getParameterId() {
        return this.parameterId;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1ObjectIdentifier(this.protocolOID));
        vector.add((ASN1Encodable)new ASN1Integer((long)this.version));
        if (this.parameterId != null) {
            vector.add((ASN1Encodable)new ASN1Integer(this.parameterId));
        }
        return new DLSequence(vector);
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("PACEInfo [");
        result2.append("protocol: ").append(this.toProtocolOIDString(this.protocolOID));
        result2.append(", version: ").append(this.version);
        if (this.parameterId != null) {
            result2.append(", parameterId: ").append(PACEInfo.toStandardizedParamIdString(this.parameterId));
        }
        result2.append("]");
        return result2.toString();
    }

    public int hashCode() {
        return 1234567891 + 7 * this.protocolOID.hashCode() + 5 * this.version + 3 * (this.parameterId == null ? 1991 : this.parameterId.hashCode());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!PACEInfo.class.equals(other.getClass())) {
            return false;
        }
        PACEInfo otherPACEInfo = (PACEInfo)other;
        return this.getDERObject().equals(otherPACEInfo.getDERObject());
    }

    public static boolean checkRequiredIdentifier(String oid) {
        return ALLOWED_REQUIRED_IDENTIFIERS.contains(oid);
    }

    public static MappingType toMappingType(String oid) {
        if ("0.4.0.127.0.7.2.2.4.1.1".equals(oid) || "0.4.0.127.0.7.2.2.4.1.2".equals(oid) || "0.4.0.127.0.7.2.2.4.1.3".equals(oid) || "0.4.0.127.0.7.2.2.4.1.4".equals(oid) || "0.4.0.127.0.7.2.2.4.2.1".equals(oid) || "0.4.0.127.0.7.2.2.4.2.2".equals(oid) || "0.4.0.127.0.7.2.2.4.2.3".equals(oid) || "0.4.0.127.0.7.2.2.4.2.4".equals(oid)) {
            return MappingType.GM;
        }
        if ("0.4.0.127.0.7.2.2.4.3.1".equals(oid) || "0.4.0.127.0.7.2.2.4.3.2".equals(oid) || "0.4.0.127.0.7.2.2.4.3.3".equals(oid) || "0.4.0.127.0.7.2.2.4.3.4".equals(oid) || "0.4.0.127.0.7.2.2.4.4.1".equals(oid) || "0.4.0.127.0.7.2.2.4.4.2".equals(oid) || "0.4.0.127.0.7.2.2.4.4.3".equals(oid) || "0.4.0.127.0.7.2.2.4.4.4".equals(oid)) {
            return MappingType.IM;
        }
        if ("0.4.0.127.0.7.2.2.4.6.2".equals(oid) || "0.4.0.127.0.7.2.2.4.6.3".equals(oid) || "0.4.0.127.0.7.2.2.4.6.4".equals(oid)) {
            return MappingType.CAM;
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    public static String toKeyAgreementAlgorithm(String oid) {
        if ("0.4.0.127.0.7.2.2.4.1.1".equals(oid) || "0.4.0.127.0.7.2.2.4.1.2".equals(oid) || "0.4.0.127.0.7.2.2.4.1.3".equals(oid) || "0.4.0.127.0.7.2.2.4.1.4".equals(oid) || "0.4.0.127.0.7.2.2.4.3.1".equals(oid) || "0.4.0.127.0.7.2.2.4.3.2".equals(oid) || "0.4.0.127.0.7.2.2.4.3.3".equals(oid) || "0.4.0.127.0.7.2.2.4.3.4".equals(oid)) {
            return "DH";
        }
        if ("0.4.0.127.0.7.2.2.4.2.1".equals(oid) || "0.4.0.127.0.7.2.2.4.2.2".equals(oid) || "0.4.0.127.0.7.2.2.4.2.3".equals(oid) || "0.4.0.127.0.7.2.2.4.2.4".equals(oid) || "0.4.0.127.0.7.2.2.4.4.1".equals(oid) || "0.4.0.127.0.7.2.2.4.4.2".equals(oid) || "0.4.0.127.0.7.2.2.4.4.3".equals(oid) || "0.4.0.127.0.7.2.2.4.4.4".equals(oid) || "0.4.0.127.0.7.2.2.4.6.2".equals(oid) || "0.4.0.127.0.7.2.2.4.6.3".equals(oid) || "0.4.0.127.0.7.2.2.4.6.4".equals(oid)) {
            return "ECDH";
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    public static String toCipherAlgorithm(String oid) {
        if ("0.4.0.127.0.7.2.2.4.1.1".equals(oid) || "0.4.0.127.0.7.2.2.4.3.1".equals(oid) || "0.4.0.127.0.7.2.2.4.2.1".equals(oid) || "0.4.0.127.0.7.2.2.4.4.1".equals(oid)) {
            return "DESede";
        }
        if ("0.4.0.127.0.7.2.2.4.1.2".equals(oid) || "0.4.0.127.0.7.2.2.4.1.3".equals(oid) || "0.4.0.127.0.7.2.2.4.1.4".equals(oid) || "0.4.0.127.0.7.2.2.4.3.2".equals(oid) || "0.4.0.127.0.7.2.2.4.3.3".equals(oid) || "0.4.0.127.0.7.2.2.4.3.4".equals(oid) || "0.4.0.127.0.7.2.2.4.2.2".equals(oid) || "0.4.0.127.0.7.2.2.4.2.3".equals(oid) || "0.4.0.127.0.7.2.2.4.2.4".equals(oid) || "0.4.0.127.0.7.2.2.4.4.2".equals(oid) || "0.4.0.127.0.7.2.2.4.4.3".equals(oid) || "0.4.0.127.0.7.2.2.4.4.4".equals(oid) || "0.4.0.127.0.7.2.2.4.6.2".equals(oid) || "0.4.0.127.0.7.2.2.4.6.3".equals(oid) || "0.4.0.127.0.7.2.2.4.6.4".equals(oid)) {
            return "AES";
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    public static String toDigestAlgorithm(String oid) {
        if ("0.4.0.127.0.7.2.2.4.1.1".equals(oid) || "0.4.0.127.0.7.2.2.4.3.1".equals(oid) || "0.4.0.127.0.7.2.2.4.2.1".equals(oid) || "0.4.0.127.0.7.2.2.4.4.1".equals(oid) || "0.4.0.127.0.7.2.2.4.1.2".equals(oid) || "0.4.0.127.0.7.2.2.4.3.2".equals(oid) || "0.4.0.127.0.7.2.2.4.2.2".equals(oid) || "0.4.0.127.0.7.2.2.4.4.2".equals(oid) || "0.4.0.127.0.7.2.2.4.6.2".equals(oid)) {
            return "SHA-1";
        }
        if ("0.4.0.127.0.7.2.2.4.1.3".equals(oid) || "0.4.0.127.0.7.2.2.4.3.3".equals(oid) || "0.4.0.127.0.7.2.2.4.2.3".equals(oid) || "0.4.0.127.0.7.2.2.4.4.3".equals(oid) || "0.4.0.127.0.7.2.2.4.6.3".equals(oid) || "0.4.0.127.0.7.2.2.4.1.4".equals(oid) || "0.4.0.127.0.7.2.2.4.3.4".equals(oid) || "0.4.0.127.0.7.2.2.4.2.4".equals(oid) || "0.4.0.127.0.7.2.2.4.4.4".equals(oid) || "0.4.0.127.0.7.2.2.4.6.4".equals(oid)) {
            return "SHA-256";
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    public static int toKeyLength(String oid) {
        if ("0.4.0.127.0.7.2.2.4.1.1".equals(oid) || "0.4.0.127.0.7.2.2.4.3.1".equals(oid) || "0.4.0.127.0.7.2.2.4.2.1".equals(oid) || "0.4.0.127.0.7.2.2.4.4.1".equals(oid) || "0.4.0.127.0.7.2.2.4.1.2".equals(oid) || "0.4.0.127.0.7.2.2.4.3.2".equals(oid) || "0.4.0.127.0.7.2.2.4.2.2".equals(oid) || "0.4.0.127.0.7.2.2.4.4.2".equals(oid) || "0.4.0.127.0.7.2.2.4.6.2".equals(oid)) {
            return 128;
        }
        if ("0.4.0.127.0.7.2.2.4.1.3".equals(oid) || "0.4.0.127.0.7.2.2.4.2.3".equals(oid) || "0.4.0.127.0.7.2.2.4.3.3".equals(oid) || "0.4.0.127.0.7.2.2.4.4.3".equals(oid) || "0.4.0.127.0.7.2.2.4.6.3".equals(oid)) {
            return 192;
        }
        if ("0.4.0.127.0.7.2.2.4.1.4".equals(oid) || "0.4.0.127.0.7.2.2.4.3.4".equals(oid) || "0.4.0.127.0.7.2.2.4.2.4".equals(oid) || "0.4.0.127.0.7.2.2.4.4.4".equals(oid) || "0.4.0.127.0.7.2.2.4.6.4".equals(oid)) {
            return 256;
        }
        throw new NumberFormatException("Unknown OID: \"" + oid + "\"");
    }

    public static AlgorithmParameterSpec toParameterSpec(BigInteger stdDomainParam) {
        return PACEInfo.toParameterSpec(stdDomainParam.intValue());
    }

    public static AlgorithmParameterSpec toParameterSpec(int stdDomainParam) {
        switch (stdDomainParam) {
            case 0: {
                return PARAMS_GFP_1024_160;
            }
            case 1: {
                return PARAMS_GFP_2048_224;
            }
            case 2: {
                return PARAMS_GFP_2048_256;
            }
            case 8: {
                return PARAMS_ECP_NIST_P192_R1;
            }
            case 9: {
                return PARAMS_ECP_BRAINPOOL_P192_R1;
            }
            case 10: {
                return PARAMS_ECP_NIST_P224_R1;
            }
            case 11: {
                return PARAMS_ECP_BRAINPOOL_P224_R1;
            }
            case 12: {
                return PARAMS_ECP_NIST_P256_R1;
            }
            case 13: {
                return PARAMS_ECP_BRAINPOOL_P256_R1;
            }
            case 14: {
                return PARAMS_ECP_BRAINPOOL_P320_R1;
            }
            case 15: {
                return PARAMS_ECP_NIST_P384_R1;
            }
            case 16: {
                return PARAMS_ECP_BRAINPOOL_P384_R1;
            }
            case 17: {
                return PARAMS_ECP_BRAINPOOL_P512_R1;
            }
            case 18: {
                return PARAMS_ECP_NIST_P521_R1;
            }
        }
        throw new NumberFormatException("Unknown standardized domain parameters " + stdDomainParam);
    }

    public static String toStandardizedParamIdString(BigInteger stdDomainParam) {
        if (stdDomainParam == null) {
            return "null";
        }
        switch (stdDomainParam.intValue()) {
            case 0: {
                return "1024-bit MODP Group with 160-bit Prime Order Subgroup";
            }
            case 1: {
                return "2048-bit MODP Group with 224-bit Prime Order Subgroup";
            }
            case 2: {
                return "2048-bit MODP Group with 256-bit Prime Order Subgroup";
            }
            case 8: {
                return "NIST P-192 (secp192r1)";
            }
            case 9: {
                return "BrainpoolP192r1";
            }
            case 10: {
                return "NIST P-224 (secp224r1)";
            }
            case 11: {
                return "BrainpoolP224r1";
            }
            case 12: {
                return "NIST P-256 (secp256r1)";
            }
            case 13: {
                return "BrainpoolP256r1";
            }
            case 14: {
                return "BrainpoolP320r1";
            }
            case 15: {
                return "NIST P-384 (secp384r1)";
            }
            case 16: {
                return "BrainpoolP384r1";
            }
            case 17: {
                return "BrainpoolP512r1";
            }
            case 18: {
                return "NIST P-521 (secp521r1)";
            }
        }
        return stdDomainParam.toString();
    }

    private String toProtocolOIDString(String oid) {
        if ("0.4.0.127.0.7.2.2.4.1.1".equals(oid)) {
            return "id-PACE-DH-GM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.1.2".equals(oid)) {
            return "id-PACE-DH-GM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.1.3".equals(oid)) {
            return "id-PACE-DH-GM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.1.4".equals(oid)) {
            return "id-PACE-DH-GM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.3.1".equals(oid)) {
            return "id-PACE-DH-IM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.3.2".equals(oid)) {
            return "id-PACE-DH-IM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.3.3".equals(oid)) {
            return "id-PACE-DH-IM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.3.4".equals(oid)) {
            return "id-PACE_DH-IM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.2.1".equals(oid)) {
            return "id-PACE-ECDH-GM-3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.2.2".equals(oid)) {
            return "id-PACE-ECDH-GM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.2.3".equals(oid)) {
            return "id-PACE-ECDH-GM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.2.4".equals(oid)) {
            return "id-PACE-ECDH-GM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.4.1".equals(oid)) {
            return "id-PACE-ECDH-IM_3DES-CBC-CBC";
        }
        if ("0.4.0.127.0.7.2.2.4.4.2".equals(oid)) {
            return "id-PACE-ECDH-IM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.4.3".equals(oid)) {
            return "id-PACE-ECDH-IM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.4.4".equals(oid)) {
            return "id-PACE-ECDH-IM-AES-CBC-CMAC-256";
        }
        if ("0.4.0.127.0.7.2.2.4.6.2".equals(oid)) {
            return "id-PACE-ECDH-CAM-AES-CBC-CMAC-128";
        }
        if ("0.4.0.127.0.7.2.2.4.6.3".equals(oid)) {
            return "id-PACE-ECDH-CAM-AES-CBC-CMAC-192";
        }
        if ("0.4.0.127.0.7.2.2.4.6.4".equals(oid)) {
            return "id-PACE-ECDH-CAM-AES-CBC-CMAC-256";
        }
        return oid;
    }

    public static enum MappingType {
        GM,
        IM,
        CAM;

    }

    public static class DHCParameterSpec
    extends DHParameterSpec {
        private final BigInteger q;

        public DHCParameterSpec(BigInteger p, BigInteger g, BigInteger q) {
            super(p, g);
            this.q = q;
        }

        public BigInteger getQ() {
            return this.q;
        }
    }
}

