/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.lds;

import com.kyc.nashidmrz.id_card.jmrtd.lds.AbstractTaggedLDSFile;
import com.kyc.nashidmrz.id_card.jmrtd.lds.SignedDataUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.icao.DataGroupHash;
import org.bouncycastle.asn1.icao.LDSSecurityObject;
import org.bouncycastle.asn1.icao.LDSVersionInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SODFile
extends AbstractTaggedLDSFile {
    private static final long serialVersionUID = -1081347374739311111L;
    private static final String ICAO_LDS_SOD_OID = "2.23.136.1.1.1";
    private static final String ICAO_LDS_SOD_ALT_OID = "1.3.27.1.1.1";
    private static final String SDU_LDS_SOD_OID = "1.2.528.1.1006.1.20.1";
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private transient SignedData signedData;

    public SODFile(String digestAlgorithm, String digestEncryptionAlgorithm, Map<Integer, byte[]> dataGroupHashes, PrivateKey privateKey, X509Certificate docSigningCertificate) throws GeneralSecurityException {
        this(digestAlgorithm, digestEncryptionAlgorithm, dataGroupHashes, privateKey, docSigningCertificate, null);
    }

    public SODFile(String digestAlgorithm, String digestEncryptionAlgorithm, Map<Integer, byte[]> dataGroupHashes, PrivateKey privateKey, X509Certificate docSigningCertificate, String provider) throws GeneralSecurityException {
        this(digestAlgorithm, digestEncryptionAlgorithm, dataGroupHashes, privateKey, docSigningCertificate, provider, null, null);
    }

    public SODFile(String digestAlgorithm, String digestEncryptionAlgorithm, Map<Integer, byte[]> dataGroupHashes, PrivateKey privateKey, X509Certificate docSigningCertificate, String provider, String ldsVersion, String unicodeVersion) throws GeneralSecurityException {
        super(119);
        try {
            ContentInfo contentInfo = SODFile.toContentInfo(ICAO_LDS_SOD_OID, digestAlgorithm, dataGroupHashes, ldsVersion, unicodeVersion);
            byte[] encryptedDigest = SignedDataUtil.signData(digestAlgorithm, digestEncryptionAlgorithm, ICAO_LDS_SOD_OID, contentInfo, privateKey, provider);
            this.signedData = SignedDataUtil.createSignedData(digestAlgorithm, digestEncryptionAlgorithm, ICAO_LDS_SOD_OID, contentInfo, encryptedDigest, docSigningCertificate);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error creating signedData", ioe);
        }
    }

    public SODFile(String digestAlgorithm, String digestEncryptionAlgorithm, Map<Integer, byte[]> dataGroupHashes, byte[] encryptedDigest, X509Certificate docSigningCertificate) throws GeneralSecurityException {
        super(119);
        if (dataGroupHashes == null) {
            throw new IllegalArgumentException("Cannot construct security object from null datagroup hashes");
        }
        try {
            this.signedData = SignedDataUtil.createSignedData(digestAlgorithm, digestEncryptionAlgorithm, ICAO_LDS_SOD_OID, SODFile.toContentInfo(ICAO_LDS_SOD_OID, digestAlgorithm, dataGroupHashes, null, null), encryptedDigest, docSigningCertificate);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error creating signedData", ioe);
        }
    }

    public SODFile(InputStream inputStream) throws IOException {
        super(119, inputStream);
    }

    @Override
    protected void readContent(InputStream inputStream) throws IOException {
        this.signedData = SignedDataUtil.readSignedData(inputStream);
    }

    @Override
    protected void writeContent(OutputStream outputStream) throws IOException {
        SignedDataUtil.writeData(this.signedData, outputStream);
    }

    public Map<Integer, byte[]> getDataGroupHashes() {
        DataGroupHash[] hashObjects = SODFile.getLDSSecurityObject(this.signedData).getDatagroupHash();
        TreeMap<Integer, byte[]> hashMap = new TreeMap<Integer, byte[]>();
        for (DataGroupHash hashObject : hashObjects) {
            int number = hashObject.getDataGroupNumber();
            byte[] hashValue = hashObject.getDataGroupHashValue().getOctets();
            hashMap.put(number, hashValue);
        }
        return hashMap;
    }

    public byte[] getEncryptedDigest() {
        return SignedDataUtil.getEncryptedDigest(this.signedData);
    }

    public AlgorithmParameterSpec getDigestEncryptionAlgorithmParams() {
        return SignedDataUtil.getDigestEncryptionAlgorithmParams(this.signedData);
    }

    public byte[] getEContent() throws SignatureException {
        return SignedDataUtil.getEContent(this.signedData);
    }

    public String getDigestAlgorithm() {
        return SODFile.getDigestAlgorithm(SODFile.getLDSSecurityObject(this.signedData));
    }

    private static String getDigestAlgorithm(LDSSecurityObject ldsSecurityObject) {
        try {
            return SignedDataUtil.lookupMnemonicByOID(ldsSecurityObject.getDigestAlgorithmIdentifier().getAlgorithm().getId());
        }
        catch (NoSuchAlgorithmException nsae) {
            LOGGER.log(Level.WARNING, "Exception", nsae);
            return null;
        }
    }

    public String getSignerInfoDigestAlgorithm() {
        return SignedDataUtil.getSignerInfoDigestAlgorithm(this.signedData);
    }

    public String getDigestEncryptionAlgorithm() {
        return SignedDataUtil.getDigestEncryptionAlgorithm(this.signedData);
    }

    public String getLDSVersion() {
        LDSVersionInfo ldsVersionInfo = SODFile.getLDSSecurityObject(this.signedData).getVersionInfo();
        if (ldsVersionInfo == null) {
            return null;
        }
        return ldsVersionInfo.getLdsVersion();
    }

    public String getUnicodeVersion() {
        LDSVersionInfo ldsVersionInfo = SODFile.getLDSSecurityObject(this.signedData).getVersionInfo();
        if (ldsVersionInfo == null) {
            return null;
        }
        return ldsVersionInfo.getUnicodeVersion();
    }

    public List<X509Certificate> getDocSigningCertificates() {
        return SignedDataUtil.getCertificates(this.signedData);
    }

    public X509Certificate getDocSigningCertificate() {
        List<X509Certificate> certificates = this.getDocSigningCertificates();
        if (certificates == null || certificates.isEmpty()) {
            return null;
        }
        return certificates.get(certificates.size() - 1);
    }

    public X500Principal getIssuerX500Principal() {
        try {
            IssuerAndSerialNumber issuerAndSerialNumber = SignedDataUtil.getIssuerAndSerialNumber(this.signedData);
            X500Name name = issuerAndSerialNumber.getName();
            return new X500Principal(name.getEncoded("DER"));
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Could not get issuer", ioe);
            return null;
        }
    }

    public BigInteger getSerialNumber() {
        IssuerAndSerialNumber issuerAndSerialNumber = SignedDataUtil.getIssuerAndSerialNumber(this.signedData);
        return issuerAndSerialNumber.getSerialNumber().getValue();
    }

    @Override
    public String toString() {
        try {
            StringBuilder result2 = new StringBuilder();
            result2.append("SODFile ");
            List<X509Certificate> certificates = this.getDocSigningCertificates();
            for (X509Certificate certificate : certificates) {
                result2.append(certificate.getIssuerX500Principal().getName());
                result2.append(", ");
            }
            return result2.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected exception", e);
            return "SODFile";
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        SODFile other = (SODFile)obj;
        return Arrays.equals(this.getEncoded(), other.getEncoded());
    }

    public int hashCode() {
        return 11 * Arrays.hashCode(this.getEncoded()) + 111;
    }

    private static ContentInfo toContentInfo(String contentTypeOID, String digestAlgorithm, Map<Integer, byte[]> dataGroupHashes, String ldsVersion, String unicodeVersion) throws NoSuchAlgorithmException, IOException {
        DataGroupHash[] dataGroupHashesArray = new DataGroupHash[dataGroupHashes.size()];
        int i = 0;
        for (Map.Entry<Integer, byte[]> entry : dataGroupHashes.entrySet()) {
            int dataGroupNumber = entry.getKey();
            byte[] hashBytes = dataGroupHashes.get(dataGroupNumber);
            DataGroupHash hash = new DataGroupHash(dataGroupNumber, (ASN1OctetString)new DEROctetString(hashBytes));
            dataGroupHashesArray[i++] = hash;
        }
        AlgorithmIdentifier digestAlgorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic(digestAlgorithm)));
        LDSSecurityObject securityObject = null;
        securityObject = ldsVersion == null ? new LDSSecurityObject(digestAlgorithmIdentifier, dataGroupHashesArray) : new LDSSecurityObject(digestAlgorithmIdentifier, dataGroupHashesArray, new LDSVersionInfo(ldsVersion, unicodeVersion));
        return new ContentInfo(new ASN1ObjectIdentifier(contentTypeOID), (ASN1Encodable)new DEROctetString((ASN1Encodable)securityObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LDSSecurityObject getLDSSecurityObject(SignedData signedData) {
        LDSSecurityObject lDSSecurityObject;
        ContentInfo encapContentInfo = signedData.getEncapContentInfo();
        String contentType = encapContentInfo.getContentType().getId();
        DEROctetString eContent = (DEROctetString)encapContentInfo.getContent();
        if (!(ICAO_LDS_SOD_OID.equals(contentType) || SDU_LDS_SOD_OID.equals(contentType) || ICAO_LDS_SOD_ALT_OID.equals(contentType))) {
            LOGGER.warning("SignedData does not appear to contain an LDS SOd. (content type is " + contentType + ", was expecting " + ICAO_LDS_SOD_OID + ")");
        }
        ASN1InputStream inputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(eContent.getOctets()));
        try {
            ASN1Primitive firstObject = inputStream.readObject();
            if (!(firstObject instanceof ASN1Sequence)) {
                throw new IllegalStateException("Expected ASN1Sequence, found " + firstObject.getClass().getSimpleName());
            }
            LDSSecurityObject sod = LDSSecurityObject.getInstance((Object)firstObject);
            ASN1Primitive nextObject = inputStream.readObject();
            if (nextObject != null) {
                LOGGER.warning("Ignoring extra object found after LDSSecurityObject...");
            }
            lDSSecurityObject = sod;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Could not read security object in signedData", ioe);
            }
        }
        inputStream.close();
        return lDSSecurityObject;
    }
}

