/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.lds;

import com.kyc.nashidmrz.id_card.jmrtd.Util;
import com.kyc.nashidmrz.id_card.jmrtd.lds.AbstractLDSInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.ActiveAuthenticationInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.ChipAuthenticationInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.ChipAuthenticationPublicKeyInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.PACEDomainParameterInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.PACEInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.TerminalAuthenticationInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public abstract class SecurityInfo
extends AbstractLDSInfo {
    private static final long serialVersionUID = -7919854443619069808L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final String ID_AA = "2.23.136.1.1.5";
    public static final String ID_PK_DH = EACObjectIdentifiers.id_PK_DH.getId();
    public static final String ID_PK_ECDH = EACObjectIdentifiers.id_PK_ECDH.getId();
    public static final String ID_CA_DH_3DES_CBC_CBC = EACObjectIdentifiers.id_CA_DH_3DES_CBC_CBC.getId();
    public static final String ID_CA_ECDH_3DES_CBC_CBC = EACObjectIdentifiers.id_CA_ECDH_3DES_CBC_CBC.getId();
    public static final String ID_CA_DH_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.3.1.2";
    public static final String ID_CA_DH_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.3.1.3";
    public static final String ID_CA_DH_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.3.1.4";
    public static final String ID_CA_ECDH_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.3.2.2";
    public static final String ID_CA_ECDH_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.3.2.3";
    public static final String ID_CA_ECDH_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.3.2.4";
    public static final String ID_TA = EACObjectIdentifiers.id_TA.getId();
    public static final String ID_TA_RSA = EACObjectIdentifiers.id_TA_RSA.getId();
    public static final String ID_TA_RSA_V1_5_SHA_1 = EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1.getId();
    public static final String ID_TA_RSA_V1_5_SHA_256 = EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256.getId();
    public static final String ID_TA_RSA_PSS_SHA_1 = EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1.getId();
    public static final String ID_TA_RSA_PSS_SHA_256 = EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256.getId();
    public static final String ID_TA_ECDSA = EACObjectIdentifiers.id_TA_ECDSA.getId();
    public static final String ID_TA_ECDSA_SHA_1 = EACObjectIdentifiers.id_TA_ECDSA_SHA_1.getId();
    public static final String ID_TA_ECDSA_SHA_224 = EACObjectIdentifiers.id_TA_ECDSA_SHA_224.getId();
    public static final String ID_TA_ECDSA_SHA_256 = EACObjectIdentifiers.id_TA_ECDSA_SHA_256.getId();
    public static final String ID_EC_PUBLIC_KEY_TYPE = X9ObjectIdentifiers.id_publicKeyType.getId();
    public static final String ID_EC_PUBLIC_KEY = X9ObjectIdentifiers.id_ecPublicKey.getId();
    private static final String ID_BSI = "0.4.0.127.0.7";
    public static final String ID_PACE = "0.4.0.127.0.7.2.2.4";
    public static final String ID_PACE_DH_GM = "0.4.0.127.0.7.2.2.4.1";
    public static final String ID_PACE_DH_GM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.1.1";
    public static final String ID_PACE_DH_GM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.1.2";
    public static final String ID_PACE_DH_GM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.1.3";
    public static final String ID_PACE_DH_GM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.1.4";
    public static final String ID_PACE_ECDH_GM = "0.4.0.127.0.7.2.2.4.2";
    public static final String ID_PACE_ECDH_GM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.2.1";
    public static final String ID_PACE_ECDH_GM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.2.2";
    public static final String ID_PACE_ECDH_GM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.2.3";
    public static final String ID_PACE_ECDH_GM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.2.4";
    public static final String ID_PACE_DH_IM = "0.4.0.127.0.7.2.2.4.3";
    public static final String ID_PACE_DH_IM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.3.1";
    public static final String ID_PACE_DH_IM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.3.2";
    public static final String ID_PACE_DH_IM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.3.3";
    public static final String ID_PACE_DH_IM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.3.4";
    public static final String ID_PACE_ECDH_IM = "0.4.0.127.0.7.2.2.4.4";
    public static final String ID_PACE_ECDH_IM_3DES_CBC_CBC = "0.4.0.127.0.7.2.2.4.4.1";
    public static final String ID_PACE_ECDH_IM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.4.2";
    public static final String ID_PACE_ECDH_IM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.4.3";
    public static final String ID_PACE_ECDH_IM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.4.4";
    public static final String ID_PACE_ECDH_CAM = "0.4.0.127.0.7.2.2.4.6";
    public static final String ID_PACE_ECDH_CAM_AES_CBC_CMAC_128 = "0.4.0.127.0.7.2.2.4.6.2";
    public static final String ID_PACE_ECDH_CAM_AES_CBC_CMAC_192 = "0.4.0.127.0.7.2.2.4.6.3";
    public static final String ID_PACE_ECDH_CAM_AES_CBC_CMAC_256 = "0.4.0.127.0.7.2.2.4.6.4";

    @Deprecated
    public abstract ASN1Primitive getDERObject();

    @Override
    public void writeObject(OutputStream outputStream) throws IOException {
        ASN1Primitive derEncoded = this.getDERObject();
        if (derEncoded == null) {
            throw new IOException("Could not decode from DER.");
        }
        byte[] derEncodedBytes = derEncoded.getEncoded("DER");
        if (derEncodedBytes == null) {
            throw new IOException("Could not decode from DER.");
        }
        outputStream.write(derEncodedBytes);
    }

    public abstract String getObjectIdentifier();

    public abstract String getProtocolOIDString();

    public static SecurityInfo getInstance(ASN1Primitive obj) {
        try {
            ASN1Sequence sequence = (ASN1Sequence)obj;
            String oid = ((ASN1ObjectIdentifier)sequence.getObjectAt(0)).getId();
            ASN1Primitive requiredData = sequence.getObjectAt(1).toASN1Primitive();
            ASN1Primitive optionalData = null;
            if (sequence.size() == 3) {
                optionalData = sequence.getObjectAt(2).toASN1Primitive();
            }
            if (ActiveAuthenticationInfo.checkRequiredIdentifier(oid)) {
                int version = ((ASN1Integer)requiredData).getValue().intValue();
                if (optionalData == null) {
                    return new ActiveAuthenticationInfo(oid, version, null);
                }
                String signatureAlgorithmOID = ((ASN1ObjectIdentifier)optionalData).getId();
                return new ActiveAuthenticationInfo(oid, version, signatureAlgorithmOID);
            }
            if (ChipAuthenticationPublicKeyInfo.checkRequiredIdentifier(oid)) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)requiredData);
                if (optionalData == null) {
                    return new ChipAuthenticationPublicKeyInfo(oid, Util.toPublicKey(subjectPublicKeyInfo));
                }
                ASN1Integer optionalDataAsASN1Integer = (ASN1Integer)optionalData;
                BigInteger keyId = optionalDataAsASN1Integer.getValue();
                return new ChipAuthenticationPublicKeyInfo(oid, Util.toPublicKey(subjectPublicKeyInfo), keyId);
            }
            if (ChipAuthenticationInfo.checkRequiredIdentifier(oid)) {
                int version = ((ASN1Integer)requiredData).getValue().intValue();
                if (optionalData == null) {
                    return new ChipAuthenticationInfo(oid, version);
                }
                ASN1Integer optionalDataAsASN1Integer = (ASN1Integer)optionalData;
                BigInteger keyId = optionalDataAsASN1Integer.getValue();
                return new ChipAuthenticationInfo(oid, version, keyId);
            }
            if (TerminalAuthenticationInfo.checkRequiredIdentifier(oid)) {
                int version = ((ASN1Integer)requiredData).getValue().intValue();
                if (optionalData == null) {
                    return new TerminalAuthenticationInfo(oid, version);
                }
                ASN1Sequence efCVCA = (ASN1Sequence)optionalData;
                return new TerminalAuthenticationInfo(oid, version, efCVCA);
            }
            if (PACEInfo.checkRequiredIdentifier(oid)) {
                int version = ((ASN1Integer)requiredData).getValue().intValue();
                int parameterId = -1;
                if (optionalData != null) {
                    parameterId = ((ASN1Integer)optionalData).getValue().intValue();
                }
                return new PACEInfo(oid, version, parameterId);
            }
            if (PACEDomainParameterInfo.checkRequiredIdentifier(oid)) {
                AlgorithmIdentifier domainParameters = AlgorithmIdentifier.getInstance((Object)requiredData);
                if (optionalData != null) {
                    BigInteger parameterId = ((ASN1Integer)optionalData).getValue();
                    return new PACEDomainParameterInfo(oid, domainParameters, parameterId);
                }
                return new PACEDomainParameterInfo(oid, domainParameters);
            }
            LOGGER.warning("Unsupported SecurityInfo, oid = " + oid);
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected exception", e);
            throw new IllegalArgumentException("Malformed input stream.");
        }
    }
}

