/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.lds.iso19794;

import com.kyc.nashidmrz.id_card.jmrtd.lds.AbstractListInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.iso19794.IrisImageInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class IrisBiometricSubtypeInfo
extends AbstractListInfo<IrisImageInfo> {
    private static final long serialVersionUID = -6588640634764878039L;
    public static final int EYE_UNDEF = 0;
    public static final int EYE_RIGHT = 1;
    public static final int EYE_LEFT = 2;
    private final int imageFormat;
    private int biometricSubtype;

    public IrisBiometricSubtypeInfo(int biometricSubtype, int imageFormat, List<IrisImageInfo> irisImageInfos) {
        this.biometricSubtype = biometricSubtype;
        this.imageFormat = imageFormat;
        this.addAll(irisImageInfos);
    }

    public IrisBiometricSubtypeInfo(InputStream in, int imageFormat) throws IOException {
        this.imageFormat = imageFormat;
        this.readObject(in);
    }

    @Override
    public void readObject(InputStream inputStream) throws IOException {
        DataInputStream dataIn = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.biometricSubtype = dataIn.readUnsignedByte();
        int count = dataIn.readUnsignedShort();
        long constructedDataLength = 0L;
        for (int i = 0; i < count; ++i) {
            IrisImageInfo imageInfo = new IrisImageInfo(inputStream, this.imageFormat);
            constructedDataLength += imageInfo.getRecordLength();
            this.add(imageInfo);
        }
    }

    @Override
    public void writeObject(OutputStream outputStream) throws IOException {
        DataOutputStream dataOut = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        dataOut.writeByte(this.biometricSubtype & 0xFF);
        List irisImageInfos = this.getSubRecords();
        dataOut.writeShort(irisImageInfos.size() & 0xFFFF);
        for (IrisImageInfo irisImageInfo : irisImageInfos) {
            irisImageInfo.writeObject(dataOut);
        }
    }

    public long getRecordLength() {
        long result2 = 3L;
        List irisImageInfos = this.getSubRecords();
        for (IrisImageInfo irisImageInfo : irisImageInfos) {
            result2 += irisImageInfo.getRecordLength();
        }
        return result2;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.biometricSubtype;
        result2 = 31 * result2 + this.imageFormat;
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IrisBiometricSubtypeInfo other = (IrisBiometricSubtypeInfo)obj;
        return this.biometricSubtype == other.biometricSubtype && this.imageFormat == other.imageFormat;
    }

    public String toString() {
        List irisImageInfos = this.getSubRecords();
        return "IrisBiometricSubtypeInfo [biometric subtype: " + IrisBiometricSubtypeInfo.biometricSubtypeToString(this.biometricSubtype) + ", imageCount = " + irisImageInfos.size() + "]";
    }

    public int getBiometricSubtype() {
        return this.biometricSubtype;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public List<IrisImageInfo> getIrisImageInfos() {
        return this.getSubRecords();
    }

    public void addIrisImageInfo(IrisImageInfo irisImageInfo) {
        this.add(irisImageInfo);
    }

    public void removeIrisImageInfo(int index) {
        this.remove(index);
    }

    private static String biometricSubtypeToString(int biometricSubtype) {
        switch (biometricSubtype) {
            case 2: {
                return "Left eye";
            }
            case 1: {
                return "Right eye";
            }
            case 0: {
                return "Undefined";
            }
        }
        throw new NumberFormatException("Unknown biometric subtype: " + Integer.toHexString(biometricSubtype));
    }
}

