/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.lds.iso19794;

import com.kyc.nashidmrz.id_card.jmrtd.cbeff.BiometricDataBlock;
import com.kyc.nashidmrz.id_card.jmrtd.cbeff.StandardBiometricHeader;
import com.kyc.nashidmrz.id_card.jmrtd.lds.AbstractListInfo;
import com.kyc.nashidmrz.id_card.jmrtd.lds.iso19794.IrisBiometricSubtypeInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;

public class IrisInfo
extends AbstractListInfo<IrisBiometricSubtypeInfo>
implements BiometricDataBlock {
    private static final long serialVersionUID = -3415309711643815511L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private static final int FORMAT_IDENTIFIER = 1229541888;
    private static final int VERSION_NUMBER = 0x30313000;
    private static final int FORMAT_OWNER_VALUE = 257;
    private static final int FORMAT_TYPE_VALUE = 9;
    public static final int IMAGEFORMAT_MONO_RAW = 2;
    public static final int IMAGEFORMAT_RGB_RAW = 4;
    public static final int IMAGEFORMAT_MONO_JPEG = 6;
    public static final int IMAGEFORMAT_RGB_JPEG = 8;
    public static final int IMAGEFORMAT_MONO_JPEG_LS = 10;
    public static final int IMAGEFORMAT_RGB_JPEG_LS = 12;
    public static final int IMAGEFORMAT_MONO_JPEG2000 = 14;
    public static final int IMAGEFORMAT_RGB_JPEG2000 = 16;
    public static final int CAPTURE_DEVICE_UNDEF = 0;
    public static final int ORIENTATION_UNDEF = 0;
    public static final int ORIENTATION_BASE = 1;
    public static final int ORIENTATION_FLIPPED = 2;
    public static final int SCAN_TYPE_UNDEF = 0;
    public static final int SCAN_TYPE_PROGRESSIVE = 1;
    public static final int SCAN_TYPE_INTERLACE_FRAME = 2;
    public static final int SCAN_TYPE_INTERLACE_FIELD = 3;
    public static final int SCAN_TYPE_CORRECTED = 4;
    public static final int IROCC_UNDEF = 0;
    public static final int IROCC_PROCESSED = 1;
    public static final int IROCC_ZEROFILL = 0;
    public static final int IROC_UNITFILL = 1;
    public static final int INTENSITY_DEPTH_UNDEF = 0;
    public static final int TRANS_UNDEF = 0;
    public static final int TRANS_STD = 1;
    public static final int IRBNDY_UNDEF = 0;
    public static final int IRBNDY_PROCESSED = 1;
    private long recordLength;
    private int captureDeviceId;
    private int horizontalOrientation;
    private int verticalOrientation;
    private int scanType;
    private int irisOcclusion;
    private int occlusionFilling;
    private int boundaryExtraction;
    private int irisDiameter;
    private int imageFormat;
    private int rawImageWidth;
    private int rawImageHeight;
    private int intensityDepth;
    private int imageTransformation;
    private byte[] deviceUniqueId;
    private StandardBiometricHeader sbh;

    public IrisInfo(int captureDeviceId, int horizontalOrientation, int verticalOrientation, int scanType, int irisOcclusion, int occlusionFilling, int boundaryExtraction, int irisDiameter, int imageFormat, int rawImageWidth, int rawImageHeight, int intensityDepth, int imageTransformation, byte[] deviceUniqueId, List<IrisBiometricSubtypeInfo> irisBiometricSubtypeInfos) {
        this(null, captureDeviceId, horizontalOrientation, verticalOrientation, scanType, irisOcclusion, occlusionFilling, boundaryExtraction, irisDiameter, imageFormat, rawImageWidth, rawImageHeight, intensityDepth, imageTransformation, deviceUniqueId, irisBiometricSubtypeInfos);
    }

    public IrisInfo(StandardBiometricHeader sbh, int captureDeviceId, int horizontalOrientation, int verticalOrientation, int scanType, int irisOcclusion, int occlusionFilling, int boundaryExtraction, int irisDiameter, int imageFormat, int rawImageWidth, int rawImageHeight, int intensityDepth, int imageTransformation, byte[] deviceUniqueId, List<IrisBiometricSubtypeInfo> irisBiometricSubtypeInfos) {
        this.sbh = sbh;
        if (irisBiometricSubtypeInfos == null) {
            throw new IllegalArgumentException("Null irisBiometricSubtypeInfos");
        }
        this.captureDeviceId = captureDeviceId;
        this.horizontalOrientation = horizontalOrientation;
        this.verticalOrientation = verticalOrientation;
        this.scanType = scanType;
        this.irisOcclusion = irisOcclusion;
        this.occlusionFilling = occlusionFilling;
        this.boundaryExtraction = boundaryExtraction;
        this.irisDiameter = irisDiameter;
        this.imageFormat = imageFormat;
        this.rawImageWidth = rawImageWidth;
        this.rawImageHeight = rawImageHeight;
        this.intensityDepth = intensityDepth;
        this.imageTransformation = imageTransformation;
        long headerLength = 45L;
        long dataLength = 0L;
        for (IrisBiometricSubtypeInfo irisBiometricSubtypeInfo : irisBiometricSubtypeInfos) {
            dataLength += irisBiometricSubtypeInfo.getRecordLength();
            this.add(irisBiometricSubtypeInfo);
        }
        if (deviceUniqueId == null || deviceUniqueId.length != 16) {
            throw new IllegalArgumentException("deviceUniqueId invalid");
        }
        this.deviceUniqueId = new byte[16];
        System.arraycopy(deviceUniqueId, 0, this.deviceUniqueId, 0, deviceUniqueId.length);
        this.recordLength = headerLength + dataLength;
    }

    public IrisInfo(InputStream inputStream) throws IOException {
        this(null, inputStream);
    }

    public IrisInfo(StandardBiometricHeader sbh, InputStream inputStream) throws IOException {
        this.sbh = sbh;
        this.readObject(inputStream);
    }

    @Override
    public void readObject(InputStream inputStream) throws IOException {
        DataInputStream dataIn = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        int iir0 = dataIn.readInt();
        if (iir0 != 1229541888) {
            throw new IllegalArgumentException("'IIR' marker expected! Found " + Integer.toHexString(iir0));
        }
        int version = dataIn.readInt();
        if (version != 0x30313000) {
            throw new IllegalArgumentException("'010' version number expected! Found " + Integer.toHexString(version));
        }
        this.recordLength = dataIn.readInt();
        long headerLength = 45L;
        long dataLength = this.recordLength - headerLength;
        this.captureDeviceId = dataIn.readUnsignedShort();
        int count = dataIn.readUnsignedByte();
        int recordHeaderLength = dataIn.readUnsignedShort();
        if ((long)recordHeaderLength != headerLength) {
            throw new IllegalArgumentException("Expected header length " + headerLength + ", found " + recordHeaderLength);
        }
        int imagePropertiesBits = dataIn.readUnsignedShort();
        this.horizontalOrientation = imagePropertiesBits & 3;
        this.verticalOrientation = (imagePropertiesBits & 0xC) >> 2;
        this.scanType = (imagePropertiesBits & 0x70) >> 4;
        this.irisOcclusion = (imagePropertiesBits & 0x80) >> 7;
        this.occlusionFilling = (imagePropertiesBits & 0x100) >> 8;
        this.boundaryExtraction = (imagePropertiesBits & 0x200) >> 9;
        this.irisDiameter = dataIn.readUnsignedShort();
        this.imageFormat = dataIn.readUnsignedShort();
        this.rawImageWidth = dataIn.readUnsignedShort();
        this.rawImageHeight = dataIn.readUnsignedShort();
        this.intensityDepth = dataIn.readUnsignedByte();
        this.imageTransformation = dataIn.readUnsignedByte();
        this.deviceUniqueId = new byte[16];
        dataIn.readFully(this.deviceUniqueId);
        long constructedDataLength = 0L;
        for (int i = 0; i < count; ++i) {
            IrisBiometricSubtypeInfo biometricSubtypeInfo = new IrisBiometricSubtypeInfo(inputStream, this.imageFormat);
            constructedDataLength += biometricSubtypeInfo.getRecordLength();
            this.add(biometricSubtypeInfo);
        }
        if (dataLength != constructedDataLength) {
            LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + dataLength + ", constructedDataLength = " + constructedDataLength);
        }
    }

    @Override
    public void writeObject(OutputStream outputStream) throws IOException {
        int headerLength = 45;
        int dataLength = 0;
        List biometricSubtypeInfos = this.getSubRecords();
        for (IrisBiometricSubtypeInfo biometricSubtypeInfo : biometricSubtypeInfos) {
            dataLength = (int)((long)dataLength + biometricSubtypeInfo.getRecordLength());
        }
        int recordLength = headerLength + dataLength;
        DataOutputStream dataOut = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        dataOut.writeInt(1229541888);
        dataOut.writeInt(0x30313000);
        dataOut.writeInt(recordLength);
        dataOut.writeShort(this.captureDeviceId);
        dataOut.writeByte(biometricSubtypeInfos.size());
        dataOut.writeShort(headerLength);
        int imagePropertiesBits = 0;
        imagePropertiesBits |= this.horizontalOrientation & 3;
        imagePropertiesBits |= this.verticalOrientation << 2 & 0xC;
        imagePropertiesBits |= this.scanType << 4 & 0x70;
        imagePropertiesBits |= this.irisOcclusion << 7 & 0x80;
        imagePropertiesBits |= this.occlusionFilling << 8 & 0x100;
        dataOut.writeShort(imagePropertiesBits |= this.boundaryExtraction << 9 & 0x200);
        dataOut.writeShort(this.irisDiameter);
        dataOut.writeShort(this.imageFormat);
        dataOut.writeShort(this.rawImageWidth);
        dataOut.writeShort(this.rawImageHeight);
        dataOut.writeByte(this.intensityDepth);
        dataOut.writeByte(this.imageTransformation);
        dataOut.write(this.deviceUniqueId);
        for (IrisBiometricSubtypeInfo biometricSubtypeInfo : biometricSubtypeInfos) {
            biometricSubtypeInfo.writeObject(outputStream);
        }
    }

    public int getCaptureDeviceId() {
        return this.captureDeviceId;
    }

    public int getHorizontalOrientation() {
        return this.horizontalOrientation;
    }

    public int getVerticalOrientation() {
        return this.verticalOrientation;
    }

    public int getScanType() {
        return this.scanType;
    }

    public int getIrisOcclusion() {
        return this.irisOcclusion;
    }

    public int getOcclusionFilling() {
        return this.occlusionFilling;
    }

    public int getBoundaryExtraction() {
        return this.boundaryExtraction;
    }

    public int getIrisDiameter() {
        return this.irisDiameter;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public int getRawImageWidth() {
        return this.rawImageWidth;
    }

    public int getRawImageHeight() {
        return this.rawImageHeight;
    }

    public int getIntensityDepth() {
        return this.intensityDepth;
    }

    public int getImageTransformation() {
        return this.imageTransformation;
    }

    public byte[] getDeviceUniqueId() {
        return this.deviceUniqueId;
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            byte[] biometricType = new byte[]{8};
            byte[] biometricSubtype = new byte[]{(byte)this.getBiometricSubtype()};
            byte[] formatOwner = new byte[]{1, 1};
            byte[] formatType = new byte[]{0, 9};
            TreeMap<Integer, byte[]> elements = new TreeMap<Integer, byte[]>();
            elements.put(129, biometricType);
            elements.put(130, biometricSubtype);
            elements.put(135, formatOwner);
            elements.put(136, formatType);
            this.sbh = new StandardBiometricHeader(elements);
        }
        return this.sbh;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.boundaryExtraction;
        result2 = 31 * result2 + this.captureDeviceId;
        result2 = 31 * result2 + Arrays.hashCode(this.deviceUniqueId);
        result2 = 31 * result2 + this.horizontalOrientation;
        result2 = 31 * result2 + this.imageFormat;
        result2 = 31 * result2 + this.imageTransformation;
        result2 = 31 * result2 + this.intensityDepth;
        result2 = 31 * result2 + this.irisDiameter;
        result2 = 31 * result2 + this.irisOcclusion;
        result2 = 31 * result2 + this.occlusionFilling;
        result2 = 31 * result2 + this.rawImageHeight;
        result2 = 31 * result2 + this.rawImageWidth;
        result2 = 31 * result2 + (int)(this.recordLength ^ this.recordLength >>> 32);
        result2 = 31 * result2 + (this.sbh == null ? 0 : this.sbh.hashCode());
        result2 = 31 * result2 + this.scanType;
        result2 = 31 * result2 + this.verticalOrientation;
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IrisInfo other = (IrisInfo)obj;
        if (this.sbh == null ? other.sbh != null : !this.sbh.equals(other.sbh)) {
            return false;
        }
        if (this.boundaryExtraction != other.boundaryExtraction) {
            return false;
        }
        if (this.captureDeviceId != other.captureDeviceId) {
            return false;
        }
        if (!Arrays.equals(this.deviceUniqueId, other.deviceUniqueId)) {
            return false;
        }
        if (this.horizontalOrientation != other.horizontalOrientation) {
            return false;
        }
        if (this.imageFormat != other.imageFormat) {
            return false;
        }
        if (this.imageTransformation != other.imageTransformation) {
            return false;
        }
        if (this.intensityDepth != other.intensityDepth) {
            return false;
        }
        if (this.irisDiameter != other.irisDiameter) {
            return false;
        }
        if (this.irisOcclusion != other.irisOcclusion) {
            return false;
        }
        if (this.occlusionFilling != other.occlusionFilling) {
            return false;
        }
        if (this.rawImageHeight != other.rawImageHeight) {
            return false;
        }
        if (this.rawImageWidth != other.rawImageWidth) {
            return false;
        }
        if (this.recordLength != other.recordLength) {
            return false;
        }
        if (this.scanType != other.scanType) {
            return false;
        }
        return this.verticalOrientation == other.verticalOrientation;
    }

    public String toString() {
        String result2 = "IrisInfo []";
        return result2;
    }

    public List<IrisBiometricSubtypeInfo> getIrisBiometricSubtypeInfos() {
        return this.getSubRecords();
    }

    public void addIrisBiometricSubtypeInfo(IrisBiometricSubtypeInfo irisBiometricSubtypeInfo) {
        this.add(irisBiometricSubtypeInfo);
    }

    public void removeIrisBiometricSubtypeInfo(int index) {
        this.remove(index);
    }

    private int getBiometricSubtype() {
        int result2 = 0;
        List irisBiometricSubtypeInfos = this.getSubRecords();
        for (IrisBiometricSubtypeInfo irisBiometricSubtypeInfo : irisBiometricSubtypeInfos) {
            result2 &= irisBiometricSubtypeInfo.getBiometricSubtype();
        }
        return result2;
    }
}

