/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.APDULevelAACapable;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.AAResult;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.SecureMessagingWrapper;
import java.security.PublicKey;
import net.sf.scuba.smartcards.CardServiceException;

public class AAProtocol {
    private final APDULevelAACapable service;
    private final SecureMessagingWrapper wrapper;

    public AAProtocol(APDULevelAACapable service, SecureMessagingWrapper wrapper) {
        this.service = service;
        this.wrapper = wrapper;
    }

    public AAResult doAA(PublicKey publicKey, String digestAlgorithm, String signatureAlgorithm, byte[] challenge) throws CardServiceException {
        try {
            if (challenge == null || challenge.length != 8) {
                throw new IllegalArgumentException("AA failed: bad challenge");
            }
            byte[] response = this.service.sendInternalAuthenticate(this.wrapper, challenge);
            return new AAResult(publicKey, digestAlgorithm, signatureAlgorithm, challenge, response);
        }
        catch (IllegalArgumentException iae) {
            throw new CardServiceException("Exception", (Throwable)iae);
        }
    }
}

