/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.APDULevelBACCapable;
import com.kyc.nashidmrz.id_card.jmrtd.AccessDeniedException;
import com.kyc.nashidmrz.id_card.jmrtd.Util;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;

public class BACAPDUSender
implements APDULevelBACCapable {
    private static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    private static final IvParameterSpec ZERO_IV_PARAM_SPEC = new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
    private final CardService service;
    private final Cipher cipher;
    private final Mac mac;

    public BACAPDUSender(CardService service) {
        this.service = service;
        try {
            this.mac = Mac.getInstance("ISO9797Alg3Mac", BC_PROVIDER);
            this.cipher = Util.getCipher("DESede/CBC/NoPadding");
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("Unexpected security exception during initialization", gse);
        }
    }

    @Override
    public synchronized byte[] sendGetChallenge() throws CardServiceException {
        return this.sendGetChallenge(null);
    }

    public synchronized byte[] sendGetChallenge(APDUWrapper wrapper) throws CardServiceException {
        CommandAPDU capdu = new CommandAPDU(0, -124, 0, 0, 8);
        ResponseAPDU rapdu = this.service.transmit(capdu);
        return rapdu.getData();
    }

    @Override
    public synchronized byte[] sendMutualAuth(byte[] rndIFD, byte[] rndICC, byte[] kIFD, SecretKey kEnc, SecretKey kMac) throws CardServiceException {
        try {
            if (rndIFD == null || rndIFD.length != 8) {
                throw new IllegalArgumentException("rndIFD wrong length");
            }
            if (rndICC == null || rndICC.length != 8) {
                rndICC = new byte[8];
            }
            if (kIFD == null || kIFD.length != 16) {
                throw new IllegalArgumentException("kIFD wrong length");
            }
            if (kEnc == null) {
                throw new IllegalArgumentException("kEnc == null");
            }
            if (kMac == null) {
                throw new IllegalArgumentException("kMac == null");
            }
            this.cipher.init(1, (Key)kEnc, ZERO_IV_PARAM_SPEC);
            byte[] plaintext = new byte[32];
            System.arraycopy(rndIFD, 0, plaintext, 0, 8);
            System.arraycopy(rndICC, 0, plaintext, 8, 8);
            System.arraycopy(kIFD, 0, plaintext, 16, 16);
            byte[] ciphertext = this.cipher.doFinal(plaintext);
            if (ciphertext.length != 32) {
                throw new IllegalStateException("Cryptogram wrong length " + ciphertext.length);
            }
            this.mac.init(kMac);
            byte[] mactext = this.mac.doFinal(Util.pad(ciphertext, 8));
            if (mactext.length != 8) {
                throw new IllegalStateException("MAC wrong length");
            }
            int p1 = 0;
            int p2 = 0;
            byte[] data = new byte[40];
            System.arraycopy(ciphertext, 0, data, 0, 32);
            System.arraycopy(mactext, 0, data, 32, 8);
            int le = 40;
            CommandAPDU capdu = new CommandAPDU(0, -126, p1, p2, data, le);
            ResponseAPDU rapdu = this.service.transmit(capdu);
            if (rapdu == null) {
                throw new CardServiceException("Mutual authentication failed, received null response APDU");
            }
            byte[] rapduBytes = rapdu.getBytes();
            short sw = (short)rapdu.getSW();
            if (rapduBytes == null) {
                throw new CardServiceException("Mutual authentication failed, received empty data in response APDU", (int)sw);
            }
            if (sw != -28672) {
                le = 0;
                capdu = new CommandAPDU(0, -126, p1, p2, data, le);
                rapdu = this.service.transmit(capdu);
                rapduBytes = rapdu.getBytes();
                sw = (short)rapdu.getSW();
            }
            if (rapduBytes.length != 42) {
                throw new AccessDeniedException("Mutual authentication failed: expected length: 40 + 2, actual length: " + rapduBytes.length, sw);
            }
            this.cipher.init(2, (Key)kEnc, ZERO_IV_PARAM_SPEC);
            byte[] result2 = this.cipher.doFinal(rapduBytes, 0, rapduBytes.length - 8 - 2);
            if (result2.length != 32) {
                throw new CardServiceException("Cryptogram wrong length, was expecting 32, found " + result2.length, (int)sw);
            }
            return result2;
        }
        catch (GeneralSecurityException gse) {
            throw new CardServiceException("Security exception during mutual auth", (Throwable)gse);
        }
    }
}

