/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.APDULevelBACCapable;
import com.kyc.nashidmrz.id_card.jmrtd.AccessKeySpec;
import com.kyc.nashidmrz.id_card.jmrtd.BACKeySpec;
import com.kyc.nashidmrz.id_card.jmrtd.Util;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.BACResult;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.DESedeSecureMessagingWrapper;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.SecureMessagingWrapper;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.SecretKey;
import net.sf.scuba.smartcards.CardServiceException;

public class BACProtocol {
    private final APDULevelBACCapable service;
    private final Random random;
    private final int maxTranceiveLength;
    private final boolean shouldCheckMAC;

    public BACProtocol(APDULevelBACCapable service, int maxTranceiveLength, boolean shouldCheckMAC) {
        this.service = service;
        this.maxTranceiveLength = maxTranceiveLength;
        this.shouldCheckMAC = shouldCheckMAC;
        this.random = new SecureRandom();
    }

    public BACResult doBAC(AccessKeySpec bacKey) throws CardServiceException {
        try {
            byte[] keySeed = bacKey.getKey();
            SecretKey kEnc = Util.deriveKey(keySeed, 1);
            SecretKey kMac = Util.deriveKey(keySeed, 2);
            SecureMessagingWrapper wrapper = this.doBACStep(kEnc, kMac);
            return new BACResult(bacKey, wrapper);
        }
        catch (GeneralSecurityException gse) {
            throw new CardServiceException("Error during BAC", (Throwable)gse);
        }
    }

    public BACResult doBAC(SecretKey kEnc, SecretKey kMac) throws CardServiceException, GeneralSecurityException {
        return new BACResult(this.doBACStep(kEnc, kMac));
    }

    private SecureMessagingWrapper doBACStep(SecretKey kEnc, SecretKey kMac) throws CardServiceException, GeneralSecurityException {
        byte[] rndICC = this.service.sendGetChallenge();
        byte[] rndIFD = new byte[8];
        this.random.nextBytes(rndIFD);
        byte[] kIFD = new byte[16];
        this.random.nextBytes(kIFD);
        byte[] response = this.service.sendMutualAuth(rndIFD, rndICC, kIFD, kEnc, kMac);
        byte[] kICC = new byte[16];
        System.arraycopy(response, 16, kICC, 0, 16);
        byte[] keySeed = new byte[16];
        for (int i = 0; i < 16; ++i) {
            keySeed[i] = (byte)(kIFD[i] & 0xFF ^ kICC[i] & 0xFF);
        }
        SecretKey ksEnc = Util.deriveKey(keySeed, 1);
        SecretKey ksMac = Util.deriveKey(keySeed, 2);
        long ssc = BACProtocol.computeSendSequenceCounter(rndICC, rndIFD);
        return new DESedeSecureMessagingWrapper(ksEnc, ksMac, this.maxTranceiveLength, this.shouldCheckMAC, ssc);
    }

    public static byte[] computeKeySeedForBAC(BACKeySpec bacKey) throws GeneralSecurityException {
        String documentNumber = bacKey.getDocumentNumber();
        String dateOfBirth = bacKey.getDateOfBirth();
        String dateOfExpiry = bacKey.getDateOfExpiry();
        if (dateOfBirth == null || dateOfBirth.length() != 6) {
            throw new IllegalArgumentException("Wrong date format used for date of birth. Expected yyMMdd, found " + dateOfBirth);
        }
        if (dateOfExpiry == null || dateOfExpiry.length() != 6) {
            throw new IllegalArgumentException("Wrong date format used for date of expiry. Expected yyMMdd, found " + dateOfExpiry);
        }
        if (documentNumber == null) {
            throw new IllegalArgumentException("Wrong document number. Found " + documentNumber);
        }
        documentNumber = BACProtocol.fixDocumentNumber(documentNumber);
        return BACProtocol.computeKeySeedForBAC(documentNumber, dateOfBirth, dateOfExpiry);
    }

    public static long computeSendSequenceCounter(byte[] rndICC, byte[] rndIFD) {
        int i;
        if (rndICC == null || rndICC.length != 8 || rndIFD == null || rndIFD.length != 8) {
            throw new IllegalStateException("Wrong length input");
        }
        long ssc = 0L;
        for (i = 4; i < 8; ++i) {
            ssc <<= 8;
            ssc += (long)(rndICC[i] & 0xFF);
        }
        for (i = 4; i < 8; ++i) {
            ssc <<= 8;
            ssc += (long)(rndIFD[i] & 0xFF);
        }
        return ssc;
    }

    private static byte[] computeKeySeedForBAC(String documentNumber, String dateOfBirth, String dateOfExpiry) throws GeneralSecurityException {
        return Util.computeKeySeed(documentNumber, dateOfBirth, dateOfExpiry, "SHA-1", true);
    }

    private static String fixDocumentNumber(String documentNumber) {
        StringBuilder maxDocumentNumber = new StringBuilder(documentNumber == null ? "" : documentNumber.replace('<', ' ').trim().replace(' ', '<'));
        while (maxDocumentNumber.length() < 9) {
            maxDocumentNumber.append('<');
        }
        return maxDocumentNumber.toString();
    }
}

