/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.APDULevelEACCACapable;
import com.kyc.nashidmrz.id_card.jmrtd.Util;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.SecureMessagingAPDUSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.tlv.TLVUtil;

public class EACCAAPDUSender
implements APDULevelEACCACapable {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    private static final byte INS_BSI_GENERAL_AUTHENTICATE = -122;
    private final SecureMessagingAPDUSender secureMessagingSender;

    public EACCAAPDUSender(CardService service) {
        this.secureMessagingSender = new SecureMessagingAPDUSender(service);
    }

    @Override
    public synchronized void sendMSEKAT(APDUWrapper wrapper, byte[] keyData, byte[] idData) throws CardServiceException {
        byte[] data = new byte[keyData.length + (idData != null ? idData.length : 0)];
        System.arraycopy(keyData, 0, data, 0, keyData.length);
        if (idData != null) {
            System.arraycopy(idData, 0, data, keyData.length, idData.length);
        }
        CommandAPDU commandAPDU = new CommandAPDU(0, 34, 65, 166, data);
        byte[] commandAPDUBytes = commandAPDU.getBytes();
        ResponseAPDU responseAPDU = this.secureMessagingSender.transmit(wrapper, commandAPDU);
        short sw = (short)responseAPDU.getSW();
        if (sw != -28672) {
            throw new CardServiceException("Sending MSE KAT failed", (int)sw);
        }
    }

    @Override
    public synchronized void sendMSESetATIntAuth(APDUWrapper wrapper, String oid, BigInteger keyId) throws CardServiceException {
        int sw;
        int p1 = 65;
        int p2 = 164;
        ResponseAPDU rapdu = null;
        if (keyId == null || keyId.compareTo(BigInteger.ZERO) < 0) {
            CommandAPDU capdu = new CommandAPDU(0, 34, p1, p2, Util.toOIDBytes(oid));
            rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        } else {
            byte[] oidBytes = Util.toOIDBytes(oid);
            byte[] keyIdBytes = TLVUtil.wrapDO((int)132, (byte[])Util.i2os(keyId));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(oidBytes);
                byteArrayOutputStream.write(keyIdBytes);
                byteArrayOutputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Exception", ioe);
            }
            CommandAPDU capdu = new CommandAPDU(0, 34, p1, p2, byteArrayOutputStream.toByteArray());
            rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        }
        short s = (short)(sw = (short)(rapdu == null ? -1 : (short)rapdu.getSW()));
        if (sw != -28672) {
            throw new CardServiceException("Sending MSE AT failed", sw);
        }
    }

    @Override
    public synchronized byte[] sendGeneralAuthenticate(APDUWrapper wrapper, byte[] data, boolean isLast) throws CardServiceException {
        byte[] commandData;
        CommandAPDU capdu = new CommandAPDU(isLast ? 0 : 16, -122, 0, 0, commandData = TLVUtil.wrapDO((int)124, (byte[])data), 4);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        short sw = (short)rapdu.getSW();
        if (sw == 26368) {
            capdu = new CommandAPDU(isLast ? 0 : 16, -122, 0, 0, commandData, 256);
            rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        }
        if (sw != -28672) {
            throw new CardServiceException("Sending general authenticate failed", (int)sw);
        }
        byte[] responseData = rapdu.getData();
        try {
            responseData = TLVUtil.unwrapDO((int)124, (byte[])responseData);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not unwrap response to GENERAL AUTHENTICATE", e);
        }
        return responseData;
    }
}

