/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.Util;
import com.kyc.nashidmrz.id_card.jmrtd.cert.CVCPrincipal;
import com.kyc.nashidmrz.id_card.jmrtd.cert.CardVerifiableCertificate;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.EACCAResult;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.util.Hex;

public class EACTAResult
implements Serializable {
    private static final long serialVersionUID = -2926063872890928748L;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    private final EACCAResult chipAuthenticationResult;
    private final CVCPrincipal caReference;
    private final List<CardVerifiableCertificate> terminalCertificates = new ArrayList<CardVerifiableCertificate>();
    private final PrivateKey terminalKey;
    private final String documentNumber;
    private final byte[] cardChallenge;

    public EACTAResult(EACCAResult caResult, CVCPrincipal caReference, List<CardVerifiableCertificate> terminalCertificates, PrivateKey terminalKey, String documentNumber, byte[] cardChallenge) {
        this.chipAuthenticationResult = caResult;
        this.caReference = caReference;
        for (CardVerifiableCertificate terinalCertificate : terminalCertificates) {
            this.terminalCertificates.add(terinalCertificate);
        }
        this.terminalKey = terminalKey;
        this.documentNumber = documentNumber;
        this.cardChallenge = cardChallenge;
    }

    public EACCAResult getChipAuthenticationResult() {
        return this.chipAuthenticationResult;
    }

    public CVCPrincipal getCAReference() {
        return this.caReference;
    }

    public List<CardVerifiableCertificate> getCVCertificates() {
        return this.terminalCertificates;
    }

    public PrivateKey getTerminalKey() {
        return this.terminalKey;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public byte[] getCardChallenge() {
        return this.cardChallenge;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("TAResult [chipAuthenticationResult: " + this.chipAuthenticationResult).append(", ");
        result2.append("caReference: " + this.caReference).append(", ");
        result2.append("terminalCertificates: [");
        boolean isFirst = true;
        for (CardVerifiableCertificate cert : this.terminalCertificates) {
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(", ");
            }
            result2.append(this.toString(cert));
        }
        result2.append("terminalKey = ").append(Util.getDetailedPrivateKeyAlgorithm(this.terminalKey)).append(", ");
        result2.append("documentNumber = ").append(this.documentNumber).append(", ");
        result2.append("cardChallenge = ").append(Hex.bytesToHexString((byte[])this.cardChallenge)).append(", ");
        result2.append("]");
        return result2.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.caReference == null ? 0 : this.caReference.hashCode());
        result2 = 31 * result2 + Arrays.hashCode(this.cardChallenge);
        result2 = 31 * result2 + (this.chipAuthenticationResult == null ? 0 : this.chipAuthenticationResult.hashCode());
        result2 = 31 * result2 + (this.documentNumber == null ? 0 : this.documentNumber.hashCode());
        result2 = 31 * result2 + (this.terminalCertificates == null ? 0 : this.terminalCertificates.hashCode());
        result2 = 31 * result2 + (this.terminalKey == null ? 0 : this.terminalKey.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EACTAResult other = (EACTAResult)obj;
        if (this.caReference == null ? other.caReference != null : !this.caReference.equals(other.caReference)) {
            return false;
        }
        if (!Arrays.equals(this.cardChallenge, other.cardChallenge)) {
            return false;
        }
        if (this.chipAuthenticationResult == null ? other.chipAuthenticationResult != null : !this.chipAuthenticationResult.equals(other.chipAuthenticationResult)) {
            return false;
        }
        if (this.documentNumber == null ? other.documentNumber != null : !this.documentNumber.equals(other.documentNumber)) {
            return false;
        }
        if (this.terminalCertificates == null ? other.terminalCertificates != null : !this.terminalCertificates.equals(other.terminalCertificates)) {
            return false;
        }
        if (this.terminalKey == null) {
            return other.terminalKey == null;
        }
        return this.terminalKey.equals(other.terminalKey);
    }

    private Object toString(CardVerifiableCertificate certificate) {
        StringBuilder result2 = new StringBuilder();
        result2.append("CardVerifiableCertificate [");
        try {
            CVCPrincipal reference = certificate.getHolderReference();
            if (!this.caReference.equals(reference)) {
                result2.append("holderReference: " + reference);
            }
        }
        catch (CertificateException ce) {
            result2.append("holderReference = ???");
            LOGGER.log(Level.WARNING, "Exception", ce);
        }
        result2.append("]");
        return result2.toString();
    }
}

