/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.APDULevelPACECapable;
import com.kyc.nashidmrz.id_card.jmrtd.AccessDeniedException;
import com.kyc.nashidmrz.id_card.jmrtd.Util;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.SecureMessagingAPDUSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.tlv.TLVUtil;

public class PACEAPDUSender
implements APDULevelPACECapable {
    public static final byte NO_PACE_KEY_REFERENCE = 0;
    public static final byte MRZ_PACE_KEY_REFERENCE = 1;
    public static final byte CAN_PACE_KEY_REFERENCE = 2;
    public static final byte PIN_PACE_KEY_REFERENCE = 3;
    public static final byte PUK_PACE_KEY_REFERENCE = 4;
    private static final byte INS_PACE_GENERAL_AUTHENTICATE = -122;
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    private final SecureMessagingAPDUSender secureMessagingSender;

    public PACEAPDUSender(CardService service) {
        this.secureMessagingSender = new SecureMessagingAPDUSender(service);
    }

    @Override
    public synchronized void sendMSESetATMutualAuth(APDUWrapper wrapper, String oid, int refPublicKeyOrSecretKey, byte[] refPrivateKeyOrForComputingSessionKey) throws CardServiceException {
        if (oid == null) {
            throw new IllegalArgumentException("OID cannot be null");
        }
        byte[] oidBytes = Util.toOIDBytes(oid);
        if (refPublicKeyOrSecretKey != 1 && refPublicKeyOrSecretKey != 2 && refPublicKeyOrSecretKey != 3 && refPublicKeyOrSecretKey != 4) {
            throw new IllegalArgumentException("Unsupported key type reference (MRZ, CAN, etc), found " + refPublicKeyOrSecretKey);
        }
        byte[] refPublicKeyOrSecretKeyBytes = TLVUtil.wrapDO((int)131, (byte[])new byte[]{(byte)refPublicKeyOrSecretKey});
        if (refPrivateKeyOrForComputingSessionKey != null) {
            refPrivateKeyOrForComputingSessionKey = TLVUtil.wrapDO((int)132, (byte[])refPrivateKeyOrForComputingSessionKey);
        }
        ByteArrayOutputStream dataOutputStream = new ByteArrayOutputStream();
        try {
            dataOutputStream.write(oidBytes);
            dataOutputStream.write(refPublicKeyOrSecretKeyBytes);
            if (refPrivateKeyOrForComputingSessionKey != null) {
                dataOutputStream.write(refPrivateKeyOrForComputingSessionKey);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error while copying data", ioe);
            throw new IllegalStateException("Error while copying data");
        }
        byte[] data = dataOutputStream.toByteArray();
        CommandAPDU capdu = new CommandAPDU(0, 34, 193, 164, data);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        short sw = (short)rapdu.getSW();
        if (sw != -28672) {
            throw new CardServiceException("Sending MSE AT failed", (int)sw);
        }
    }

    @Override
    public synchronized byte[] sendGeneralAuthenticate(APDUWrapper wrapper, byte[] data, boolean isLast) throws CardServiceException {
        byte[] commandData;
        CommandAPDU capdu = new CommandAPDU(isLast ? 0 : 16, -122, 0, 0, commandData = TLVUtil.wrapDO((int)124, (byte[])data), 256);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        short sw = (short)rapdu.getSW();
        if (sw != -28672) {
            throw new AccessDeniedException("Sending general authenticate failed", sw);
        }
        byte[] responseData = rapdu.getData();
        responseData = TLVUtil.unwrapDO((int)124, (byte[])responseData);
        return responseData;
    }
}

