/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.Util;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class PACEGMWithECDHAgreement {
    private ECPrivateKey privateKey;

    public void init(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Not an ECPrivateKey");
        }
        this.privateKey = (ECPrivateKey)privateKey;
    }

    public ECPoint doPhase(PublicKey publicKey) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized!");
        }
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Not an ECPublicKey");
        }
        ECPublicKeyParameters pub = Util.toBouncyECPublicKeyParameters((ECPublicKey)publicKey);
        org.bouncycastle.math.ec.ECPoint p = pub.getQ().multiply(Util.toBouncyECPrivateKeyParameters(this.privateKey).getD()).normalize();
        if (p.isInfinity()) {
            throw new IllegalStateException("Infinity");
        }
        return Util.fromBouncyCastleECPoint(p);
    }
}

