/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.AccessKeySpec;
import com.kyc.nashidmrz.id_card.jmrtd.Util;
import com.kyc.nashidmrz.id_card.jmrtd.lds.PACEInfo;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.PACEMappingResult;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.SecureMessagingWrapper;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.PublicKey;

public class PACEResult
implements Serializable {
    private static final long serialVersionUID = -6819675856205885052L;
    private final PACEInfo.MappingType mappingType;
    private final String agreementAlg;
    private final String cipherAlg;
    private final String digestAlg;
    private final int keyLength;
    private final AccessKeySpec paceKey;
    private final PACEMappingResult mappingResult;
    private final PublicKey piccPublicKey;
    private final KeyPair pcdKeyPair;
    private final SecureMessagingWrapper wrapper;

    public PACEResult(AccessKeySpec paceKey, PACEInfo.MappingType mappingType, String agreementAlg, String cipherAlg, String digestAlg, int keyLength, PACEMappingResult mappingResult, KeyPair pcdKeyPair, PublicKey piccPublicKey, SecureMessagingWrapper wrapper) {
        this.paceKey = paceKey;
        this.mappingType = mappingType;
        this.agreementAlg = agreementAlg;
        this.cipherAlg = cipherAlg;
        this.digestAlg = digestAlg;
        this.keyLength = keyLength;
        this.mappingResult = mappingResult;
        this.pcdKeyPair = pcdKeyPair;
        this.piccPublicKey = piccPublicKey;
        this.wrapper = wrapper;
    }

    public AccessKeySpec getPACEKey() {
        return this.paceKey;
    }

    public PACEMappingResult getMappingResult() {
        return this.mappingResult;
    }

    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }

    public PACEInfo.MappingType getMappingType() {
        return this.mappingType;
    }

    public String getAgreementAlg() {
        return this.agreementAlg;
    }

    public String getCipherAlg() {
        return this.cipherAlg;
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public KeyPair getPCDKeyPair() {
        return this.pcdKeyPair;
    }

    public PublicKey getPICCPublicKey() {
        return this.piccPublicKey;
    }

    public String toString() {
        return "PACEResult [paceKey: " + this.paceKey + ", mappingType: " + (Object)((Object)this.mappingType) + ", agreementAlg: " + this.agreementAlg + ", cipherAlg: " + this.cipherAlg + ", digestAlg: " + this.digestAlg + ", keyLength: " + this.keyLength + ", mappingResult: " + this.mappingResult + ", piccPublicKey: " + Util.getDetailedPublicKeyAlgorithm(this.piccPublicKey) + ", pcdPrivateKey: " + Util.getDetailedPrivateKeyAlgorithm(this.pcdKeyPair.getPrivate()) + ", pcdPublicKey: " + Util.getDetailedPublicKeyAlgorithm(this.pcdKeyPair.getPublic());
    }

    public int hashCode() {
        int prime = 1991;
        int result2 = 11;
        result2 = 1991 * result2 + (this.paceKey == null ? 0 : this.paceKey.hashCode());
        result2 = 1991 * result2 + (this.agreementAlg == null ? 0 : this.agreementAlg.hashCode());
        result2 = 1991 * result2 + (this.cipherAlg == null ? 0 : this.cipherAlg.hashCode());
        result2 = 1991 * result2 + (this.digestAlg == null ? 0 : this.digestAlg.hashCode());
        result2 = 1991 * result2 + (this.mappingResult == null ? 0 : this.mappingResult.hashCode());
        result2 = 1991 * result2 + this.keyLength;
        result2 = 1991 * result2 + (this.mappingType == null ? 0 : this.mappingType.hashCode());
        result2 = 1991 * result2 + (this.pcdKeyPair == null ? 0 : this.pcdKeyPair.hashCode());
        result2 = 1991 * result2 + (this.piccPublicKey == null ? 0 : this.piccPublicKey.hashCode());
        result2 = 1991 * result2 + (this.wrapper == null ? 0 : this.wrapper.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PACEResult other = (PACEResult)obj;
        if (this.paceKey == null ? other.paceKey != null : !this.paceKey.equals(other.paceKey)) {
            return false;
        }
        if (this.agreementAlg == null ? other.agreementAlg != null : !this.agreementAlg.equals(other.agreementAlg)) {
            return false;
        }
        if (this.cipherAlg == null ? other.cipherAlg != null : !this.cipherAlg.equals(other.cipherAlg)) {
            return false;
        }
        if (this.digestAlg == null ? other.digestAlg != null : !this.digestAlg.equals(other.digestAlg)) {
            return false;
        }
        if (this.mappingResult == null ? other.mappingResult != null : !this.mappingResult.equals(other.mappingResult)) {
            return false;
        }
        if (this.keyLength != other.keyLength) {
            return false;
        }
        if (this.mappingType != other.mappingType) {
            return false;
        }
        if (this.pcdKeyPair == null ? other.pcdKeyPair != null : !this.pcdKeyPair.equals(other.pcdKeyPair)) {
            return false;
        }
        if (this.piccPublicKey == null ? other.piccPublicKey != null : !this.piccPublicKey.equals(other.piccPublicKey)) {
            return false;
        }
        if (this.wrapper == null) {
            return other.wrapper == null;
        }
        return this.wrapper.equals(other.wrapper);
    }
}

