/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.APDULevelReadBinaryCapable;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.SecureMessagingAPDUSender;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CardService;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.util.Hex;

public class ReadBinaryAPDUSender
implements APDULevelReadBinaryCapable {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    private final SecureMessagingAPDUSender secureMessagingSender;
    private final CardService service;

    public ReadBinaryAPDUSender(CardService service) {
        this.service = service;
        this.secureMessagingSender = new SecureMessagingAPDUSender(service);
    }

    @Override
    public synchronized void sendSelectApplet(APDUWrapper wrapper, byte[] aid) throws CardServiceException {
        if (aid == null) {
            throw new IllegalArgumentException("AID cannot be null");
        }
        CommandAPDU capdu = new CommandAPDU(0, -92, 4, 12, aid);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        ReadBinaryAPDUSender.checkStatusWordAfterFileOperation(capdu, rapdu);
    }

    @Override
    public synchronized void sendSelectFile(APDUWrapper wrapper, short fid) throws CardServiceException {
        byte[] fiddle = new byte[]{(byte)(fid >> 8 & 0xFF), (byte)(fid & 0xFF)};
        CommandAPDU capdu = new CommandAPDU(0, -92, 2, 12, fiddle, 0);
        ResponseAPDU rapdu = this.secureMessagingSender.transmit(wrapper, capdu);
        if (rapdu == null) {
            return;
        }
        ReadBinaryAPDUSender.checkStatusWordAfterFileOperation(capdu, rapdu);
    }

    @Override
    public synchronized byte[] sendReadBinary(APDUWrapper wrapper, int sfi, int offset, int le, boolean isSFIEnabled, boolean isTLVEncodedOffsetNeeded) throws CardServiceException {
        CommandAPDU commandAPDU = null;
        ResponseAPDU responseAPDU = null;
        if (le == 0) {
            return null;
        }
        byte offsetMSB = (byte)((offset & 0xFF00) >> 8);
        byte offsetLSB = (byte)(offset & 0xFF);
        if (isTLVEncodedOffsetNeeded) {
            if (le < 128) {
                le += 2;
            } else if (le < 256) {
                le += 3;
            }
            if (le > 256) {
                le = 256;
            }
            byte[] data = new byte[]{84, 2, offsetMSB, offsetLSB};
            commandAPDU = new CommandAPDU(0, -79, 0, 0, data, le);
        } else {
            commandAPDU = isSFIEnabled ? new CommandAPDU(0, -80, (int)((byte)sfi), (int)offsetLSB, le) : new CommandAPDU(0, -80, (int)offsetMSB, (int)offsetLSB, le);
        }
        int sw = 28416;
        try {
            responseAPDU = this.secureMessagingSender.transmit(wrapper, commandAPDU);
            sw = (short)responseAPDU.getSW();
        }
        catch (CardServiceException cse) {
            if (this.service.isConnectionLost((Exception)((Object)cse))) {
                throw cse;
            }
            LOGGER.log(Level.FINE, "Exception during READ BINARY", cse);
            sw = (short)cse.getSW();
        }
        byte[] responseData = ReadBinaryAPDUSender.getResponseData(responseAPDU, isTLVEncodedOffsetNeeded);
        if (responseData == null || responseData.length == 0) {
            LOGGER.warning("Empty response data: rapduBytes = " + Arrays.toString(responseData) + ", le = " + le + ", sw = " + Integer.toHexString(sw));
        } else {
            ReadBinaryAPDUSender.checkStatusWordAfterFileOperation(commandAPDU, responseAPDU);
        }
        return responseData;
    }

    private static byte[] getResponseData(ResponseAPDU responseAPDU, boolean isTLVEncodedOffsetNeeded) throws CardServiceException {
        if (responseAPDU == null) {
            return null;
        }
        byte[] responseData = responseAPDU.getData();
        if (responseData == null) {
            throw new CardServiceException("Malformed read binary long response data");
        }
        if (!isTLVEncodedOffsetNeeded) {
            return responseData;
        }
        byte[] data = responseData;
        int index = 0;
        if (data[index++] != 83) {
            throw new CardServiceException("Malformed read binary long response data");
        }
        if ((byte)(data[index] & 0x80) == -128) {
            index += data[index] & 0xF;
        }
        responseData = new byte[data.length - ++index];
        System.arraycopy(data, index, responseData, 0, responseData.length);
        return responseData;
    }

    private static void checkStatusWordAfterFileOperation(CommandAPDU commandAPDU, ResponseAPDU responseAPDU) throws CardServiceException {
        short sw = (short)responseAPDU.getSW();
        String commandResponseMessage = "CAPDU = " + Hex.bytesToHexString((byte[])commandAPDU.getBytes()) + ", RAPDU = " + Hex.bytesToHexString((byte[])responseAPDU.getBytes());
        switch (sw) {
            case -28672: {
                return;
            }
            case 27266: {
                throw new CardServiceException("File not found, " + commandResponseMessage, (int)sw);
            }
            case 27010: 
            case 27013: 
            case 27014: {
                throw new CardServiceException("Access to file denied, " + commandResponseMessage, (int)sw);
            }
        }
        throw new CardServiceException("Error occured, " + commandResponseMessage, (int)sw);
    }
}

