/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.jmrtd.protocol;

import com.kyc.nashidmrz.id_card.jmrtd.Util;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.AESSecureMessagingWrapper;
import com.kyc.nashidmrz.id_card.jmrtd.protocol.DESedeSecureMessagingWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import net.sf.scuba.smartcards.APDUWrapper;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.tlv.TLVUtil;

public abstract class SecureMessagingWrapper
implements Serializable,
APDUWrapper {
    private static final Logger LOGGER = Logger.getLogger("org.jmrtd.protocol");
    private static final long serialVersionUID = 4709645514566992414L;
    private final int maxTranceiveLength;
    private final boolean shouldCheckMAC;
    private long ssc;
    private final transient Cipher cipher;
    private final transient Mac mac;
    private final SecretKey ksEnc;
    private final SecretKey ksMac;

    protected SecureMessagingWrapper(SecretKey ksEnc, SecretKey ksMac, String cipherAlg, String macAlg, int maxTranceiveLength, boolean shouldCheckMAC, long ssc) throws GeneralSecurityException {
        this.maxTranceiveLength = maxTranceiveLength;
        this.shouldCheckMAC = shouldCheckMAC;
        this.ksEnc = ksEnc;
        this.ksMac = ksMac;
        this.ssc = ssc;
        this.cipher = Util.getCipher(cipherAlg);
        this.mac = Util.getMac(macAlg);
    }

    public static SecureMessagingWrapper getInstance(SecureMessagingWrapper wrapper) {
        try {
            if (wrapper instanceof DESedeSecureMessagingWrapper) {
                return new DESedeSecureMessagingWrapper((DESedeSecureMessagingWrapper)wrapper);
            }
            if (wrapper instanceof AESSecureMessagingWrapper) {
                return new AESSecureMessagingWrapper((AESSecureMessagingWrapper)wrapper);
            }
        }
        catch (GeneralSecurityException gse) {
            LOGGER.log(Level.WARNING, "Could not copy wrapper", gse);
        }
        LOGGER.warning("Not copying wrapper");
        return wrapper;
    }

    public long getSendSequenceCounter() {
        return this.ssc;
    }

    public SecretKey getEncryptionKey() {
        return this.ksEnc;
    }

    public SecretKey getMACKey() {
        return this.ksMac;
    }

    public boolean shouldCheckMAC() {
        return this.shouldCheckMAC;
    }

    public int getMaxTranceiveLength() {
        return this.maxTranceiveLength;
    }

    public CommandAPDU wrap(CommandAPDU commandAPDU) {
        ++this.ssc;
        try {
            return this.wrapCommandAPDU(commandAPDU);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("Unexpected exception", gse);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected exception", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandAPDU wrapCommandAPDU(CommandAPDU commandAPDU) throws GeneralSecurityException, IOException {
        byte[] data;
        int cla = commandAPDU.getCLA();
        int ins = commandAPDU.getINS();
        int p1 = commandAPDU.getP1();
        int p2 = commandAPDU.getP2();
        int lc = commandAPDU.getNc();
        int le = commandAPDU.getNe();
        byte[] maskedHeader = new byte[]{(byte)(cla | 0xC), (byte)ins, (byte)p1, (byte)p2};
        byte[] paddedMaskedHeader = Util.pad(maskedHeader, this.getPadLength());
        boolean hasDO85 = (byte)commandAPDU.getINS() == -79;
        byte[] do8587 = new byte[]{};
        byte[] do97 = new byte[]{};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (le > 0) {
                do97 = TLVUtil.wrapDO((int)151, (byte[])this.encodeLe(le));
            }
            if (lc > 0) {
                data = Util.pad(commandAPDU.getData(), this.getPadLength());
                this.cipher.init(1, (Key)this.ksEnc, this.getIV());
                byte[] ciphertext = this.cipher.doFinal(data);
                byteArrayOutputStream.reset();
                byteArrayOutputStream.write(hasDO85 ? -123 : -121);
                byteArrayOutputStream.write(TLVUtil.getLengthAsBytes((int)(ciphertext.length + (hasDO85 ? 0 : 1))));
                if (!hasDO85) {
                    byteArrayOutputStream.write(1);
                }
                byteArrayOutputStream.write(ciphertext, 0, ciphertext.length);
                do8587 = byteArrayOutputStream.toByteArray();
            }
            byteArrayOutputStream.reset();
            byteArrayOutputStream.write(this.getEncodedSendSequenceCounter());
            byteArrayOutputStream.write(paddedMaskedHeader);
            byteArrayOutputStream.write(do8587);
            byteArrayOutputStream.write(do97);
            byte[] n = Util.pad(byteArrayOutputStream.toByteArray(), this.getPadLength());
            this.mac.init(this.ksMac);
            byte[] cc = this.mac.doFinal(n);
            int ccLength = cc.length;
            if (ccLength != 8) {
                ccLength = 8;
            }
            byteArrayOutputStream.reset();
            byteArrayOutputStream.write(-114);
            byteArrayOutputStream.write(ccLength);
            byteArrayOutputStream.write(cc, 0, ccLength);
            byte[] do8E = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            byteArrayOutputStream.write(do8587);
            byteArrayOutputStream.write(do97);
            byteArrayOutputStream.write(do8E);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.FINE, "Error closing stream", ioe);
            }
        }
        data = byteArrayOutputStream.toByteArray();
        if (le == 256) {
            return new CommandAPDU((int)maskedHeader[0], (int)maskedHeader[1], (int)maskedHeader[2], (int)maskedHeader[3], data, 256);
        }
        if (le == 65536) {
            return new CommandAPDU((int)maskedHeader[0], (int)maskedHeader[1], (int)maskedHeader[2], (int)maskedHeader[3], data, 65536);
        }
        return new CommandAPDU((int)maskedHeader[0], (int)maskedHeader[1], (int)maskedHeader[2], (int)maskedHeader[3], data, this.getMaxTranceiveLength());
    }

    public ResponseAPDU unwrap(ResponseAPDU responseAPDU) {
        ++this.ssc;
        try {
            byte[] data = responseAPDU.getData();
            if (data == null || data.length <= 0) {
                throw new IllegalStateException("Card indicates SM error, SW = " + Integer.toHexString(responseAPDU.getSW() & 0xFFFF));
            }
            return this.unwrapResponseAPDU(responseAPDU);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("Unexpected exception", gse);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected exception", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseAPDU unwrapResponseAPDU(ResponseAPDU responseAPDU) throws GeneralSecurityException, IOException {
        byte[] rapdu = responseAPDU.getBytes();
        if (rapdu == null || rapdu.length < 2) {
            throw new IllegalArgumentException("Invalid response APDU");
        }
        this.cipher.init(2, (Key)this.ksEnc, this.getIV());
        byte[] data = new byte[]{};
        byte[] cc = null;
        short sw = 0;
        try (DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(rapdu));){
            boolean isFinished = false;
            block9: while (!isFinished) {
                byte tag = inputStream.readByte();
                switch (tag) {
                    case -121: {
                        data = this.readDO87(inputStream, false);
                        continue block9;
                    }
                    case -123: {
                        data = this.readDO87(inputStream, true);
                        continue block9;
                    }
                    case -103: {
                        sw = this.readDO99(inputStream);
                        continue block9;
                    }
                    case -114: {
                        cc = this.readDO8E(inputStream);
                        isFinished = true;
                        continue block9;
                    }
                }
                LOGGER.warning("Unexpected tag " + Integer.toHexString(tag));
            }
        }
        if (this.shouldCheckMAC() && !this.checkMac(rapdu, cc)) {
            throw new IllegalStateException("Invalid MAC");
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        bOut.write(data, 0, data.length);
        bOut.write((sw & 0xFF00) >> 8);
        bOut.write(sw & 0xFF);
        return new ResponseAPDU(bOut.toByteArray());
    }

    protected boolean checkMac(byte[] rapdu, byte[] cc) throws GeneralSecurityException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(this.getEncodedSendSequenceCounter());
            byte[] paddedData = Util.pad(rapdu, 0, rapdu.length - 2 - 8 - 2, this.getPadLength());
            dataOutputStream.write(paddedData, 0, paddedData.length);
            dataOutputStream.flush();
            dataOutputStream.close();
            this.mac.init(this.ksMac);
            byte[] cc2 = this.mac.doFinal(byteArrayOutputStream.toByteArray());
            if (cc2.length > 8 && cc.length == 8) {
                byte[] newCC2 = new byte[8];
                System.arraycopy(cc2, 0, newCC2, 0, newCC2.length);
                cc2 = newCC2;
            }
            return Arrays.equals(cc, cc2);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Exception checking MAC", ioe);
            return false;
        }
    }

    protected abstract int getPadLength();

    protected abstract IvParameterSpec getIV() throws GeneralSecurityException;

    protected abstract byte[] getEncodedSendSequenceCounter();

    private byte[] encodeLe(int le) {
        if (0 <= le && le <= 256) {
            return new byte[]{(byte)le};
        }
        return new byte[]{(byte)((le & 0xFF00) >> 8), (byte)(le & 0xFF)};
    }

    private byte[] readDO87(DataInputStream inputStream, boolean do85) throws IOException, GeneralSecurityException {
        int length = 0;
        int buf = inputStream.readUnsignedByte();
        if ((buf & 0x80) != 128) {
            length = buf;
            if (!do85 && (buf = inputStream.readUnsignedByte()) != 1) {
                throw new IllegalStateException("DO'87 expected 0x01 marker, found " + Integer.toHexString(buf & 0xFF));
            }
        } else {
            int lengthBytesCount = buf & 0x7F;
            for (int i = 0; i < lengthBytesCount; ++i) {
                length = length << 8 | inputStream.readUnsignedByte();
            }
            if (!do85 && (buf = inputStream.readUnsignedByte()) != 1) {
                throw new IllegalStateException("DO'87 expected 0x01 marker");
            }
        }
        if (!do85) {
            --length;
        }
        byte[] ciphertext = new byte[length];
        inputStream.readFully(ciphertext);
        byte[] paddedData = this.cipher.doFinal(ciphertext);
        return Util.unpad(paddedData);
    }

    private short readDO99(DataInputStream inputStream) throws IOException {
        int length = inputStream.readUnsignedByte();
        if (length != 2) {
            throw new IllegalStateException("DO'99 wrong length");
        }
        byte sw1 = inputStream.readByte();
        byte sw2 = inputStream.readByte();
        return (short)((sw1 & 0xFF) << 8 | sw2 & 0xFF);
    }

    private byte[] readDO8E(DataInputStream inputStream) throws IOException {
        int length = inputStream.readUnsignedByte();
        if (length != 8 && length != 16) {
            throw new IllegalStateException("DO'8E wrong length for MAC: " + length);
        }
        byte[] cc = new byte[length];
        inputStream.readFully(cc);
        return cc;
    }

    public String toString() {
        return "SecureMessagingWrapper [ssc: " + this.ssc + ", ksEnc: " + this.ksEnc + ", ksMac: " + this.ksMac + ", maxTranceiveLength: " + this.maxTranceiveLength + ", shouldCheckMAC: " + this.shouldCheckMAC + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.ksEnc == null ? 0 : this.ksEnc.hashCode());
        result2 = 31 * result2 + (this.ksMac == null ? 0 : this.ksMac.hashCode());
        result2 = 31 * result2 + this.maxTranceiveLength;
        result2 = 31 * result2 + (this.shouldCheckMAC ? 1231 : 1237);
        result2 = 31 * result2 + (int)(this.ssc ^ this.ssc >>> 32);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecureMessagingWrapper other = (SecureMessagingWrapper)obj;
        if (this.ksEnc == null ? other.ksEnc != null : !this.ksEnc.equals(other.ksEnc)) {
            return false;
        }
        if (this.ksMac == null ? other.ksMac != null : !this.ksMac.equals(other.ksMac)) {
            return false;
        }
        if (this.maxTranceiveLength != other.maxTranceiveLength) {
            return false;
        }
        if (this.shouldCheckMAC != other.shouldCheckMAC) {
            return false;
        }
        return this.ssc == other.ssc;
    }
}

