/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.omn;

import com.kyc.nashidmrz.id_card.omn.OmanCardDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sf.scuba.util.Hex;

public class OmanCardDG10File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_VISA_NUMBER = 10784;
    public static final int TAG_VISA_EXPIRY_DATE = 18977;
    public static final int TAG_VISA_PLACE_OF_ISSUE_ARABIC = 43554;
    String visaNumber;
    String visaExpiryDate;
    String visaPlaceOfIssueArabic;

    public OmanCardDG10File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream = new OmanCardDataInputStream(new ByteArrayInputStream(buffer));
        this.visaNumber = Hex.toHexString((byte[])omanCardDataInputStream.getTagValue(10784));
        this.visaExpiryDate = Hex.toHexString((byte[])omanCardDataInputStream.getTagValue(18977));
        this.visaPlaceOfIssueArabic = new String(omanCardDataInputStream.getTagValue(43554), charset);
    }

    public String getTagValue(int tag) {
        switch (tag) {
            case 10784: {
                return this.visaNumber;
            }
            case 18977: {
                return this.visaExpiryDate;
            }
            case 43554: {
                return this.visaPlaceOfIssueArabic;
            }
        }
        return null;
    }

    public String toString() {
        return "OmanCardDG10File{10784='" + this.visaNumber + '\'' + ", " + 18977 + "='" + this.visaExpiryDate + '\'' + ", " + 43554 + "='" + this.visaPlaceOfIssueArabic + '\'' + '}';
    }

    public String getVisaNumber() {
        return this.visaNumber;
    }

    public void setVisaNumber(String visaNumber) {
        this.visaNumber = visaNumber;
    }

    public String getVisaExpiryDate() {
        return this.visaExpiryDate;
    }

    public void setVisaExpiryDate(String visaExpiryDate) {
        this.visaExpiryDate = visaExpiryDate;
    }

    public String getVisaPlaceOfIssueArabic() {
        return this.visaPlaceOfIssueArabic;
    }

    public void setVisaPlaceOfIssueArabic(String visaPlaceOfIssueArabic) {
        this.visaPlaceOfIssueArabic = visaPlaceOfIssueArabic;
    }
}

