/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.id_card.omn;

import com.kyc.nashidmrz.id_card.omn.OmanCardDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sf.scuba.util.Hex;

public class OmanCardDG1File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_ID_NUMBER = 8448;
    public static final int TAG_ISSUE_DATE = 16641;
    public static final int TAG_EXPIRY_DATE = 16642;
    public static final int TAG_PLACE_OF_ISSUE_ENGLISH = 57604;
    public static final int TAG_PLACE_OF_ISSUE_ARABIC = 41219;
    String idNumber;
    String issueDate;
    String expiryDate;
    String placeOfIssueEnglish;
    String placeOfIssueArabic;

    public String toString() {
        return "OmanCardDG1File{8448=" + this.idNumber + '\'' + ", " + 16641 + "='" + this.issueDate + '\'' + ", " + 16642 + "='" + this.expiryDate + '\'' + ", " + 57604 + "='" + this.placeOfIssueEnglish + '\'' + ", " + 41219 + "='" + this.placeOfIssueArabic + '\'' + '}';
    }

    public OmanCardDG1File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream = new OmanCardDataInputStream(new ByteArrayInputStream(buffer));
        this.idNumber = Hex.toHexString((byte[])omanCardDataInputStream.getTagValue(8448));
        this.issueDate = Hex.toHexString((byte[])omanCardDataInputStream.getTagValue(16641));
        this.expiryDate = Hex.toHexString((byte[])omanCardDataInputStream.getTagValue(16642));
        this.placeOfIssueArabic = new String(omanCardDataInputStream.getTagValue(41219), charset);
        this.placeOfIssueEnglish = new String(omanCardDataInputStream.getTagValue(57604), charset);
    }

    public String getTagValue(int tag) {
        switch (tag) {
            case 8448: {
                return this.idNumber;
            }
            case 16641: {
                return this.issueDate;
            }
            case 16642: {
                return this.expiryDate;
            }
            case 57604: {
                return this.placeOfIssueEnglish;
            }
            case 41219: {
                return this.placeOfIssueArabic;
            }
        }
        return null;
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(String issueDate) {
        this.issueDate = issueDate;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getPlaceOfIssueEnglish() {
        return this.placeOfIssueEnglish;
    }

    public void setPlaceOfIssueEnglish(String placeOfIssueEnglish) {
        this.placeOfIssueEnglish = placeOfIssueEnglish;
    }

    public String getPlaceOfIssueArabic() {
        return this.placeOfIssueArabic;
    }

    public void setPlaceOfIssueArabic(String placeOfIssueArabic) {
        this.placeOfIssueArabic = placeOfIssueArabic;
    }
}

