/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.internetutility;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.databinding.DialogNoInternetBinding;
import com.kyc.nashidmrz.mrtd2.activity.TextSizeConverter;
import com.kyc.nashidmrz.utility.OnInternetAvailabilityListener;
import java.util.Objects;

public class ErrorUtility {
    private static final ErrorUtility errorUtility = new ErrorUtility();
    private static final String TAG = "ErrorUtility";
    private OnInternetAvailabilityListener onInternetAvailabilityListener;
    private boolean isNetworkAvailable = false;
    private TextSizeConverter textSizeConverter;
    private Dialog dialog;
    private int activeActivities = 0;
    private ConnectivityManager conMgr;
    private final ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback(){

        public void onAvailable(@NonNull Network network) {
            super.onAvailable(network);
            if (!ErrorUtility.this.isNetworkAvailable) {
                Log.d((String)ErrorUtility.TAG, (String)"onAvailable:connection available ");
                ErrorUtility.this.isNetworkAvailable = true;
                if (ErrorUtility.this.onInternetAvailabilityListener != null) {
                    ErrorUtility.this.onInternetAvailabilityListener.onAvailable();
                }
                if (ErrorUtility.this.dialog != null) {
                    ErrorUtility.this.dialog.dismiss();
                }
            }
        }

        public void onLost(@NonNull Network network) {
            super.onLost(network);
            if (ErrorUtility.this.isNetworkAvailable) {
                ErrorUtility.this.isNetworkAvailable = false;
                Log.d((String)ErrorUtility.TAG, (String)"onLost: connection lost");
                if (ErrorUtility.this.onInternetAvailabilityListener != null) {
                    ErrorUtility.this.onInternetAvailabilityListener.onLost();
                }
            }
        }
    };

    public static ErrorUtility getInstance() {
        return errorUtility;
    }

    public void showNoInternetDialog(final FragmentActivity activity, final boolean isActivityRunning) {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (isActivityRunning) {
                    ErrorUtility.this.textSizeConverter = new TextSizeConverter((Context)activity);
                    ErrorUtility.this.dialog = new Dialog((Context)activity);
                    ErrorUtility.this.dialog.requestWindowFeature(1);
                    DialogNoInternetBinding binding = DialogNoInternetBinding.inflate(ErrorUtility.this.dialog.getLayoutInflater());
                    ErrorUtility.this.dialog.setContentView((View)binding.getRoot());
                    binding.imgScanFailure.setAnimation(R.raw.failure);
                    binding.btnRetry.setVisibility(0);
                    int padding = ErrorUtility.this.textSizeConverter.getPaddingORMarginValue(16);
                    binding.mainDialogLyt.setPadding(padding, padding, padding, padding);
                    ViewGroup.LayoutParams layoutParams2 = binding.imgScanFailure.getLayoutParams();
                    layoutParams2.width = ErrorUtility.this.textSizeConverter.getWidth(56);
                    layoutParams2.height = ErrorUtility.this.textSizeConverter.getHeight(56);
                    binding.imgScanFailure.setLayoutParams(layoutParams2);
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)binding.imgScanFailure.getLayoutParams();
                    layoutParams.setMargins(0, ErrorUtility.this.textSizeConverter.getPaddingORMarginValue(8), 0, 0);
                    binding.imgScanFailure.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    binding.txtScanCompleted.setTextSize(0, ErrorUtility.this.textSizeConverter.getTextSize(18));
                    layoutParams = (LinearLayout.LayoutParams)binding.txtScanCompleted.getLayoutParams();
                    layoutParams.setMargins(0, ErrorUtility.this.textSizeConverter.getPaddingORMarginValue(24), 0, ErrorUtility.this.textSizeConverter.getPaddingORMarginValue(24));
                    binding.txtScanCompleted.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    padding = ErrorUtility.this.textSizeConverter.getPaddingORMarginValue(12);
                    binding.txtBtnRetry.setPadding(0, padding, 0, padding);
                    binding.txtBtnRetry.setTextSize(0, ErrorUtility.this.textSizeConverter.getTextSize(16));
                    binding.btnRetry.setRadius((float)ErrorUtility.this.textSizeConverter.calculateRadius(8));
                    binding.btnRetry.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (ErrorUtility.this.isNetworkAvailable) {
                                ErrorUtility.this.dialog.dismiss();
                            }
                        }
                    });
                    ErrorUtility.this.dialog.show();
                    ErrorUtility.this.dialog.setCancelable(false);
                    Objects.requireNonNull(ErrorUtility.this.dialog.getWindow()).setLayout(-1, -2);
                    ErrorUtility.this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
                    ErrorUtility.this.dialog.getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
                    ErrorUtility.this.dialog.getWindow().setGravity(80);
                }
            }
        });
    }

    public boolean registerConnectivityManager(Activity activity, OnInternetAvailabilityListener onInternetAvailabilityListener) {
        Log.d((String)TAG, (String)("registerConnectivityanager: " + activity.getLocalClassName()));
        this.onInternetAvailabilityListener = onInternetAvailabilityListener;
        if (this.activeActivities == 0) {
            this.conMgr = (ConnectivityManager)activity.getSystemService("connectivity");
            NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).addTransportType(1).addTransportType(0).build();
            this.conMgr.requestNetwork(networkRequest, this.networkCallback);
        }
        ++this.activeActivities;
        NetworkInfo netInfo = this.conMgr.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnectedOrConnecting() && netInfo.isAvailable();
    }

    public void unregisterConnectivityManager(Activity activity) {
        --this.activeActivities;
        if (this.activeActivities == 0) {
            Log.d((String)TAG, (String)("unregisterConnectivityManager: " + activity.getLocalClassName()));
            ConnectivityManager connectivityManager = (ConnectivityManager)activity.getSystemService("connectivity");
            connectivityManager.unregisterNetworkCallback(this.networkCallback);
        }
    }
}

