/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.locationdata;

import android.app.Activity;
import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class LocationHelper
implements LocationListener {
    private final Activity activity;
    private final LocationManager locationManager;
    private LocationCallback locationCallback;
    private static final long MIN_TIME_BW_UPDATES = 60000L;
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 10L;
    private static final long LOCATION_TIMEOUT = 10000L;

    public LocationHelper(Activity activity) {
        this.activity = activity;
        this.locationManager = (LocationManager)activity.getSystemService("location");
    }

    public void getLastLocation(LocationCallback callback) {
        this.locationCallback = callback;
        if (ContextCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            this.requestLocationPermissions();
            return;
        }
        Location location = this.locationManager.getLastKnownLocation("gps");
        if (location == null) {
            location = this.locationManager.getLastKnownLocation("network");
        }
        if (location == null) {
            this.requestLocationUpdatesWithTimeout(callback);
        } else {
            String address = this.getAddressFromLocation(location);
            if (this.locationCallback != null) {
                this.locationCallback.onLocationResult(location, address);
            }
        }
    }

    private void requestLocationUpdatesWithTimeout(LocationCallback callback) {
        this.locationCallback = callback;
        if (ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            this.requestLocationPermissions();
            return;
        }
        this.locationManager.requestLocationUpdates("gps", 60000L, 10.0f, (LocationListener)this);
        new Handler().postDelayed(() -> {
            this.locationManager.removeUpdates((LocationListener)this);
            Location lastKnownLocation = this.locationManager.getLastKnownLocation("gps");
            if (lastKnownLocation == null) {
                lastKnownLocation = this.locationManager.getLastKnownLocation("network");
            }
            if (lastKnownLocation != null && this.locationCallback != null) {
                String address = this.getAddressFromLocation(lastKnownLocation);
                this.locationCallback.onLocationResult(lastKnownLocation, address);
            } else {
                Location defaultLocation = new Location("default");
                defaultLocation.setLatitude(0.0);
                defaultLocation.setLongitude(0.0);
                if (this.locationCallback != null) {
                    String address = this.getAddressFromLocation(defaultLocation);
                    this.locationCallback.onLocationResult(defaultLocation, address);
                }
            }
        }, 10000L);
    }

    public void onLocationChanged(@NonNull Location location) {
        if (this.locationCallback != null) {
            String address = this.getAddressFromLocation(location);
            this.locationCallback.onLocationResult(location, address);
            this.locationManager.removeUpdates((LocationListener)this);
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(@NonNull String provider) {
    }

    public void onProviderDisabled(@NonNull String provider) {
    }

    private void requestLocationPermissions() {
        ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)1);
    }

    private String getAddressFromLocation(Location location) {
        Geocoder geocoder = new Geocoder((Context)this.activity, Locale.getDefault());
        try {
            List addresses = geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
            if (addresses != null && !addresses.isEmpty()) {
                Address address = (Address)addresses.get(0);
                return address.getAddressLine(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "Unknown location";
    }

    public static interface LocationCallback {
        public void onLocationResult(Location var1, String var2);
    }
}

