/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.BitiAndroid;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.mrtd2.BitiAndroid.TagProvider;

public abstract class AbstractNfcActivity
extends AppCompatActivity {
    private static final int PERMISSION_REQUEST_CODE = 100;
    protected NfcAdapter mNfcAdapter;
    protected PendingIntent pendingIntent;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.NFC") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.NFC"}, (int)100);
        } else {
            this.initAdapter();
        }
    }

    private void initAdapter() {
        this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)this);
        if (this.mNfcAdapter == null || !this.mNfcAdapter.isEnabled()) {
            System.out.println("failed to get NFC adapter, NFC disabled?");
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getResources().getString(R.string.error_error)).setMessage((CharSequence)this.getResources().getString(R.string.error_nfc_is_disabled)).setCancelable(true).setPositiveButton((CharSequence)"enable", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Intent intent = new Intent("android.settings.NFC_SETTINGS");
                    AbstractNfcActivity.this.startActivity(intent);
                }
            }).create().show();
        } else if (Build.VERSION.SDK_INT >= 23) {
            Intent intent = new Intent((Context)this, ((Object)((Object)this)).getClass()).addFlags(0x20000000);
            this.pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x2000000);
        } else {
            this.pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, ((Object)((Object)this)).getClass()).addFlags(0x20000000), (int)0);
        }
    }

    public void onPause() {
        super.onPause();
        this.mNfcAdapter.disableForegroundDispatch((Activity)this);
    }

    public void onResume() {
        super.onResume();
        try {
            if (this.mNfcAdapter != null && this.pendingIntent != null) {
                this.mNfcAdapter.enableForegroundDispatch((Activity)this, this.pendingIntent, null, null);
            }
        }
        catch (Exception e) {
            System.out.println("onResume error");
        }
    }

    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        Tag tagFromIntent = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
        if (tagFromIntent != null) {
            TagProvider.setTag(IsoDep.get((Tag)tagFromIntent));
        }
        System.out.println("Got new intent!");
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 100 && grantResults.length > 0 && grantResults[0] == 0) {
            this.initAdapter();
        }
    }
}

