/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.BitiMRTD.Parser;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.kyc.nashidmrz.mrtd2.BitiMRTD.Tools.Tools;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.jmrtd.jj2000.Bitmap;
import org.jmrtd.jj2000.JJ2000Decoder;

public class Iso19794Parser {
    private final byte[] rawData;
    private final Tools tools;
    private android.graphics.Bitmap bitmap = null;

    public Iso19794Parser(byte[] data) {
        this.rawData = data;
        this.tools = new Tools();
        this.parse();
    }

    private void parse() {
        block7: {
            int cursor = 0;
            cursor += 4;
            cursor += 4;
            cursor += 4;
            cursor += 2;
            int numberOfFeaturePoints = this.tools.getIntFrom16bits(Arrays.copyOfRange(this.rawData, cursor += 4, cursor + 2));
            System.out.println("Number of feature points: ".concat(String.valueOf(numberOfFeaturePoints)));
            cursor += 2;
            ++cursor;
            ++cursor;
            ++cursor;
            cursor += 3;
            cursor += 2;
            cursor += 3;
            cursor += 3;
            for (int i = 0; i < numberOfFeaturePoints; ++i) {
                cursor += 8;
            }
            ++cursor;
            ++cursor;
            cursor += 2;
            cursor += 2;
            ++cursor;
            ++cursor;
            cursor += 2;
            byte[] imageBytes = Arrays.copyOfRange(this.rawData, cursor += 2, this.rawData.length);
            try {
                this.bitmap = BitmapFactory.decodeByteArray((byte[])imageBytes, (int)0, (int)imageBytes.length);
            }
            catch (Exception e) {
                if (e.getLocalizedMessage() != null) {
                    System.out.println(e.getLocalizedMessage());
                }
                System.out.println(Log.getStackTraceString((Throwable)e));
            }
            if (this.bitmap == null) {
                try {
                    Bitmap jj2000image = JJ2000Decoder.decode((InputStream)new ByteArrayInputStream(imageBytes));
                    int[] pixels = jj2000image.getPixels();
                    this.bitmap = android.graphics.Bitmap.createBitmap((int[])pixels, (int)0, (int)jj2000image.getWidth(), (int)jj2000image.getWidth(), (int)jj2000image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                catch (Exception e2) {
                    if (e2.getLocalizedMessage() == null) break block7;
                    System.out.println(e2.getLocalizedMessage());
                }
            }
        }
    }

    public android.graphics.Bitmap getBitmap() {
        return this.bitmap;
    }
}

