/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.BitiMRTD.Parser;

import com.kyc.nashidmrz.mrtd2.BitiMRTD.Tools.Tools;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TagParser {
    private Tools tools;
    private byte[] data;
    private final Map<String, byte[]> tags = new HashMap<String, byte[]>();

    public TagParser(byte[] data) {
        if (data == null) {
            return;
        }
        this.tools = new Tools();
        this.data = data;
    }

    public void parseElement(byte[] element) {
        block3: {
            try {
                int asn1Length;
                for (int cursor = 0; cursor < element.length; cursor += asn1Length) {
                    byte[] tag = this.getTagFromElement(Arrays.copyOfRange(element, cursor, cursor + 2));
                    String sTag = this.tools.bytesToString(tag).toLowerCase();
                    byte[] bytesToRead = Arrays.copyOfRange(element, cursor += tag.length, element.length);
                    int lengthOfAsn1Header = this.tools.getAsn1HeaderLength(bytesToRead);
                    asn1Length = this.tools.getLengthFromAsn1(bytesToRead);
                    System.out.println("Found tag : ".concat(sTag).concat(", length : ").concat(String.valueOf(asn1Length)));
                    byte[] tagBody = Arrays.copyOfRange(element, cursor += lengthOfAsn1Header, cursor + asn1Length);
                    this.tags.put(sTag, tagBody);
                }
            }
            catch (Exception e) {
                if (e.getMessage() == null) break block3;
                System.out.println(e.getMessage());
            }
        }
    }

    private byte[] getTagFromElement(byte[] element) {
        if (element[0] == 127 || element[0] == 95) {
            return Arrays.copyOfRange(element, 0, 2);
        }
        return this.tools.byteToBytes(element[0]);
    }

    public TagParser geTag(String tag) {
        this.parseElement(this.data);
        System.out.println("Getting tag : ".concat(tag));
        tag = tag.toLowerCase();
        return new TagParser(this.tags.get(tag));
    }

    public byte[] getBytes() {
        return this.data;
    }
}

