/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.BitiMRTD.Tools;

import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;

public class Tools {
    public byte[] unpadData(byte[] data) {
        int pos = 1;
        while (data[data.length - pos] != -128) {
            if (data.length <= pos) {
                return null;
            }
            ++pos;
        }
        return Arrays.copyOfRange(data, 0, data.length - pos);
    }

    public byte[] doXor(byte[] input1, byte[] input2) {
        if (input1.length != input2.length) {
            System.out.println("Can not do XOR: input1 and input2 length mismatch");
            System.out.println("Input1 length : ".concat(String.valueOf(input1.length)));
            System.out.println("Input2 length : ".concat(String.valueOf(input2.length)));
            return null;
        }
        byte[] output = new byte[input1.length];
        for (int i = 0; i < input1.length; ++i) {
            output[i] = (byte)(input1[i] ^ input2[i]);
        }
        return output;
    }

    public byte[] adjustParityBits(byte[] input) {
        for (int i = 0; i < input.length; ++i) {
            byte b = input[i];
            input[i] = (byte)(b & 0xFE | (b >> 1 ^ b >> 2 ^ b >> 3 ^ b >> 4 ^ b >> 5 ^ b >> 6 ^ b >> 7 ^ 1) & 1);
        }
        return input;
    }

    public String bytesToString(byte[] input) {
        if (input == null) {
            return "";
        }
        String output = "";
        for (byte b : input) {
            output = output.concat(String.format("%02x", b));
        }
        return output;
    }

    public byte[] concatByteArrays(byte[] input1, byte[] input2) {
        if (input1 == null) {
            return input2;
        }
        if (input2 == null) {
            return input1;
        }
        byte[] output = new byte[input1.length + input2.length];
        for (int i = 0; i < input1.length + input2.length; ++i) {
            output[i] = i < input1.length ? input1[i] : input2[i - input1.length];
        }
        return output;
    }

    public byte[] byteToBytes(byte input) {
        byte[] output = new byte[]{input};
        return output;
    }

    public byte[] incrementBytesArray(byte[] input, int index) {
        if (index >= input.length) {
            return this.concatByteArrays(this.byteToBytes((byte)1), input);
        }
        int n = index;
        input[n] = (byte)(input[n] + 1);
        if (input[index] == 0) {
            return this.incrementBytesArray(input, index + 1);
        }
        return input;
    }

    public byte[] incrementBytesArray(byte[] input) {
        return this.incrementBytesArray(input, input.length - 1);
    }

    public byte[] calculateAsn1Length(byte[] data) {
        if (data.length <= 127) {
            return this.byteToBytes((byte)data.length);
        }
        if (data.length >= 127 && data.length <= 255) {
            return this.concatByteArrays(this.byteToBytes((byte)-127), this.byteToBytes((byte)data.length));
        }
        if (data.length >= 256 && data.length <= 65535) {
            byte[] length = this.concatByteArrays(this.byteToBytes((byte)(data.length >> 8)), this.byteToBytes((byte)data.length));
            return this.concatByteArrays(this.byteToBytes((byte)-126), length);
        }
        System.out.println("Error: length is too big");
        return null;
    }

    public int getAsn1HeaderLength(byte[] asn1) {
        if (asn1 == null) {
            System.out.println("asn1 is null");
            return 0;
        }
        if (asn1[0] <= 127 && asn1[0] >= 0) {
            return 1;
        }
        if (asn1[0] == -127) {
            return 2;
        }
        if (asn1[0] == -126) {
            return 3;
        }
        return 0;
    }

    public int getIntFrom16bits(byte[] input) {
        return input[0] << 8 & 0xFF00 | input[1] & 0xFF;
    }

    public int getLengthFromAsn1(byte[] asn1) {
        if (asn1 == null) {
            System.out.println("asn1 is null");
            return 0;
        }
        if (asn1[0] <= 127 && asn1[0] >= 0) {
            return asn1[0] & 0xFF;
        }
        if (asn1[0] == -127) {
            return asn1[1] & 0xFF;
        }
        if (asn1[0] == -126) {
            return asn1[1] << 8 & 0xFF00 | asn1[2] & 0xFF;
        }
        return 0;
    }

    public int getLengthFromFileHeader(byte[] fileHeader) {
        if (fileHeader.length != 4) {
            System.out.println("Expected file header to be 4 bytes long");
            return 0;
        }
        return this.getLengthFromAsn1(Arrays.copyOfRange(fileHeader, 1, 4));
    }

    public byte[] calculate2bytesInt(int value) {
        if (value <= 255) {
            return this.concatByteArrays(this.byteToBytes((byte)0), this.byteToBytes((byte)value));
        }
        if (value <= 65535) {
            return this.concatByteArrays(this.byteToBytes((byte)(value >> 8)), this.byteToBytes((byte)value));
        }
        System.out.println("Error: value is too big");
        return null;
    }

    public int calculateMrzCheckDigit(String input) {
        int weight = 0;
        int sum = 0;
        input = input.toUpperCase();
        for (int i = 0; i < input.length(); ++i) {
            char chr = input.charAt(i);
            int value = 0;
            if (chr > '@' && chr < '[') {
                value = chr - 65 + 10;
            }
            if (chr > '/' && chr < ':') {
                value = chr - 48;
            }
            switch (i % 3) {
                case 0: {
                    weight = 7;
                    break;
                }
                case 1: {
                    weight = 3;
                    break;
                }
                case 2: {
                    weight = 1;
                }
            }
            sum += weight * value;
        }
        return sum % 10;
    }

    public byte[] inputStreamToByteArray(InputStream inputStream) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            System.out.println(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    public byte[] invertBytes(byte[] bytes) {
        byte[] invertedBytes = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            invertedBytes[i] = bytes[bytes.length - 1 - i];
        }
        return invertedBytes;
    }
}

