/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import com.google.android.gms.common.images.Size;
import com.google.common.base.Preconditions;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.mrtd2.activity.CameraSource;

public class PreferenceUtils {
    private static final int POSE_DETECTOR_PERFORMANCE_MODE_FAST = 1;

    static void saveString(Context context, @StringRes int prefKeyId, @Nullable String value) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString(context.getString(prefKeyId), value).apply();
    }

    @Nullable
    public static CameraSource.SizePair getCameraPreviewSizePair(Context context, int cameraId) {
        String pictureSizePrefKey;
        String previewSizePrefKey;
        Preconditions.checkArgument((cameraId == 0 || cameraId == 1 ? 1 : 0) != 0);
        if (cameraId == 0) {
            previewSizePrefKey = context.getString(R.string.pref_key_rear_camera_preview_size);
            pictureSizePrefKey = context.getString(R.string.pref_key_rear_camera_picture_size);
        } else {
            previewSizePrefKey = context.getString(R.string.pref_key_front_camera_preview_size);
            pictureSizePrefKey = context.getString(R.string.pref_key_front_camera_picture_size);
        }
        try {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return new CameraSource.SizePair(Size.parseSize((String)sharedPreferences.getString(previewSizePrefKey, null)), Size.parseSize((String)sharedPreferences.getString(pictureSizePrefKey, null)));
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequiresApi(value=21)
    @Nullable
    public static android.util.Size getCameraXTargetResolution(Context context, int lensfacing) {
        Preconditions.checkArgument((lensfacing == 1 || lensfacing == 0 ? 1 : 0) != 0);
        String prefKey = lensfacing == 1 ? context.getString(R.string.pref_key_camerax_rear_camera_target_resolution) : context.getString(R.string.pref_key_camerax_front_camera_target_resolution);
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        try {
            return android.util.Size.parseSize((String)sharedPreferences.getString(prefKey, null));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean shouldHideDetectionInfo(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String prefKey = context.getString(R.string.pref_key_info_hide);
        return sharedPreferences.getBoolean(prefKey, false);
    }

    public static boolean shouldGroupRecognizedTextInBlocks(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String prefKey = context.getString(R.string.pref_key_group_recognized_text_in_blocks);
        return sharedPreferences.getBoolean(prefKey, false);
    }

    public static boolean showLanguageTag(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String prefKey = context.getString(R.string.pref_key_show_language_tag);
        return sharedPreferences.getBoolean(prefKey, false);
    }

    public static boolean shouldShowTextConfidence(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String prefKey = context.getString(R.string.pref_key_show_text_confidence);
        return sharedPreferences.getBoolean(prefKey, false);
    }

    public static boolean shouldShowPoseDetectionInFrameLikelihoodLivePreview(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String prefKey = context.getString(R.string.pref_key_live_preview_pose_detector_show_in_frame_likelihood);
        return sharedPreferences.getBoolean(prefKey, true);
    }

    public static boolean shouldShowPoseDetectionInFrameLikelihoodStillImage(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String prefKey = context.getString(R.string.pref_key_still_image_pose_detector_show_in_frame_likelihood);
        return sharedPreferences.getBoolean(prefKey, true);
    }

    public static boolean shouldSegmentationEnableRawSizeMask(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String prefKey = context.getString(R.string.pref_key_segmentation_raw_size_mask);
        return sharedPreferences.getBoolean(prefKey, false);
    }

    private static int getModeTypePreferenceValue(Context context, @StringRes int prefKeyResId, int defaultValue) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String prefKey = context.getString(prefKeyResId);
        return Integer.parseInt(sharedPreferences.getString(prefKey, String.valueOf(defaultValue)));
    }

    public static boolean isCameraLiveViewportEnabled(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String prefKey = context.getString(R.string.pref_key_camera_live_viewport);
        return sharedPreferences.getBoolean(prefKey, false);
    }

    private PreferenceUtils() {
    }
}

