/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.activity;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.kyc.nashidmrz.OtherConstant;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.Utility;
import com.kyc.nashidmrz.mrtd2.resultcallback.ApiResponseListner;
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.DocumentImages;
import com.kyc.nashidmrz.networking.APIClient;
import com.kyc.nashidmrz.networking.APIInterface;
import com.kyc.nashidmrz.networking.models.AutoCrop;
import com.kyc.nashidmrz.utility.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AMLAutoCrop {
    private static boolean isAutoCropCalled = false;
    private static boolean isAMLCalled = false;
    private static int count = 1;
    private static ApiResponseListner apiResponseListner;

    public static void setListner(ApiResponseListner apiResponseListner1) {
        apiResponseListner = apiResponseListner1;
    }

    public static void callAML(String name, String dob, String nationality, String docNumber, String country) {
        Log.d((String)"TAG", (String)"callapi: AML");
        isAMLCalled = false;
        String personData = "[{\"name\": \"" + name + "\", \"birthDate\": \"" + dob + "\", \"nationality\": \"" + nationality + "\", \"identifier\": \"" + docNumber + "\", \"country\": \"" + country + "\"}]";
        String checksData = "[\"role.oligarch\",\"role.pep\",\"role.rca\",\"sanction\",\"crime.terror\",\"crime\"]";
        Log.d((String)"TAG", (String)("callAML: " + personData + "   " + checksData));
        ((APIInterface)APIClient.getClient("AML", OtherConstant.getInstance().getAmlBaseUrl()).create(APIInterface.class)).aml(personData, checksData).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                block17: {
                    try {
                        Log.d((String)"TAG", (String)("onResponse:AML-- " + response.isSuccessful() + "   " + response));
                        if (response.isSuccessful()) {
                            try {
                                String jsonResponse = ((ResponseBody)response.body()).string();
                                JSONObject jsonObject = new JSONObject(jsonResponse);
                                boolean status = jsonObject.getBoolean("status");
                                DocumentImages documentImages = DocumentImages.Companion.getInstance();
                                if (status) {
                                    isAMLCalled = true;
                                    JSONArray responseArray = jsonObject.getJSONArray("response");
                                    Log.d((String)"TAG", (String)("callapi: AML success response" + jsonObject + "   " + (responseArray.length() > 0)));
                                    if (responseArray.length() > 0) {
                                        JSONArray innerArray = responseArray.getJSONArray(0);
                                        if (innerArray.length() > 0) {
                                            for (int i = 0; i < innerArray.length(); ++i) {
                                                JSONObject object = innerArray.getJSONObject(i);
                                                String name = object.optString("name");
                                                String birthDate = object.optString("birthDate");
                                                String nationality = object.optString("nationality");
                                                String topics = object.optString("topics");
                                                if (topics.equalsIgnoreCase("role.oligarch") || topics.equalsIgnoreCase("role.pep") || topics.equalsIgnoreCase("role.rca") || topics.equalsIgnoreCase("sanction") || topics.equalsIgnoreCase("crime.terror") || topics.equalsIgnoreCase("crime")) {
                                                    documentImages.setAMLSucess(false);
                                                    break;
                                                }
                                                documentImages.setAMLSucess(true);
                                            }
                                        } else {
                                            documentImages.setAMLSucess(true);
                                        }
                                    } else {
                                        documentImages.setAMLSucess(true);
                                    }
                                } else {
                                    isAMLCalled = true;
                                    documentImages.setAMLSucess(false);
                                }
                                if (isAutoCropCalled && apiResponseListner != null) {
                                    apiResponseListner.onCompleteSuccess();
                                }
                                break block17;
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                isAMLCalled = true;
                                Log.d((String)"TAG", (String)"callapi: AML fail response");
                                Log.d((String)"TAG", (String)("onResponse: " + isAutoCropCalled));
                                if (isAutoCropCalled && apiResponseListner != null) {
                                    apiResponseListner.onCompleteSuccess();
                                }
                                break block17;
                            }
                        }
                        isAMLCalled = true;
                        if (isAutoCropCalled && apiResponseListner != null) {
                            apiResponseListner.onCompleteSuccess();
                        }
                    }
                    catch (Exception e) {
                        isAMLCalled = true;
                        e.printStackTrace();
                        if (!isAutoCropCalled || apiResponseListner == null) break block17;
                        apiResponseListner.onCompleteSuccess();
                    }
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                isAMLCalled = true;
                if (isAutoCropCalled && apiResponseListner != null) {
                    apiResponseListner.onCompleteSuccess();
                }
            }
        });
    }

    public static void callAutoCropAPI(final Activity context) {
        Log.d((String)"TAG", (String)"callapi: autocrop");
        isAutoCropCalled = false;
        final DocumentImages documentImages = DocumentImages.Companion.getInstance();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])Utility.Companion.getInstance().getScannedImage(), (int)0, (int)Utility.Companion.getInstance().getScannedImage().length);
        if (bitmap == null) {
            bitmap.recycle();
            bitmap = DataUtils.getCropImageBitmap(context, Utility.Companion.getInstance().getScannedImage());
        }
        Bitmap finalBitmap = bitmap;
        AMLAutoCrop.callAutoCrop(context, bitmap, new AutoCroppedCallbacks(){

            @Override
            public void onSuccess(String url) {
                Log.d((String)"TAG", (String)"callapi: get cropped image");
                documentImages.setFrontCropPage(url);
                if (Utility.Companion.getInstance().getSelectedDoc() != null && !Utility.Companion.getInstance().getSelectedDoc().equalsIgnoreCase(context.getString(R.string.e_passport))) {
                    AMLAutoCrop.cropSecondImage(context);
                } else {
                    Log.d((String)"TAG", (String)"callapi: crop else");
                    isAutoCropCalled = true;
                    if (isAMLCalled && apiResponseListner != null) {
                        apiResponseListner.onCompleteSuccess();
                    }
                }
            }

            @Override
            public void onFail() {
                Log.d((String)"TAG", (String)"callapi: crop fail");
                if (Utility.Companion.getInstance().getSelectedDoc() != null && Utility.Companion.getInstance().getSelectedDoc().equalsIgnoreCase(context.getString(R.string.e_passport))) {
                    isAutoCropCalled = true;
                    if (isAMLCalled && apiResponseListner != null) {
                        apiResponseListner.onCompleteSuccess();
                    }
                } else {
                    AMLAutoCrop.cropSecondImage(context);
                }
            }
        });
    }

    private static void cropSecondImage(Activity context) {
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])Utility.Companion.getInstance().getScannedIdFrontView(), (int)0, (int)Utility.Companion.getInstance().getScannedIdFrontView().length);
        AMLAutoCrop.callAutoCrop(context, bitmap, new AutoCroppedCallbacks(){

            @Override
            public void onSuccess(String url) {
                DocumentImages documentImages = DocumentImages.Companion.getInstance();
                documentImages.setBackCropPage(url);
                isAutoCropCalled = true;
                if (isAMLCalled && apiResponseListner != null) {
                    apiResponseListner.onCompleteSuccess();
                }
            }

            @Override
            public void onFail() {
                isAutoCropCalled = true;
                if (isAMLCalled && apiResponseListner != null) {
                    apiResponseListner.onCompleteSuccess();
                }
            }
        });
    }

    private static void callAutoCrop(Activity activity, Bitmap bitmap, final AutoCroppedCallbacks autoCroppedCallbacks) {
        final boolean[] isSuccess = new boolean[]{false};
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        MediaType mediaType = MediaType.parse((String)"image/png");
        File filename1 = new File(activity.getFilesDir(), "cropped.png");
        if (filename1.exists()) {
            filename1.delete();
        }
        try (FileOutputStream fos = new FileOutputStream(filename1);){
            fos.write(byteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RequestBody fileRequestBody = RequestBody.create((File)filename1, (MediaType)MediaType.parse((String)"image/jpeg"));
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)"cropped", (RequestBody)fileRequestBody);
        RequestBody param1 = RequestBody.create((String)APIClient.autoCropApiKey(), (MediaType)MediaType.parse((String)"text/plain"));
        RequestBody param2 = RequestBody.create((String)APIClient.autoCropApiSecretKey(), (MediaType)MediaType.parse((String)"text/plain"));
        ((APIInterface)APIClient.getClient("image crop", OtherConstant.getInstance().getAutoCropBaseUrl()).create(APIInterface.class)).callAutoCrop(param1, param2, filePart).enqueue((Callback)new Callback<AutoCrop>(){

            public void onResponse(Call<AutoCrop> call, Response<AutoCrop> response) {
                block8: {
                    try {
                        if (response.code() == 200) {
                            if (autoCroppedCallbacks != null) {
                                if (response.body() != null && ((AutoCrop)response.body()).getPresigned_url() != null) {
                                    autoCroppedCallbacks.onSuccess(((AutoCrop)response.body()).getPresigned_url());
                                } else {
                                    autoCroppedCallbacks.onFail();
                                }
                            }
                        } else if (autoCroppedCallbacks != null) {
                            autoCroppedCallbacks.onFail();
                        }
                    }
                    catch (Exception e) {
                        Log.d((String)"TAG", (String)("callapi callAutoCrop onFailure:catch " + e.toString()));
                        isSuccess[0] = false;
                        if (autoCroppedCallbacks == null) break block8;
                        autoCroppedCallbacks.onFail();
                    }
                }
            }

            public void onFailure(Call<AutoCrop> call, Throwable t) {
                Log.d((String)"TAG", (String)("callapi callAutoCrop onFailure: " + t));
                isSuccess[0] = false;
                if (autoCroppedCallbacks != null) {
                    autoCroppedCallbacks.onFail();
                }
            }
        });
    }

    public static interface AutoCroppedCallbacks {
        public void onSuccess(String var1);

        public void onFail();
    }
}

