/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.images.Size;
import com.kyc.nashidmrz.mrtd2.FrameMetadata;
import com.kyc.nashidmrz.mrtd2.GraphicOverlay;
import com.kyc.nashidmrz.mrtd2.PreferenceUtils;
import com.kyc.nashidmrz.mrtd2.VisionImageProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    public static final int IMAGE_FORMAT = 17;
    public static final int DEFAULT_REQUESTED_CAMERA_PREVIEW_WIDTH = 480;
    public static final int DEFAULT_REQUESTED_CAMERA_PREVIEW_HEIGHT = 360;
    private static final String TAG = "MIDemoApp:CameraSource";
    private static final int DUMMY_TEXTURE_NAME = 100;
    private static final float ASPECT_RATIO_TOLERANCE = 0.01f;
    protected Activity activity;
    private Camera camera;
    private int facing = 0;
    private int rotationDegrees;
    private Size previewSize;
    private static final float REQUESTED_FPS = 30.0f;
    private static final boolean REQUESTED_AUTO_FOCUS = true;
    private SurfaceTexture dummySurfaceTexture;
    private final GraphicOverlay graphicOverlay;
    private Thread processingThread;
    private final FrameProcessingRunnable processingRunnable;
    private final Object processorLock = new Object();
    private VisionImageProcessor frameProcessor;
    private final IdentityHashMap<byte[], ByteBuffer> bytesToByteBuffer = new IdentityHashMap();

    public CameraSource(Activity activity, GraphicOverlay overlay) {
        this.activity = activity;
        this.graphicOverlay = overlay;
        this.graphicOverlay.clear();
        this.processingRunnable = new FrameProcessingRunnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.processorLock;
        synchronized (object) {
            this.stop();
            this.cleanScreen();
            if (this.frameProcessor != null) {
                this.frameProcessor.stop();
            }
        }
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public synchronized CameraSource start() throws IOException {
        if (this.camera != null) {
            return this;
        }
        this.camera = this.createCamera();
        this.dummySurfaceTexture = new SurfaceTexture(100);
        this.camera.setPreviewTexture(this.dummySurfaceTexture);
        this.camera.startPreview();
        this.processingThread = new Thread(this.processingRunnable);
        this.processingRunnable.setActive(true);
        this.processingThread.start();
        return this;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public synchronized CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        if (this.camera != null) {
            return this;
        }
        this.camera = this.createCamera();
        this.camera.setPreviewDisplay(surfaceHolder);
        this.camera.startPreview();
        this.processingThread = new Thread(this.processingRunnable);
        this.processingRunnable.setActive(true);
        this.processingThread.start();
        return this;
    }

    public synchronized void stop() {
        this.processingRunnable.setActive(false);
        if (this.processingThread != null) {
            try {
                this.processingThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.processingThread = null;
        }
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
            try {
                this.camera.setPreviewTexture(null);
                this.dummySurfaceTexture = null;
                this.camera.setPreviewDisplay(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.camera.release();
            this.camera = null;
        }
        this.bytesToByteBuffer.clear();
    }

    public synchronized void setFacing(int facing) {
        if (facing != 0 && facing != 1) {
            throw new IllegalArgumentException("Invalid camera: " + facing);
        }
        this.facing = facing;
    }

    public Size getPreviewSize() {
        return this.previewSize;
    }

    public int getCameraFacing() {
        return this.facing;
    }

    @SuppressLint(value={"InlinedApi"})
    private Camera createCamera() throws IOException {
        int requestedCameraId = CameraSource.getIdForRequestedCamera(this.facing);
        if (requestedCameraId == -1) {
            throw new IOException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)requestedCameraId);
        SizePair sizePair = PreferenceUtils.getCameraPreviewSizePair((Context)this.activity, requestedCameraId);
        if (sizePair == null) {
            sizePair = CameraSource.selectSizePair(camera, 480, 360);
        }
        if (sizePair == null) {
            throw new IOException("Could not find suitable preview size.");
        }
        this.previewSize = sizePair.preview;
        int[] previewFpsRange = CameraSource.selectPreviewFpsRange(camera, 30.0f);
        if (previewFpsRange == null) {
            throw new IOException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        Size pictureSize = sizePair.picture;
        if (pictureSize != null) {
            parameters.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        }
        parameters.setPreviewSize(this.previewSize.getWidth(), this.previewSize.getHeight());
        parameters.setPreviewFpsRange(previewFpsRange[0], previewFpsRange[1]);
        parameters.setPreviewFormat(17);
        this.setRotation(camera, parameters, requestedCameraId);
        if (parameters.getSupportedFocusModes().contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new CameraPreviewCallback());
        camera.addCallbackBuffer(this.createPreviewBuffer(this.previewSize));
        camera.addCallbackBuffer(this.createPreviewBuffer(this.previewSize));
        camera.addCallbackBuffer(this.createPreviewBuffer(this.previewSize));
        camera.addCallbackBuffer(this.createPreviewBuffer(this.previewSize));
        return camera;
    }

    private static int getIdForRequestedCamera(int facing) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != facing) continue;
            return i;
        }
        return -1;
    }

    public static SizePair selectSizePair(Camera camera, int desiredWidth, int desiredHeight) {
        List<SizePair> validPreviewSizes = CameraSource.generateValidPreviewSizeList(camera);
        SizePair selectedPair = null;
        int minDiff = Integer.MAX_VALUE;
        for (SizePair sizePair : validPreviewSizes) {
            Size size = sizePair.preview;
            int diff = Math.abs(size.getWidth() - desiredWidth) + Math.abs(size.getHeight() - desiredHeight);
            if (diff >= minDiff) continue;
            selectedPair = sizePair;
            minDiff = diff;
        }
        return selectedPair;
    }

    public static List<SizePair> generateValidPreviewSizeList(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List supportedPreviewSizes = parameters.getSupportedPreviewSizes();
        List supportedPictureSizes = parameters.getSupportedPictureSizes();
        ArrayList<SizePair> validPreviewSizes = new ArrayList<SizePair>();
        block0: for (Camera.Size previewSize : supportedPreviewSizes) {
            float previewAspectRatio = (float)previewSize.width / (float)previewSize.height;
            for (Camera.Size pictureSize : supportedPictureSizes) {
                float pictureAspectRatio = (float)pictureSize.width / (float)pictureSize.height;
                if (!(Math.abs(previewAspectRatio - pictureAspectRatio) < 0.01f)) continue;
                validPreviewSizes.add(new SizePair(previewSize, pictureSize));
                continue block0;
            }
        }
        if (validPreviewSizes.size() == 0) {
            for (Camera.Size previewSize : supportedPreviewSizes) {
                validPreviewSizes.add(new SizePair(previewSize, null));
            }
        }
        return validPreviewSizes;
    }

    @SuppressLint(value={"InlinedApi"})
    private static int[] selectPreviewFpsRange(Camera camera, float desiredPreviewFps) {
        int desiredPreviewFpsScaled = (int)(desiredPreviewFps * 1000.0f);
        int[] selectedFpsRange = null;
        int minUpperBoundDiff = Integer.MAX_VALUE;
        int minLowerBound = Integer.MAX_VALUE;
        List previewFpsRangeList = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] range : previewFpsRangeList) {
            int upperBoundDiff = Math.abs(desiredPreviewFpsScaled - range[1]);
            int lowerBound = range[0];
            if (upperBoundDiff > minUpperBoundDiff || lowerBound > minLowerBound) continue;
            selectedFpsRange = range;
            minUpperBoundDiff = upperBoundDiff;
            minLowerBound = lowerBound;
        }
        return selectedFpsRange;
    }

    private void setRotation(Camera camera, Camera.Parameters parameters, int cameraId) {
        int displayAngle;
        WindowManager windowManager = (WindowManager)this.activity.getSystemService("window");
        int degrees = 0;
        int rotation = windowManager.getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
                break;
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            this.rotationDegrees = (cameraInfo.orientation + degrees) % 360;
            displayAngle = (360 - this.rotationDegrees) % 360;
        } else {
            displayAngle = this.rotationDegrees = (cameraInfo.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(displayAngle);
        parameters.setRotation(this.rotationDegrees);
    }

    @SuppressLint(value={"InlinedApi"})
    private byte[] createPreviewBuffer(Size previewSize) {
        int bitsPerPixel = ImageFormat.getBitsPerPixel((int)17);
        long sizeInBits = (long)previewSize.getHeight() * (long)previewSize.getWidth() * (long)bitsPerPixel;
        int bufferSize = (int)Math.ceil((double)sizeInBits / 8.0) + 1;
        byte[] byteArray = new byte[bufferSize];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        if (!buffer.hasArray() || buffer.array() != byteArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.bytesToByteBuffer.put(byteArray, buffer);
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMachineLearningFrameProcessor(VisionImageProcessor processor) {
        Object object = this.processorLock;
        synchronized (object) {
            this.cleanScreen();
            if (this.frameProcessor != null) {
                this.frameProcessor.stop();
            }
            this.frameProcessor = processor;
        }
    }

    private void cleanScreen() {
        this.graphicOverlay.clear();
    }

    private class FrameProcessingRunnable
    implements Runnable {
        private final Object lock = new Object();
        private boolean active = true;
        private ByteBuffer pendingFrameData;

        FrameProcessingRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean active) {
            Object object = this.lock;
            synchronized (object) {
                this.active = active;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setNextFrame(byte[] data, Camera camera) {
            Object object = this.lock;
            synchronized (object) {
                if (this.pendingFrameData != null) {
                    camera.addCallbackBuffer(this.pendingFrameData.array());
                    this.pendingFrameData = null;
                }
                if (!CameraSource.this.bytesToByteBuffer.containsKey(data)) {
                    return;
                }
                this.pendingFrameData = CameraSource.this.bytesToByteBuffer.get(data);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public void run() {
            while (true) {
                ByteBuffer data;
                Object object = this.lock;
                synchronized (object) {
                    while (this.active && this.pendingFrameData == null) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    if (!this.active) {
                        return;
                    }
                    data = this.pendingFrameData;
                    this.pendingFrameData = null;
                }
                try {
                    object = CameraSource.this.processorLock;
                    synchronized (object) {
                        CameraSource.this.frameProcessor.processByteBuffer(data, new FrameMetadata.Builder().setWidth(CameraSource.this.previewSize.getWidth()).setHeight(CameraSource.this.previewSize.getHeight()).setRotation(CameraSource.this.rotationDegrees).build(), CameraSource.this.graphicOverlay);
                    }
                }
                catch (Exception exception) {}
                continue;
                finally {
                    CameraSource.this.camera.addCallbackBuffer(data.array());
                    continue;
                }
                break;
            }
        }
    }

    public static class SizePair {
        public final Size preview;
        @Nullable
        public final Size picture;

        SizePair(Camera.Size previewSize, @Nullable Camera.Size pictureSize) {
            this.preview = new Size(previewSize.width, previewSize.height);
            this.picture = pictureSize != null ? new Size(pictureSize.width, pictureSize.height) : null;
        }

        public SizePair(Size previewSize, @Nullable Size pictureSize) {
            this.preview = previewSize;
            this.picture = pictureSize;
        }
    }

    private class CameraPreviewCallback
    implements Camera.PreviewCallback {
        private CameraPreviewCallback() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            CameraSource.this.processingRunnable.setNextFrame(data, camera);
        }
    }
}

