/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.activity;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.databinding.ItemSelectDocumentBinding;
import com.kyc.nashidmrz.mrtd2.activity.OnDocumentItemListener;
import com.kyc.nashidmrz.mrtd2.activity.TextSizeConverter;

public class DocumentTypeListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private String[] list;
    private final int[] images = new int[]{R.raw.epassport, R.raw.idcard};
    private int lastCheckedPosition = -1;
    private final Context context;
    private OnDocumentItemListener onDocumentItemListener;

    public void setListner(OnDocumentItemListener listener) {
        this.onDocumentItemListener = listener;
    }

    public DocumentTypeListAdapter(Context context, String[] listData) {
        this.context = context;
        this.list = listData;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        ItemSelectDocumentBinding binding = ItemSelectDocumentBinding.inflate(layoutInflater, parent, false);
        return new ViewHolder(binding);
    }

    public void onBindViewHolder(ViewHolder holder, final int position) {
        SVG svg3 = null;
        try {
            svg3 = SVG.getFromResource((Resources)this.context.getResources(), (int)this.images[position]);
            holder.itemSelectDocumentBinding.imgEpassport.setSVG(svg3);
        }
        catch (SVGParseException sVGParseException) {
            // empty catch block
        }
        holder.itemSelectDocumentBinding.mainDocItem.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int copyOfLastCheckedPosition = DocumentTypeListAdapter.this.lastCheckedPosition;
                DocumentTypeListAdapter.this.lastCheckedPosition = position;
                DocumentTypeListAdapter.this.notifyItemChanged(copyOfLastCheckedPosition);
                DocumentTypeListAdapter.this.notifyItemChanged(DocumentTypeListAdapter.this.lastCheckedPosition);
                if (DocumentTypeListAdapter.this.onDocumentItemListener != null) {
                    DocumentTypeListAdapter.this.onDocumentItemListener.onDocumentItemClick(DocumentTypeListAdapter.this.list[DocumentTypeListAdapter.this.lastCheckedPosition]);
                }
            }
        });
        Log.d((String)"TAG", (String)("DocumentTypeListAdapter: " + this.list[position]));
        if (position == this.lastCheckedPosition) {
            try {
                svg3 = SVG.getFromResource((Resources)this.context.getResources(), (int)R.raw.select_cehckbix);
                holder.itemSelectDocumentBinding.itemCheck.setSVG(svg3);
            }
            catch (SVGParseException sVGParseException) {
                // empty catch block
            }
            holder.itemSelectDocumentBinding.txtDocType.setText((CharSequence)this.list[position]);
            holder.itemSelectDocumentBinding.mainDocItem.setCardBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.selected_card_background));
            holder.itemSelectDocumentBinding.cardIconBack.setCardBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.selected_option_background));
        } else {
            try {
                svg3 = SVG.getFromResource((Resources)this.context.getResources(), (int)R.raw.unselect_checkbox);
                holder.itemSelectDocumentBinding.itemCheck.setSVG(svg3);
            }
            catch (SVGParseException sVGParseException) {
                // empty catch block
            }
            holder.itemSelectDocumentBinding.txtDocType.setText((CharSequence)this.list[position]);
            holder.itemSelectDocumentBinding.mainDocItem.setCardBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.card_background));
            holder.itemSelectDocumentBinding.cardIconBack.setCardBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.option_background));
        }
    }

    public int getItemCount() {
        return this.list.length;
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private final ItemSelectDocumentBinding itemSelectDocumentBinding;

        public ViewHolder(ItemSelectDocumentBinding itemSelectDocumentBinding) {
            super((View)itemSelectDocumentBinding.getRoot());
            this.itemSelectDocumentBinding = itemSelectDocumentBinding;
            itemSelectDocumentBinding.txtDocType.setTextSize(0, new TextSizeConverter(DocumentTypeListAdapter.this.context).getTextSize(16));
            TextSizeConverter textSizeConverter = new TextSizeConverter(DocumentTypeListAdapter.this.context);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(textSizeConverter.getWidth(50), textSizeConverter.getHeight(50));
            itemSelectDocumentBinding.cardIconBack.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ViewGroup.LayoutParams layoutParams1 = itemSelectDocumentBinding.imgEpassport.getLayoutParams();
            layoutParams1.width = textSizeConverter.getWidth(24);
            layoutParams1.height = textSizeConverter.getHeight(24);
            itemSelectDocumentBinding.imgEpassport.setLayoutParams(layoutParams1);
            int padding = textSizeConverter.getPaddingORMarginValue(8);
            itemSelectDocumentBinding.itemLyout.setPadding(padding, padding, padding, padding);
            LinearLayout.LayoutParams cardLayoutParam = textSizeConverter.getLinearLayoutParam();
            cardLayoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(8), 0, 0);
            itemSelectDocumentBinding.mainDocItem.setLayoutParams((ViewGroup.LayoutParams)cardLayoutParam);
        }
    }
}

