/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.activity;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import com.kyc.nashidmrz.NashidSDK;
import com.kyc.nashidmrz.OtherConstant;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.databinding.ActivitySettingBinding;
import com.kyc.nashidmrz.mrtd2.activity.BaseActivity;
import com.kyc.nashidmrz.mrtd2.activity.TextSizeConverter;
import com.kyc.nashidmrz.mrtd2.rooted.RootedCheck;
import com.kyc.nashidmrz.networking.APIClient;
import com.kyc.nashidmrz.networking.APIInterface;
import com.kyc.nashidmrz.networking.models.nashidfeaturecheck.NashidFeatureCheck;
import com.kyc.nashidmrz.utility.SharePreferenceUtility;
import java.util.ArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class SettingScreenActivity
extends BaseActivity {
    private ActivitySettingBinding binding;
    private boolean isNFCEnabled = true;
    private boolean isFacialMatchingEnabled = true;
    private boolean isAMLScreeningEnabled = true;
    private boolean isInstructionEnabled = true;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivitySettingBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        RootedCheck.getInstance().setFlag((Activity)this);
        if (RootedCheck.getInstance().isRootedDevice(this.getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog((Activity)this, this.getString(R.string.root_dialog), this.getString(R.string.root_desc), this.getString(R.string.root_btn));
        } else {
            this.setLayoutAndTextSize();
            if (OtherConstant.getInstance().getAppName().equalsIgnoreCase(this.getString(R.string.default_name))) {
                this.binding.lytAmlScreening.setVisibility(0);
                this.binding.lytInstruction.setVisibility(0);
            } else {
                this.binding.lytNfc.setVisibility(8);
                this.binding.lytFacialMatching.setVisibility(8);
                this.binding.lytAmlScreening.setVisibility(8);
                this.binding.lytInstruction.setVisibility(8);
                this.callNashidFeatureCheckAPI();
            }
            this.initClick();
        }
    }

    private void callNashidFeatureCheckAPI() {
        this.binding.lytLoading.setVisibility(0);
        Log.d((String)"TAG", (String)("callNashidFeatureCheckAPI: " + NashidSDK.getInstance().getBaseURL()));
        if (!NashidSDK.getInstance().getBaseURL().equalsIgnoreCase("") && !NashidSDK.getInstance().getRegisterToken().equalsIgnoreCase("")) {
            ((APIInterface)APIClient.getNashidFeatureCheckClient(NashidSDK.getInstance().getBaseURL(), NashidSDK.getInstance().getRegisterToken()).create(APIInterface.class)).callNashidFeatureCheck(NashidSDK.getInstance().getCompanyUUID()).enqueue((Callback)new Callback<NashidFeatureCheck>(){

                public void onResponse(Call<NashidFeatureCheck> call, Response<NashidFeatureCheck> response) {
                    Log.d((String)"TAG", (String)("openScanDocumentScreen onResponse: " + response.isSuccessful() + "\n" + response.body()));
                    try {
                        if (response.isSuccessful()) {
                            NashidFeatureCheck featureCheck = (NashidFeatureCheck)response.body();
                            ArrayList<String> allFeature = featureCheck.getData().getAllFeatures();
                            ArrayList<String> feature = featureCheck.getData().getFeatures();
                            Log.d((String)"TAG", (String)("onResponse:feature check " + feature + "\n" + allFeature));
                            if (allFeature.contains("NFC")) {
                                SettingScreenActivity.this.binding.lytNfc.setVisibility(0);
                            } else {
                                SharePreferenceUtility.savePreferenceValue(SettingScreenActivity.this.getApplicationContext(), SettingScreenActivity.this.getString(R.string.sharepreference_nfc), false);
                            }
                            if (allFeature.contains("Liveness") || allFeature.contains("Face-Match")) {
                                SettingScreenActivity.this.binding.lytFacialMatching.setVisibility(0);
                            } else {
                                SharePreferenceUtility.savePreferenceValue(SettingScreenActivity.this.getApplicationContext(), SettingScreenActivity.this.getString(R.string.sharepreference_facila_matching), false);
                            }
                            if (feature.contains("NFC")) {
                                SettingScreenActivity.this.isNFCEnabled = true;
                                SettingScreenActivity.this.binding.imgNfc.setImageResource(R.drawable.toggle_on);
                                SharePreferenceUtility.savePreferenceValue(SettingScreenActivity.this.getApplicationContext(), SettingScreenActivity.this.getString(R.string.sharepreference_nfc), true);
                            } else {
                                SettingScreenActivity.this.binding.imgNfc.setImageResource(R.drawable.toggle_off);
                                SharePreferenceUtility.savePreferenceValue(SettingScreenActivity.this.getApplicationContext(), SettingScreenActivity.this.getString(R.string.sharepreference_nfc), false);
                            }
                            if (feature.contains("Liveness") || feature.contains("Face-Match")) {
                                SettingScreenActivity.this.isFacialMatchingEnabled = true;
                                SettingScreenActivity.this.binding.imgFacialMatching.setImageResource(R.drawable.toggle_on);
                                SharePreferenceUtility.savePreferenceValue(SettingScreenActivity.this.getApplicationContext(), SettingScreenActivity.this.getString(R.string.sharepreference_facila_matching), true);
                            } else {
                                SettingScreenActivity.this.binding.imgFacialMatching.setImageResource(R.drawable.toggle_off);
                                SharePreferenceUtility.savePreferenceValue(SettingScreenActivity.this.getApplicationContext(), SettingScreenActivity.this.getString(R.string.sharepreference_facila_matching), false);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SettingScreenActivity.this.binding.lytLoading.setVisibility(8);
                    if (SettingScreenActivity.this.binding.lytNfc.getVisibility() == 8 && SettingScreenActivity.this.binding.lytFacialMatching.getVisibility() == 8) {
                        SettingScreenActivity.this.binding.btnSave.setVisibility(8);
                    }
                }

                public void onFailure(Call<NashidFeatureCheck> call, Throwable t) {
                    SettingScreenActivity.this.binding.lytLoading.setVisibility(8);
                    Log.d((String)"TAG", (String)("openScanDocumentScreen onFailure: " + t.toString()));
                }
            });
        } else {
            this.binding.lytLoading.setVisibility(8);
        }
    }

    private void callManageFeatureAPI(String features) {
        Log.d((String)"TAG", (String)("callNashidFeatureCheckAPI: " + NashidSDK.getInstance().getBaseURL()));
        if (!NashidSDK.getInstance().getBaseURL().equalsIgnoreCase("") && !NashidSDK.getInstance().getRegisterToken().equalsIgnoreCase("")) {
            this.binding.lytLoading.setVisibility(0);
            ((APIInterface)APIClient.getNashidFeatureCheckClient(NashidSDK.getInstance().getBaseURL(), NashidSDK.getInstance().getRegisterToken()).create(APIInterface.class)).callManageFeature(features, NashidSDK.getInstance().getCompanyUUID()).enqueue((Callback)new Callback<NashidFeatureCheck>(){

                public void onResponse(Call<NashidFeatureCheck> call, Response<NashidFeatureCheck> response) {
                    Log.d((String)"TAG", (String)("openScanDocumentScreen onResponse---: " + response.isSuccessful() + "\n" + response.body()));
                    try {
                        if (response.isSuccessful()) {
                            NashidFeatureCheck featureCheck = (NashidFeatureCheck)response.body();
                            ArrayList<String> allFeature = featureCheck.getData().getAllFeatures();
                            ArrayList<String> feature = featureCheck.getData().getFeatures();
                            Log.d((String)"TAG", (String)("onResponse:mange feature " + feature + "\n" + allFeature));
                            SettingScreenActivity.this.finish();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void onFailure(Call<NashidFeatureCheck> call, Throwable t) {
                    Log.d((String)"TAG", (String)("openScanDocumentScreen onFailure: " + t.toString()));
                }
            });
        } else {
            this.binding.lytLoading.setVisibility(8);
            this.finish();
        }
    }

    private void initClick() {
        this.binding.lytHeaderMain.imgBack.setOnClickListener(view -> this.finish());
        this.binding.imgNfc.setOnClickListener(view -> {
            this.isNFCEnabled = !this.isNFCEnabled;
            this.enableDisableNFC();
        });
        this.binding.imgFacialMatching.setOnClickListener(view -> {
            this.isFacialMatchingEnabled = !this.isFacialMatchingEnabled;
            this.enableDisableFacialMatching();
        });
        this.binding.imgAmlScreening.setOnClickListener(view -> {
            this.isAMLScreeningEnabled = !this.isAMLScreeningEnabled;
            this.enableDisableAMLScreening();
        });
        this.binding.imgInstruction.setOnClickListener(view -> {
            this.isInstructionEnabled = !this.isInstructionEnabled;
            this.enableDisableInstruction();
        });
        this.binding.btnSave.setOnClickListener(view -> {
            if (OtherConstant.getInstance().getAppName().equalsIgnoreCase(this.getString(R.string.default_name))) {
                SharePreferenceUtility.savePreferenceValue(this.getApplicationContext(), this.getString(R.string.sharepreference_nfc), this.isNFCEnabled);
                SharePreferenceUtility.savePreferenceValue(this.getApplicationContext(), this.getString(R.string.sharepreference_facila_matching), this.isFacialMatchingEnabled);
                SharePreferenceUtility.savePreferenceValue(this.getApplicationContext(), this.getString(R.string.sharepreference_aml_screening), this.isAMLScreeningEnabled);
                SharePreferenceUtility.savePreferenceValue(this.getApplicationContext(), this.getString(R.string.sharepreference_verification_step), this.isInstructionEnabled);
                this.finish();
            } else {
                String feature = "Scan";
                if (this.isNFCEnabled) {
                    feature = feature + ",NFC";
                }
                if (this.isFacialMatchingEnabled) {
                    feature = feature + ",Liveness";
                }
                this.callManageFeatureAPI(feature);
            }
        });
    }

    private void setLayoutAndTextSize() {
        TextSizeConverter textSizeConverter = new TextSizeConverter(this.getApplicationContext());
        textSizeConverter.changeStatusBarColor((Activity)this);
        ViewGroup.LayoutParams layoutParams2 = this.binding.lytHeaderMain.imgBack.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.binding.lytHeaderMain.imgBack.setLayoutParams(layoutParams2);
        if (this.getStorage().getPreferredLocale().equalsIgnoreCase("ar")) {
            this.binding.lytHeaderMain.imgBack.setRotation(180.0f);
        }
        LinearLayout.LayoutParams layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(4), 0, 0);
        this.binding.lytHeaderMain.lytHeaderMain.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.binding.lytHeaderMain.txtHelp.setText((CharSequence)this.getString(R.string.setting));
        this.binding.lytHeaderMain.txtHelp.setTextSize(0, textSizeConverter.getTextSize(17));
        int padding = textSizeConverter.getPaddingORMarginValue(16);
        this.binding.lytSettingMain.setPadding(padding, padding, padding, padding);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(56), 0, 0);
        this.binding.lytNfc.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        this.binding.lytFacialMatching.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        this.binding.lytAmlScreening.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        this.binding.lytInstruction.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.binding.txtNfc.setTextSize(0, textSizeConverter.getTextSize(18));
        this.binding.txtFacialMatching.setTextSize(0, textSizeConverter.getTextSize(18));
        this.binding.txtAmlScreening.setTextSize(0, textSizeConverter.getTextSize(18));
        this.binding.txtInstruction.setTextSize(0, textSizeConverter.getTextSize(18));
        layoutParams2 = this.binding.imgNfc.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(52);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.binding.imgNfc.setLayoutParams(layoutParams2);
        layoutParams2 = this.binding.imgFacialMatching.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(52);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.binding.imgFacialMatching.setLayoutParams(layoutParams2);
        layoutParams2 = this.binding.imgAmlScreening.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(52);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.binding.imgAmlScreening.setLayoutParams(layoutParams2);
        layoutParams2 = this.binding.imgInstruction.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(52);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.binding.imgInstruction.setLayoutParams(layoutParams2);
        padding = textSizeConverter.getPaddingORMarginValue(12);
        this.binding.txtBtnSave.setPadding(0, padding, 0, padding);
        this.binding.txtBtnSave.setTextSize(0, textSizeConverter.getTextSize(16));
        this.binding.btnSave.setRadius((float)textSizeConverter.calculateRadius(8));
        SVG back = null;
        try {
            back = SVG.getFromResource((Resources)this.getResources(), (int)R.raw.back);
            this.binding.lytHeaderMain.imgBack.setSVG(back);
        }
        catch (SVGParseException sVGParseException) {
            // empty catch block
        }
        layoutParams2 = this.binding.imgLoader.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        this.binding.imgLoader.setLayoutParams(layoutParams2);
        LinearLayout.LayoutParams marginLyoutParam = (LinearLayout.LayoutParams)this.binding.txtValidating.getLayoutParams();
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(32), 0, 0);
        this.binding.txtValidating.setLayoutParams((ViewGroup.LayoutParams)marginLyoutParam);
        this.binding.txtValidating.setTextSize(0, textSizeConverter.getTextSize(20));
        Animation rotation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.rotate);
        rotation.setFillAfter(true);
        this.binding.imgLoader.startAnimation(rotation);
        this.saveData();
    }

    private void saveData() {
        this.isNFCEnabled = SharePreferenceUtility.getSavePreferenceData(this.getApplicationContext(), this.getString(R.string.sharepreference_nfc));
        this.isFacialMatchingEnabled = SharePreferenceUtility.getSavePreferenceData(this.getApplicationContext(), this.getString(R.string.sharepreference_facila_matching));
        this.isAMLScreeningEnabled = SharePreferenceUtility.getSavePreferenceData(this.getApplicationContext(), this.getString(R.string.sharepreference_aml_screening));
        this.isInstructionEnabled = SharePreferenceUtility.getSavePreferenceData(this.getApplicationContext(), this.getString(R.string.sharepreference_verification_step));
        this.enableDisableNFC();
        this.enableDisableFacialMatching();
        this.enableDisableAMLScreening();
        this.enableDisableInstruction();
    }

    private void enableDisableNFC() {
        if (this.isNFCEnabled) {
            this.binding.imgNfc.setImageResource(R.drawable.toggle_on);
        } else {
            this.binding.imgNfc.setImageResource(R.drawable.toggle_off);
        }
    }

    private void enableDisableFacialMatching() {
        if (this.isFacialMatchingEnabled) {
            this.binding.imgFacialMatching.setImageResource(R.drawable.toggle_on);
        } else {
            this.binding.imgFacialMatching.setImageResource(R.drawable.toggle_off);
        }
    }

    private void enableDisableAMLScreening() {
        if (this.isAMLScreeningEnabled) {
            this.binding.imgAmlScreening.setImageResource(R.drawable.toggle_on);
        } else {
            this.binding.imgAmlScreening.setImageResource(R.drawable.toggle_off);
        }
    }

    private void enableDisableInstruction() {
        if (this.isInstructionEnabled) {
            this.binding.imgInstruction.setImageResource(R.drawable.toggle_on);
        } else {
            this.binding.imgInstruction.setImageResource(R.drawable.toggle_off);
        }
    }
}

