/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd;

import com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd.JMRTDSecurityProvider;
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd.MRTDTrustStore;
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd.cert.KeyStoreCertStoreParameters;
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd.cert.PKDCertStoreParameters;
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd.cert.PKDMasterListCertStoreParameters;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongycastle.jce.provider.BouncyCastleProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\b\u0018\u0000 32\u00020\u0001:\u00013B=\b\u0007\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0004J\u0014\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"J\u0010\u0010#\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u0016\u0010$\u001a\u00020\u00162\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010&J\u000e\u0010'\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\tJ\u0014\u0010)\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0&J\u0006\u0010*\u001a\u00020\u0016J\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010,J\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010&J\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010&J\u0010\u0010/\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u00100\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u00102\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\tR\"\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012\u00a8\u00064"}, d2={"Lcom/kyc/nashidmrz/mrtd2/activity/passportNFC/jmrtd/MRTDTrustStore;", "", "cscaAnchors", "", "Ljava/security/cert/TrustAnchor;", "cscaStores", "", "Ljava/security/cert/CertStore;", "cvcaStores", "Ljava/security/KeyStore;", "(Ljava/util/Set;Ljava/util/List;Ljava/util/List;)V", "getCscaAnchors", "()Ljava/util/Set;", "setCscaAnchors", "(Ljava/util/Set;)V", "getCscaStores", "()Ljava/util/List;", "setCscaStores", "(Ljava/util/List;)V", "getCvcaStores", "setCvcaStores", "addAsCSCACertStore", "", "certStore", "addAsCVCAKeyStore", "uri", "Ljava/net/URI;", "addAsKeyStoreCSCACertStore", "addAsPKDStoreCSCACertStore", "addAsSingletonCSCACertStore", "addCSCAAnchor", "trustAnchor", "addCSCAAnchors", "trustAnchors", "", "addCSCAStore", "addCSCAStores", "uris", "", "addCVCAStore", "keyStore", "addCVCAStores", "clear", "getCSCAAnchors", "", "getCSCAStores", "getCVCAStores", "getKeyStore", "removeCSCAAnchor", "removeCSCAStore", "removeCVCAStore", "Companion", "IDV_release"})
public final class MRTDTrustStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<TrustAnchor> cscaAnchors;
    @Nullable
    private List<CertStore> cscaStores;
    @Nullable
    private List<KeyStore> cvcaStores;
    @NotNull
    private static final Provider JMRTD_PROVIDER;
    private static final Logger LOGGER;
    @NotNull
    private static final Companion.SELF_SIGNED_X509_CERT_SELECTOR.1 SELF_SIGNED_X509_CERT_SELECTOR;

    @JvmOverloads
    public MRTDTrustStore(@Nullable Set<TrustAnchor> cscaAnchors, @Nullable List<CertStore> cscaStores, @Nullable List<KeyStore> cvcaStores) {
        this.cscaAnchors = cscaAnchors;
        this.cscaStores = cscaStores;
        this.cvcaStores = cvcaStores;
    }

    public /* synthetic */ MRTDTrustStore(Set set, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new HashSet();
        }
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        if ((n & 4) != 0) {
            list2 = new ArrayList();
        }
        this(set, list, list2);
    }

    @Nullable
    public final Set<TrustAnchor> getCscaAnchors() {
        return this.cscaAnchors;
    }

    public final void setCscaAnchors(@Nullable Set<TrustAnchor> set) {
        this.cscaAnchors = set;
    }

    @Nullable
    public final List<CertStore> getCscaStores() {
        return this.cscaStores;
    }

    public final void setCscaStores(@Nullable List<CertStore> list) {
        this.cscaStores = list;
    }

    @Nullable
    public final List<KeyStore> getCvcaStores() {
        return this.cvcaStores;
    }

    public final void setCvcaStores(@Nullable List<KeyStore> list) {
        this.cvcaStores = list;
    }

    public final void clear() {
        this.cscaAnchors = new HashSet();
        this.cscaStores = new ArrayList();
        this.cvcaStores = new ArrayList();
    }

    @Nullable
    public final Set<TrustAnchor> getCSCAAnchors() {
        return this.cscaAnchors;
    }

    @Nullable
    public final List<CertStore> getCSCAStores() {
        return this.cscaStores;
    }

    @Nullable
    public final List<KeyStore> getCVCAStores() {
        return this.cvcaStores;
    }

    public final void addCSCAAnchor(@NotNull TrustAnchor trustAnchor) {
        Intrinsics.checkNotNullParameter((Object)trustAnchor, (String)"trustAnchor");
        Set<TrustAnchor> set = this.cscaAnchors;
        Intrinsics.checkNotNull(set);
        set.add(trustAnchor);
    }

    public final void addCSCAAnchors(@NotNull Collection<? extends TrustAnchor> trustAnchors) {
        Intrinsics.checkNotNullParameter(trustAnchors, (String)"trustAnchors");
        Set<TrustAnchor> set = this.cscaAnchors;
        Intrinsics.checkNotNull(set);
        set.addAll(trustAnchors);
    }

    public final void addCSCAStore(@Nullable URI uri) {
        block9: {
            if (uri == null) {
                LOGGER.severe("uri == null");
                return;
            }
            String scheme = uri.getScheme();
            if (scheme == null) {
                LOGGER.severe("scheme == null, location = " + uri);
                return;
            }
            try {
                if (StringsKt.equals((String)scheme, (String)"ldap", (boolean)true)) {
                    this.addAsPKDStoreCSCACertStore(uri);
                    break block9;
                }
                try {
                    this.addAsKeyStoreCSCACertStore(uri);
                }
                catch (Exception kse) {
                    try {
                        this.addAsSingletonCSCACertStore(uri);
                    }
                    catch (Exception e) {
                        LOGGER.warning("Failed to open " + uri.toASCIIString() + " both as a keystore and as a DER certificate file");
                        kse.printStackTrace();
                        e.printStackTrace();
                    }
                }
            }
            catch (GeneralSecurityException gse) {
                gse.printStackTrace();
            }
        }
    }

    public final void addCSCAStores(@Nullable List<URI> uris) {
        if (uris == null) {
            LOGGER.severe("uris == null");
            return;
        }
        for (URI uri : uris) {
            this.addCSCAStore(uri);
        }
    }

    public final void addCVCAStore(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            this.addAsCVCAKeyStore(uri);
        }
        catch (Exception e) {
            LOGGER.warning("Exception in addCVCAStore: " + e.getMessage());
        }
    }

    public final void addCVCAStores(@NotNull List<URI> uris) {
        Intrinsics.checkNotNullParameter(uris, (String)"uris");
        for (URI uri : uris) {
            this.addCVCAStore(uri);
        }
    }

    public final void addCSCAStore(@NotNull CertStore certStore) {
        Intrinsics.checkNotNullParameter((Object)certStore, (String)"certStore");
        List<CertStore> list = this.cscaStores;
        Intrinsics.checkNotNull(list);
        list.add(certStore);
    }

    public final void addCVCAStore(@NotNull KeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        List<KeyStore> list = this.cvcaStores;
        Intrinsics.checkNotNull(list);
        list.add(keyStore);
    }

    public final void removeCSCAAnchor(@NotNull TrustAnchor trustAnchor) {
        Intrinsics.checkNotNullParameter((Object)trustAnchor, (String)"trustAnchor");
        Set<TrustAnchor> set = this.cscaAnchors;
        Intrinsics.checkNotNull(set);
        set.remove(trustAnchor);
    }

    public final void removeCSCAStore(@NotNull CertStore certStore) {
        Intrinsics.checkNotNullParameter((Object)certStore, (String)"certStore");
        List<CertStore> list = this.cscaStores;
        Intrinsics.checkNotNull(list);
        list.remove(certStore);
    }

    public final void removeCVCAStore(@NotNull KeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        List<KeyStore> list = this.cvcaStores;
        Intrinsics.checkNotNull(list);
        list.remove(keyStore);
    }

    private final void addAsSingletonCSCACertStore(URI uri) throws MalformedURLException, IOException, CertificateException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, CertStoreException {
        URLConnection urlConnection = uri.toURL().openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", JMRTD_PROVIDER);
        Certificate certificate = certFactory.generateCertificate(inputStream);
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        X509Certificate certificate2 = (X509Certificate)certificate;
        inputStream.close();
        CollectionCertStoreParameters params = new CollectionCertStoreParameters(SetsKt.setOf((Object)certificate2));
        CertStore cscaStore = CertStore.getInstance("Collection", params);
        List<CertStore> list = this.cscaStores;
        Intrinsics.checkNotNull(list);
        Intrinsics.checkNotNull((Object)cscaStore);
        list.add(cscaStore);
        Collection<? extends Certificate> rootCerts = cscaStore.getCertificates(SELF_SIGNED_X509_CERT_SELECTOR);
        Intrinsics.checkNotNull(rootCerts);
        this.addCSCAAnchors(MRTDTrustStore.Companion.getAsAnchors(rootCerts));
    }

    private final void addAsCVCAKeyStore(URI uri) {
        this.addCVCAStore(this.getKeyStore(uri));
    }

    private final void addAsPKDStoreCSCACertStore(URI uri) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, CertStoreException {
        CertStore cscaStore;
        PKDCertStoreParameters pKDCertStoreParameters;
        String server = uri.getHost();
        int port = uri.getPort();
        if (port < 0) {
            Intrinsics.checkNotNull((Object)server);
            pKDCertStoreParameters = new PKDCertStoreParameters(server, 0, null, 6, null);
        } else {
            Intrinsics.checkNotNull((Object)server);
            pKDCertStoreParameters = new PKDCertStoreParameters(server, port, null, 4, null);
        }
        PKDCertStoreParameters params = pKDCertStoreParameters;
        PKDMasterListCertStoreParameters cscaParams = port < 0 ? new PKDMasterListCertStoreParameters(server, null, 2, null) : new PKDMasterListCertStoreParameters(server, port, null, 4, null);
        CertStore certStore = CertStore.getInstance("PKD", params);
        if (certStore != null) {
            this.addCSCAStore(certStore);
        }
        if ((cscaStore = CertStore.getInstance("PKD", cscaParams)) != null) {
            this.addCSCAStore(cscaStore);
        }
        CertStore certStore2 = cscaStore;
        Intrinsics.checkNotNull((Object)certStore2);
        Collection<? extends Certificate> rootCerts = certStore2.getCertificates(SELF_SIGNED_X509_CERT_SELECTOR);
        Intrinsics.checkNotNull(rootCerts);
        this.addCSCAAnchors(MRTDTrustStore.Companion.getAsAnchors(rootCerts));
    }

    private final void addAsKeyStoreCSCACertStore(URI uri) throws KeyStoreException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, CertStoreException {
        KeyStore keyStore = this.getKeyStore(uri);
        KeyStoreCertStoreParameters params = new KeyStoreCertStoreParameters(keyStore);
        CertStore certStore = CertStore.getInstance(keyStore.getType(), params);
        Intrinsics.checkNotNull((Object)certStore);
        this.addCSCAStore(certStore);
        Collection<? extends Certificate> rootCerts = certStore.getCertificates(SELF_SIGNED_X509_CERT_SELECTOR);
        Intrinsics.checkNotNull(rootCerts);
        this.addCSCAAnchors(MRTDTrustStore.Companion.getAsAnchors(rootCerts));
    }

    public final void addAsCSCACertStore(@NotNull CertStore certStore) throws KeyStoreException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, CertStoreException {
        Intrinsics.checkNotNullParameter((Object)certStore, (String)"certStore");
        this.addCSCAStore(certStore);
        Collection<? extends Certificate> rootCerts = certStore.getCertificates(SELF_SIGNED_X509_CERT_SELECTOR);
        Intrinsics.checkNotNull(rootCerts);
        this.addCSCAAnchors(MRTDTrustStore.Companion.getAsAnchors(rootCerts));
    }

    private final KeyStore getKeyStore(URI uri) {
        String[] stringArray = new String[]{"JKS", "BKS", "PKCS12"};
        for (String storeType : stringArray) {
            try {
                KeyStore keyStore = KeyStore.getInstance(storeType);
                URLConnection urlConnection = uri.toURL().openConnection();
                InputStream inputStream = urlConnection.getInputStream();
                char[] cArray = "".toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                keyStore.load(inputStream, cArray);
                inputStream.close();
                Intrinsics.checkNotNull((Object)keyStore);
                return keyStore;
            }
            catch (Exception e) {
            }
        }
        throw new IllegalArgumentException("Not a supported keystore");
    }

    @JvmOverloads
    public MRTDTrustStore(@Nullable Set<TrustAnchor> cscaAnchors, @Nullable List<CertStore> cscaStores) {
        this(cscaAnchors, cscaStores, null, 4, null);
    }

    @JvmOverloads
    public MRTDTrustStore(@Nullable Set<TrustAnchor> cscaAnchors) {
        this(cscaAnchors, null, null, 6, null);
    }

    @JvmOverloads
    public MRTDTrustStore() {
        this(null, null, null, 7, null);
    }

    static {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        JMRTD_PROVIDER = JMRTDSecurityProvider.Companion.getInstance();
        LOGGER = Logger.getLogger("org.jmrtd");
        SELF_SIGNED_X509_CERT_SELECTOR = new X509CertSelector(){

            public boolean match(@NotNull Certificate cert) {
                Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
                if (!(cert instanceof X509Certificate)) {
                    return false;
                }
                X500Principal issuer = ((X509Certificate)cert).getIssuerX500Principal();
                X500Principal subject = ((X509Certificate)cert).getSubjectX500Principal();
                return issuer == null && subject == null || Intrinsics.areEqual((Object)subject, (Object)issuer);
            }

            @NotNull
            public Object clone() {
                return this;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000*\u0001\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/kyc/nashidmrz/mrtd2/activity/passportNFC/jmrtd/MRTDTrustStore$Companion;", "", "()V", "JMRTD_PROVIDER", "Ljava/security/Provider;", "LOGGER", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "SELF_SIGNED_X509_CERT_SELECTOR", "com/kyc/nashidmrz/mrtd2/activity/passportNFC/jmrtd/MRTDTrustStore$Companion$SELF_SIGNED_X509_CERT_SELECTOR$1", "Lcom/kyc/nashidmrz/mrtd2/activity/passportNFC/jmrtd/MRTDTrustStore$Companion$SELF_SIGNED_X509_CERT_SELECTOR$1;", "getAsAnchors", "", "Ljava/security/cert/TrustAnchor;", "certificates", "", "Ljava/security/cert/Certificate;", "IDV_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<TrustAnchor> getAsAnchors(Collection<? extends Certificate> certificates) {
            HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>(certificates.size());
            for (Certificate certificate : certificates) {
                if (!(certificate instanceof X509Certificate)) continue;
                anchors.add(new TrustAnchor((X509Certificate)certificate, null));
            }
            return anchors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

