/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.pkcs.ContentInfo;
import org.spongycastle.asn1.pkcs.SignedData;
import org.spongycastle.jce.provider.X509CertificateObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/kyc/nashidmrz/mrtd2/activity/passportNFC/jmrtd/cert/CSCAMasterList;", "", "certificates", "", "Ljava/security/cert/Certificate;", "(Ljava/util/Collection;)V", "binary", "", "selector", "Ljava/security/cert/CertSelector;", "([BLjava/security/cert/CertSelector;)V", "()V", "", "getCertificates", "", "Companion", "IDV_release"})
public final class CSCAMasterList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Certificate> certificates;
    @NotNull
    private static final CertSelector IDENTITY_SELECTOR = new X509CertSelector(){

        public boolean match(@NotNull Certificate cert) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            return cert instanceof X509Certificate;
        }

        @NotNull
        public Object clone() {
            return this;
        }
    };
    @NotNull
    private static final CertSelector SELF_SIGNED_SELECTOR = new X509CertSelector(){

        public boolean match(@NotNull Certificate cert) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            if (!(cert instanceof X509Certificate)) {
                return false;
            }
            Certificate x509Cert = cert;
            X500Principal issuer = ((X509Certificate)x509Cert).getIssuerX500Principal();
            X500Principal subject = ((X509Certificate)x509Cert).getSubjectX500Principal();
            return issuer == null && subject == null || Intrinsics.areEqual((Object)subject, (Object)issuer);
        }

        @NotNull
        public Object clone() {
            return this;
        }
    };

    private CSCAMasterList() {
        this.certificates = new ArrayList(256);
    }

    public CSCAMasterList(@Nullable Collection<? extends Certificate> certificates) {
        this();
        Collection<? extends Certificate> collection = certificates;
        Intrinsics.checkNotNull(collection);
        this.certificates.addAll(collection);
    }

    @JvmOverloads
    public CSCAMasterList(@NotNull byte[] binary, @NotNull CertSelector selector) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        this();
        this.certificates.addAll(CSCAMasterList.Companion.searchCertificates(binary, selector));
    }

    public /* synthetic */ CSCAMasterList(byte[] byArray, CertSelector certSelector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            certSelector = IDENTITY_SELECTOR;
        }
        this(byArray, certSelector);
    }

    @NotNull
    public final List<Certificate> getCertificates() {
        return this.certificates;
    }

    @JvmOverloads
    public CSCAMasterList(@NotNull byte[] binary) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        this(binary, null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0002J(\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\u00012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/kyc/nashidmrz/mrtd2/activity/passportNFC/jmrtd/cert/CSCAMasterList$Companion;", "", "()V", "IDENTITY_SELECTOR", "Ljava/security/cert/CertSelector;", "SELF_SIGNED_SELECTOR", "getCertificatesFromDERObject", "", "Ljava/security/cert/Certificate;", "o", "certificates", "getSignedDataFromDERObject", "", "Lorg/spongycastle/asn1/pkcs/SignedData;", "result", "searchCertificates", "", "binary", "", "selector", "IDV_release"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Certificate> searchCertificates(byte[] binary, CertSelector selector) {
            List result2 = new ArrayList();
            try {
                List<SignedData> signedDataList;
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)binary);
                Intrinsics.checkNotNull((Object)aSN1Sequence, (String)"null cannot be cast to non-null type org.spongycastle.asn1.ASN1Sequence");
                ASN1Sequence sequence = aSN1Sequence;
                List<SignedData> list = signedDataList = this.getSignedDataFromDERObject(sequence, null);
                Intrinsics.checkNotNull(list);
                for (SignedData signedData : list) {
                    ASN1Encodable content;
                    Collection<Certificate> certificates;
                    ContentInfo contentInfo = signedData.getContentInfo();
                    Intrinsics.checkNotNullExpressionValue((Object)contentInfo.getContent(), (String)"getContent(...)");
                    Collection<Certificate> collection = certificates = this.getCertificatesFromDERObject(content, null);
                    Intrinsics.checkNotNull(collection);
                    for (Certificate certificate : collection) {
                        if (!selector.match(certificate)) continue;
                        result2.add(certificate);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result2;
        }

        private final List<SignedData> getSignedDataFromDERObject(Object o, List<SignedData> result2) {
            List<SignedData> result3 = result2;
            if (result3 == null) {
                result3 = new ArrayList();
            }
            try {
                SignedData signedData = SignedData.getInstance((Object)o);
                if (signedData != null) {
                    result3.add(signedData);
                }
                return result3;
            }
            catch (Exception signedData) {
                if (o instanceof DERTaggedObject) {
                    ASN1Primitive childObject = ((DERTaggedObject)o).getObject();
                    Intrinsics.checkNotNull((Object)childObject);
                    return this.getSignedDataFromDERObject(childObject, result3);
                }
                if (o instanceof ASN1Sequence) {
                    Enumeration derObjects = ((ASN1Sequence)o).getObjects();
                    while (derObjects.hasMoreElements()) {
                        Object nextObject = derObjects.nextElement();
                        Intrinsics.checkNotNull(nextObject);
                        result3 = this.getSignedDataFromDERObject(nextObject, result3);
                    }
                    return result3;
                }
                if (o instanceof ASN1Set) {
                    Enumeration derObjects = ((ASN1Set)o).getObjects();
                    while (derObjects.hasMoreElements()) {
                        Object nextObject = derObjects.nextElement();
                        Intrinsics.checkNotNull(nextObject);
                        result3 = this.getSignedDataFromDERObject(nextObject, result3);
                    }
                    return result3;
                }
                if (o instanceof DEROctetString) {
                    byte[] octets = ((DEROctetString)o).getOctets();
                    ASN1InputStream derInputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(octets));
                    try {
                        while (derInputStream.readObject() != null) {
                            ASN1Primitive derObject;
                            result3 = this.getSignedDataFromDERObject(derObject, result3);
                        }
                        derInputStream.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    return result3;
                }
                return result3;
            }
        }

        private final Collection<Certificate> getCertificatesFromDERObject(Object o, Collection<Certificate> certificates) {
            Collection<Certificate> certificates2 = certificates;
            if (certificates2 == null) {
                certificates2 = new ArrayList();
            }
            try {
                org.spongycastle.asn1.x509.Certificate certAsASN1Object = org.spongycastle.asn1.x509.Certificate.getInstance((Object)o);
                certificates2.add((Certificate)new X509CertificateObject(certAsASN1Object));
                return certificates2;
            }
            catch (Exception certAsASN1Object) {
                if (o instanceof DERTaggedObject) {
                    ASN1Primitive childObject = ((DERTaggedObject)o).getObject();
                    Intrinsics.checkNotNull((Object)childObject);
                    return this.getCertificatesFromDERObject(childObject, certificates2);
                }
                if (o instanceof ASN1Sequence) {
                    Enumeration derObjects = ((ASN1Sequence)o).getObjects();
                    while (derObjects.hasMoreElements()) {
                        Object nextObject = derObjects.nextElement();
                        Intrinsics.checkNotNull(nextObject);
                        certificates2 = this.getCertificatesFromDERObject(nextObject, certificates2);
                    }
                    return certificates2;
                }
                if (o instanceof ASN1Set) {
                    Enumeration derObjects = ((ASN1Set)o).getObjects();
                    while (derObjects.hasMoreElements()) {
                        Object nextObject = derObjects.nextElement();
                        Intrinsics.checkNotNull(nextObject);
                        certificates2 = this.getCertificatesFromDERObject(nextObject, certificates2);
                    }
                    return certificates2;
                }
                if (o instanceof DEROctetString) {
                    byte[] octets = ((DEROctetString)o).getOctets();
                    ASN1InputStream derInputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(octets));
                    try {
                        while (derInputStream.readObject() != null) {
                            ASN1Primitive derObject;
                            certificates2 = this.getCertificatesFromDERObject(derObject, certificates2);
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    return certificates2;
                }
                if (o instanceof SignedData) {
                    ContentInfo contentInfo = ((SignedData)o).getContentInfo();
                    ASN1Encodable aSN1Encodable = contentInfo.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)aSN1Encodable, (String)"getContent(...)");
                    ASN1Encodable content = aSN1Encodable;
                    return this.getCertificatesFromDERObject(content, certificates2);
                }
                return certificates2;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

