/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.activity.passportNFC.util;

import android.net.Uri;
import android.util.Log;
import com.kyc.nashidmrz.mrtd2.activity.passportNFC.jmrtd.JMRTDSecurityProvider;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.sf.scuba.data.Country;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongycastle.jce.provider.BouncyCastleProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\"\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\fJ\u0018\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\bJ\u001c\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u0016J8\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!2\u0006\u0010\u001c\u001a\u00020\bJ \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130!\u00a8\u0006$"}, d2={"Lcom/kyc/nashidmrz/mrtd2/activity/passportNFC/util/KeyStoreUtils;", "", "()V", "getCountry", "Lnet/sf/scuba/data/Country;", "principal", "Ljavax/security/auth/x500/X500Principal;", "readKeystoreFromFile", "Ljava/security/KeyStore;", "folder", "Ljava/io/File;", "fileName", "", "password", "toAnchors", "", "Ljava/security/cert/TrustAnchor;", "certificates", "", "Ljava/security/cert/Certificate;", "toCertDir", "", "", "Ljava/security/cert/X509Certificate;", "outputDir", "toCertStore", "Ljava/security/cert/CertStore;", "type", "keyStore", "toKeyStore", "toKeyStoreFile", "Landroid/net/Uri;", "toList", "", "toMap", "Companion", "IDV_release"})
@SourceDebugExtension(value={"SMAP\nKeyStoreUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyStoreUtils.kt\ncom/kyc/nashidmrz/mrtd2/activity/passportNFC/util/KeyStoreUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,192:1\n1#2:193\n107#3:194\n79#3,22:195\n*S KotlinDebug\n*F\n+ 1 KeyStoreUtils.kt\ncom/kyc/nashidmrz/mrtd2/activity/passportNFC/util/KeyStoreUtils\n*L\n114#1:194\n114#1:195,22\n*E\n"})
public final class KeyStoreUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final KeyStore toKeyStore(@NotNull Map<String, ? extends X509Certificate> certificates) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        void var3_3;
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        int jmrtdProvIndex = JMRTDSecurityProvider.Companion.beginPreferBouncyCastleProvider();
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"getInstance(...)");
            KeyStore keyStore2 = keyStore;
            keyStore2.load(null);
            for (Map.Entry<String, ? extends X509Certificate> entry : certificates.entrySet()) {
                String alias = entry.getKey();
                X509Certificate certificate = entry.getValue();
                System.out.println((Object)("DEBUG: adding certificate \"" + alias + "\" to key store."));
                keyStore2.setCertificateEntry(alias, certificate);
            }
        }
        finally {
            JMRTDSecurityProvider.Companion.endPreferBouncyCastleProvider(jmrtdProvIndex);
        }
        return var3_3;
    }

    @Nullable
    public final Uri toKeyStoreFile(@NotNull Map<String, ? extends X509Certificate> certificates, @NotNull File outputDir, @NotNull String fileName, @NotNull String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, IllegalStateException, IllegalArgumentException {
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        KeyStore toKeyStore = this.toKeyStore(certificates);
        if (!outputDir.exists()) {
            Log.d((String)"", (String)("DEBUG: output dir " + outputDir.getPath() + " doesn't exist, creating it."));
            if (!outputDir.mkdirs()) {
                throw new IllegalStateException("Could not create output dir \"" + outputDir.getPath() + "\"");
            }
        }
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException("Output dir is not a directory");
        }
        File outFile = new File(outputDir, fileName);
        FileOutputStream out = new FileOutputStream(outFile);
        KeyStore keyStore = toKeyStore;
        if (keyStore != null) {
            OutputStream outputStream = out;
            char[] cArray = "".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            keyStore.store(outputStream, cArray);
        }
        out.flush();
        out.close();
        return Uri.fromFile((File)outFile);
    }

    public static /* synthetic */ Uri toKeyStoreFile$default(KeyStoreUtils keyStoreUtils, Map map, File file, String string2, String string3, int n, Object object) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, IllegalStateException, IllegalArgumentException {
        if ((n & 4) != 0) {
            string2 = "csca.ks";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        return keyStoreUtils.toKeyStoreFile(map, file, string2, string3);
    }

    @Nullable
    public final KeyStore readKeystoreFromFile(@NotNull File folder, @NotNull String fileName, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            File file = new File(folder, fileName);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"getInstance(...)");
            KeyStore keyStore2 = keyStore;
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStream inputStream = fileInputStream;
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            keyStore2.load(inputStream, cArray);
            return keyStore2;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static /* synthetic */ KeyStore readKeystoreFromFile$default(KeyStoreUtils keyStoreUtils, File file, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "csca.ks";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        return keyStoreUtils.readKeystoreFromFile(file, string2, string3);
    }

    public final void toCertDir(@NotNull Map<String, ? extends X509Certificate> certificates, @NotNull String outputDir) throws CertificateEncodingException, IOException {
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        for (Map.Entry<String, ? extends X509Certificate> entry : certificates.entrySet()) {
            String alias = entry.getKey();
            X509Certificate certificate = entry.getValue();
            File outFile = new File(outputDir, alias);
            DataOutputStream dataOut = new DataOutputStream(new FileOutputStream(outFile));
            dataOut.write(certificate.getEncoded());
            dataOut.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Country getCountry(@NotNull X500Principal principal) {
        void $this$trim$iv;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        String string2 = principal.getName("RFC1779");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String issuerName = string2;
        int startIndex = StringsKt.indexOf$default((CharSequence)issuerName, (String)"C=", (int)0, (boolean)false, (int)6, null);
        if (!(startIndex >= 0)) {
            boolean $i$a$-require-KeyStoreUtils$getCountry$22 = false;
            String $i$a$-require-KeyStoreUtils$getCountry$22 = "Could not get country from issuer name, " + issuerName;
            throw new IllegalArgumentException($i$a$-require-KeyStoreUtils$getCountry$22.toString());
        }
        int endIndex = StringsKt.indexOf$default((CharSequence)issuerName, (String)",", (int)startIndex, (boolean)false, (int)4, null);
        if (endIndex < 0) {
            endIndex = issuerName.length();
        }
        String string3 = issuerName.substring(startIndex + 2, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String string4 = string3;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        string4 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string5 = string4.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
        String countryCode = string5;
        try {
            string4 = Country.getInstance((String)countryCode);
        }
        catch (Exception e) {
            string4 = new Country(countryCode){
                final /* synthetic */ String $countryCode;
                {
                    this.$countryCode = $countryCode;
                }

                public int valueOf() {
                    return -1;
                }

                @NotNull
                public String getName() {
                    return "Unknown country (" + this.$countryCode + ")";
                }

                @NotNull
                public String getNationality() {
                    return "Unknown nationality (" + this.$countryCode + ")";
                }

                @NotNull
                public String toAlpha2Code() {
                    return this.$countryCode;
                }

                @NotNull
                public String toAlpha3Code() {
                    return "X" + this.$countryCode;
                }
            };
        }
        return string4;
    }

    @NotNull
    public final Map<String, X509Certificate> toMap(@NotNull List<? extends Certificate> certificates) {
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        TreeMap<CallSite, X509Certificate> treeMap = new TreeMap<CallSite, X509Certificate>();
        int i = 0;
        for (Certificate certificate : certificates) {
            String string2;
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate x509Certificate = (X509Certificate)certificate;
            X500Principal issuer = x509Certificate.getIssuerX500Principal();
            X500Principal subject = x509Certificate.getSubjectX500Principal();
            BigInteger serial = x509Certificate.getSerialNumber();
            Intrinsics.checkNotNull((Object)issuer);
            Country country = this.getCountry(issuer);
            boolean isSelfSigned = subject.equals(issuer);
            Country country2 = country;
            Intrinsics.checkNotNull((Object)country2);
            Intrinsics.checkNotNullExpressionValue((Object)country2.toAlpha2Code(), (String)"toAlpha2Code(...)");
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String outName = string3 + "_" + (isSelfSigned ? "root_" : "link_") + ++i + ".cer";
            treeMap.put((CallSite)((Object)outName), x509Certificate);
        }
        return treeMap;
    }

    @NotNull
    public final List<Certificate> toList(@NotNull KeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        Enumeration<String> aliases = keyStore.aliases();
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        Intrinsics.checkNotNull(aliases);
        Iterator iterator = CollectionsKt.iterator(aliases);
        while (iterator.hasNext()) {
            String alias = (String)iterator.next();
            Certificate certificate = keyStore.getCertificate(alias);
            list.add(certificate);
        }
        return list;
    }

    @NotNull
    public final CertStore toCertStore(@NotNull String type, @NotNull KeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        CertStore certStore = CertStore.getInstance(type, new CollectionCertStoreParameters((Collection)this.toList(keyStore)));
        Intrinsics.checkNotNullExpressionValue((Object)certStore, (String)"getInstance(...)");
        return certStore;
    }

    public static /* synthetic */ CertStore toCertStore$default(KeyStoreUtils keyStoreUtils, String string2, KeyStore keyStore, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "Collection";
        }
        return keyStoreUtils.toCertStore(string2, keyStore);
    }

    @NotNull
    public final Set<TrustAnchor> toAnchors(@NotNull Collection<? extends Certificate> certificates) {
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>(certificates.size());
        for (Certificate certificate : certificates) {
            if (!(certificate instanceof X509Certificate)) continue;
            anchors.add(new TrustAnchor((X509Certificate)certificate, null));
        }
        return anchors;
    }

    static {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/kyc/nashidmrz/mrtd2/activity/passportNFC/util/KeyStoreUtils$Companion;", "", "()V", "IDV_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

