/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.activity.viewmodel;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.kyc.nashidmrz.OtherConstant;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.Utility;
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.DocumentImages;
import com.kyc.nashidmrz.networking.APIClient;
import com.kyc.nashidmrz.networking.APIInterface;
import com.kyc.nashidmrz.networking.models.AutoCrop;
import com.kyc.nashidmrz.utility.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u001dH\u0002J\u0012\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ,\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u000b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u001dH\u0002R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR3\u0010\u0011\u001a$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0012j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b`\u00130\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\t\u00a8\u0006#"}, d2={"Lcom/kyc/nashidmrz/mrtd2/activity/viewmodel/ScanningViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "backPageImage", "Landroidx/lifecycle/MutableLiveData;", "Landroid/graphics/Bitmap;", "getBackPageImage", "()Landroidx/lifecycle/MutableLiveData;", "countryCode", "", "getCountryCode", "frontPageImage", "getFrontPageImage", "name", "getName", "personalHashmap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getPersonalHashmap", "profileImage", "getProfileImage", "callAutoCrop", "", "context", "Landroid/app/Activity;", "bitmap", "callback", "Lkotlin/Function1;", "formatDate", "date", "initData", "loadImage", "url", "IDV_release"})
@SourceDebugExtension(value={"SMAP\nScanningViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanningViewModel.kt\ncom/kyc/nashidmrz/mrtd2/activity/viewmodel/ScanningViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class ScanningViewModel
extends AndroidViewModel {
    @NotNull
    private final MutableLiveData<HashMap<String, String>> personalHashmap;
    @NotNull
    private final MutableLiveData<String> name;
    @NotNull
    private final MutableLiveData<String> countryCode;
    @NotNull
    private final MutableLiveData<Bitmap> frontPageImage;
    @NotNull
    private final MutableLiveData<Bitmap> backPageImage;
    @NotNull
    private final MutableLiveData<Bitmap> profileImage;

    public ScanningViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.personalHashmap = new MutableLiveData();
        this.name = new MutableLiveData();
        this.countryCode = new MutableLiveData();
        this.frontPageImage = new MutableLiveData();
        this.backPageImage = new MutableLiveData();
        this.profileImage = new MutableLiveData();
        this.personalHashmap.setValue(new HashMap());
    }

    @NotNull
    public final MutableLiveData<HashMap<String, String>> getPersonalHashmap() {
        return this.personalHashmap;
    }

    @NotNull
    public final MutableLiveData<String> getName() {
        return this.name;
    }

    @NotNull
    public final MutableLiveData<String> getCountryCode() {
        return this.countryCode;
    }

    @NotNull
    public final MutableLiveData<Bitmap> getFrontPageImage() {
        return this.frontPageImage;
    }

    @NotNull
    public final MutableLiveData<Bitmap> getBackPageImage() {
        return this.backPageImage;
    }

    @NotNull
    public final MutableLiveData<Bitmap> getProfileImage() {
        return this.profileImage;
    }

    public final void initData(@NotNull Activity context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Utility utility = Utility.Companion.getInstance();
        this.name.setValue((Object)utility.getName());
        String string2 = utility.getPassportNumber();
        this.countryCode.setValue((Object)(utility.getNationality() + " | " + (string2 != null ? StringsKt.replace$default((String)string2, (String)"<", (String)"", (boolean)false, (int)4, null) : null)));
        byte[] byArray = utility.getScannedImage();
        byte[] byArray2 = utility.getScannedImage();
        Intrinsics.checkNotNull((Object)byArray2);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray2.length);
        if (bitmap == null) {
            bitmap = DataUtils.getCropImageBitmap(context, utility.getScannedImage());
        }
        this.callAutoCrop(context, bitmap, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, context, utility){
            final /* synthetic */ ScanningViewModel this$0;
            final /* synthetic */ Activity $context;
            final /* synthetic */ Utility $utility;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$utility = $utility;
                super(1);
            }

            public final void invoke(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                ScanningViewModel.access$loadImage(this.this$0, this.$context, url, (Function1)new Function1<Bitmap, Unit>(this.this$0){
                    final /* synthetic */ ScanningViewModel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Bitmap it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.this$0.getFrontPageImage().setValue((Object)it);
                    }
                });
                if (this.$utility.getSelectedDoc() != null && !StringsKt.equals((String)this.$utility.getSelectedDoc(), (String)"E-PASSPORT", (boolean)true)) {
                    byte[] byArray = this.$utility.getScannedIdFrontView();
                    byte[] byArray2 = this.$utility.getScannedIdFrontView();
                    Intrinsics.checkNotNull((Object)byArray2);
                    Bitmap backBitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray2.length);
                    if (backBitmap == null) {
                        backBitmap = DataUtils.getCropImageBitmap(this.$context, this.$utility.getScannedIdFrontView());
                    }
                    ScanningViewModel.access$callAutoCrop(this.this$0, this.$context, backBitmap, (Function1)new Function1<String, Unit>(this.this$0, this.$context){
                        final /* synthetic */ ScanningViewModel this$0;
                        final /* synthetic */ Activity $context;
                        {
                            this.this$0 = $receiver;
                            this.$context = $context;
                            super(1);
                        }

                        public final void invoke(@NotNull String backUrl) {
                            Intrinsics.checkNotNullParameter((Object)backUrl, (String)"backUrl");
                            ScanningViewModel.access$loadImage(this.this$0, this.$context, backUrl, (Function1)new Function1<Bitmap, Unit>(this.this$0){
                                final /* synthetic */ ScanningViewModel this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull Bitmap it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    this.this$0.getBackPageImage().setValue((Object)it);
                                }
                            });
                        }
                    });
                }
            }
        }));
        HashMap hashMap = (HashMap)this.personalHashmap.getValue();
        if (hashMap != null) {
            String it;
            HashMap hashMap2;
            HashMap $this$initData_u24lambda_u244 = hashMap2 = hashMap;
            boolean bl = false;
            String string3 = utility.getDocumentType();
            if (string3 != null) {
                it = string3;
                boolean bl2 = false;
                $this$initData_u24lambda_u244.put(context.getString(R.string.scan_result_doctype), it);
            }
            String string4 = context.getString(R.string.scan_result_doc_number);
            String string5 = utility.getPassportNumber();
            if (string5 == null || (string5 = StringsKt.replace$default((String)string5, (String)"<", (String)"", (boolean)false, (int)4, null)) == null) {
                string5 = "";
            }
            $this$initData_u24lambda_u244.put(string4, string5);
            String string6 = utility.getName();
            if (string6 != null) {
                it = string6;
                boolean bl3 = false;
                $this$initData_u24lambda_u244.put(context.getString(R.string.scan_result_name), it);
            }
            String string7 = utility.getNationality();
            if (string7 != null) {
                it = string7;
                boolean bl4 = false;
                $this$initData_u24lambda_u244.put(context.getString(R.string.scan_result_nationality), it);
            }
            String string8 = utility.getCountry();
            if (string8 != null) {
                it = string8;
                boolean bl5 = false;
                $this$initData_u24lambda_u244.put(context.getString(R.string.scan_result_country), it);
            }
            $this$initData_u24lambda_u244.put(context.getString(R.string.scan_result_birth_date), this.formatDate(utility.getDateOfBirth()));
            $this$initData_u24lambda_u244.put(context.getString(R.string.scan_result_expiry_date), this.formatDate(utility.getExpiryDate()));
            $this$initData_u24lambda_u244.put(context.getString(R.string.scan_result_gender), StringsKt.equals((String)utility.getGender(), (String)"f", (boolean)true) ? "Female" : "Male");
            $this$initData_u24lambda_u244.put(context.getString(R.string.scan_result_mrz), utility.getMrzLine1() + "\n" + utility.getMrzLine2() + "\n" + utility.getMrzLine3());
        }
        this.profileImage.setValue((Object)DocumentImages.Companion.getInstance().getScanPhoto());
    }

    private final String formatDate(String date) {
        String string2;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd", Locale.ENGLISH);
            Date parsedDate = sdf.parse(date);
            string2 = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH).format(parsedDate);
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (Exception e) {
            String string3 = date;
            if (string3 == null) {
                string3 = "";
            }
            string2 = string3;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callAutoCrop(Activity context, Bitmap bitmap, Function1<? super String, Unit> callback) {
        RequestBody requestBody;
        RequestBody requestBody2;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        bitmap2.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        File filename1 = new File(context.getFilesDir(), "cropped.png");
        if (filename1.exists()) {
            filename1.delete();
        }
        try {
            Closeable closeable = new FileOutputStream(filename1);
            Throwable throwable = null;
            try {
                FileOutputStream fos = (FileOutputStream)closeable;
                boolean bl = false;
                fos.write(byteArray);
                fos = Unit.INSTANCE;
            }
            catch (Throwable fos) {
                throwable = fos;
                throw fos;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RequestBody fileRequestBody = RequestBody.Companion.create(filename1, MediaType.Companion.parse("image/jpeg"));
        MultipartBody.Part filePart = MultipartBody.Part.Companion.createFormData("file", "cropped", fileRequestBody);
        MediaType mediaType = MediaType.Companion.parse("text/plain");
        if (mediaType != null) {
            MediaType it = mediaType;
            boolean bl = false;
            String string2 = APIClient.autoCropApiKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"autoCropApiKey(...)");
            requestBody2 = RequestBody.Companion.create(string2, it);
        } else {
            requestBody2 = null;
        }
        RequestBody param1 = requestBody2;
        MediaType mediaType2 = MediaType.Companion.parse("text/plain");
        if (mediaType2 != null) {
            MediaType it = mediaType2;
            boolean bl = false;
            String string3 = APIClient.autoCropApiSecretKey();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"autoCropApiSecretKey(...)");
            requestBody = RequestBody.Companion.create(string3, it);
        } else {
            requestBody = null;
        }
        RequestBody param2 = requestBody;
        ((APIInterface)APIClient.getClient("image crop", OtherConstant.Companion.getInstance().getAutoCropBaseUrl()).create(APIInterface.class)).callAutoCrop(param1, param2, filePart).enqueue((Callback)new Callback<AutoCrop>(callback){
            final /* synthetic */ Function1<String, Unit> $callback;
            {
                this.$callback = $callback;
            }

            public void onResponse(@NotNull Call<AutoCrop> call, @NotNull Response<AutoCrop> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                AutoCrop autoCrop = (AutoCrop)response.body();
                String string2 = autoCrop != null ? autoCrop.getPresigned_url() : null;
                if (string2 == null) {
                    string2 = "";
                }
                this.$callback.invoke((Object)string2);
            }

            public void onFailure(@NotNull Call<AutoCrop> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.invoke((Object)"");
            }
        });
    }

    private final void loadImage(Activity context, String url, Function1<? super Bitmap, Unit> callback) {
        Glide.with((Context)context.getApplicationContext()).asBitmap().load(url).into((Target)new CustomTarget<Bitmap>(callback){
            final /* synthetic */ Function1<Bitmap, Unit> $callback;
            {
                this.$callback = $callback;
            }

            public void onResourceReady(@NotNull Bitmap resource, @org.jetbrains.annotations.Nullable Transition<? super Bitmap> transition) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                this.$callback.invoke((Object)resource);
            }

            public void onLoadCleared(@Nullable @org.jetbrains.annotations.Nullable Drawable placeholder) {
            }
        });
    }

    public static final /* synthetic */ void access$loadImage(ScanningViewModel $this, Activity context, String url, Function1 callback) {
        $this.loadImage(context, url, (Function1<? super Bitmap, Unit>)callback);
    }

    public static final /* synthetic */ void access$callAutoCrop(ScanningViewModel $this, Activity context, Bitmap bitmap, Function1 callback) {
        $this.callAutoCrop(context, bitmap, (Function1<? super String, Unit>)callback);
    }
}

