/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.activity.viewmodel.scan;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.android.gms.tasks.Task;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.TextRecognition;
import com.google.mlkit.vision.text.TextRecognizer;
import com.google.mlkit.vision.text.TextRecognizerOptionsInterface;
import com.google.mlkit.vision.text.latin.TextRecognizerOptions;
import com.kyc.nashidmrz.NashidSDK;
import com.kyc.nashidmrz.OtherConstant;
import com.kyc.nashidmrz.R;
import com.kyc.nashidmrz.Utility;
import com.kyc.nashidmrz.facematches.FaceDetectionUtil;
import com.kyc.nashidmrz.mrtd2.CallCompanyScanAPI;
import com.kyc.nashidmrz.mrtd2.CompleteCallingCompanyScanListner;
import com.kyc.nashidmrz.mrtd2.activity.AMLAutoCrop;
import com.kyc.nashidmrz.mrtd2.activity.SelectDocumentActivity;
import com.kyc.nashidmrz.mrtd2.activity.SkipNFCLivenessActivity;
import com.kyc.nashidmrz.mrtd2.activity.WaitingForNfcActivity;
import com.kyc.nashidmrz.mrtd2.activity.viewmodel.scan.CameraXLiveData;
import com.kyc.nashidmrz.mrtd2.helpers.OmanIdCardReaderHelper;
import com.kyc.nashidmrz.mrtd2.resultcallback.FeatureCheckCallback;
import com.kyc.nashidmrz.mrtd2.resultcallback.Result;
import com.kyc.nashidmrz.mrtd2.resultcallback.ResultListener;
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.DocumentImages;
import com.kyc.nashidmrz.mrtd2.resultcallback.callbackclass.ScanDocument;
import com.kyc.nashidmrz.networking.APIClient;
import com.kyc.nashidmrz.networking.APIInterface;
import com.kyc.nashidmrz.networking.models.ValidationResponse;
import com.kyc.nashidmrz.utility.FeatureCheckApi;
import com.kyc.nashidmrz.utility.PermissionAndLocationHelper;
import com.kyc.nashidmrz.utility.SharePreferenceUtility;
import com.mv.engine.FaceDetector;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000bH\u0002J\"\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010)\u001a\u00020\u000bJ\u0010\u0010*\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010$J\b\u0010+\u001a\u00020\u001aH\u0002J\u001b\u0010,\u001a\u00020\u001a2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0.H\u0002\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u000bH\u0002J\u0016\u00102\u001a\u00020\u001a2\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0002J\u0010\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u000bH\u0002J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000bH\u0002J\u0016\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=J\u0010\u0010>\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/kyc/nashidmrz/mrtd2/activity/viewmodel/scan/CameraXLivePreviewViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "cameraProviderLiveData", "Landroidx/lifecycle/MutableLiveData;", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "cameraXLiveData", "Lcom/kyc/nashidmrz/mrtd2/activity/viewmodel/scan/CameraXLiveData;", "name", "", "passportMRZ", "processCameraProvider", "Landroidx/lifecycle/LiveData;", "getProcessCameraProvider", "()Landroidx/lifecycle/LiveData;", "scanDocument", "Lcom/kyc/nashidmrz/mrtd2/resultcallback/callbackclass/ScanDocument;", "textRecognizer", "Lcom/google/mlkit/vision/text/TextRecognizer;", "addCharactersToReachLength", "input", "desiredLength", "", "callFeatureCheck", "", "activity", "Landroid/app/Activity;", "callResultCallback", "latitude", "", "longitude", "address", "detectAndCropFace", "bitmap", "Landroid/graphics/Bitmap;", "listener", "Lcom/kyc/nashidmrz/mrtd2/activity/viewmodel/scan/CameraXLivePreviewViewModel$OnImageProcessedListener;", "handleAnimationCompleted", "openLivenessScreen", "printCurrentTimeInLogs", "processTextFromBitmap", "readAllDetailOfPassport", "readIdCardBackView", "textAll", "", "([Ljava/lang/String;)V", "readIdCardFrontView", "originalText", "readPassportData", "blocks", "", "Lcom/google/mlkit/vision/text/Text$TextBlock;", "readTextFromString", "text", "removeKValueFromString", "modifiedMRZText", "setSelectedDoc", "selectedDoc", "resources", "Landroid/content/res/Resources;", "validateLivenessUser", "OnImageProcessedListener", "IDV_release"})
@SourceDebugExtension(value={"SMAP\nCameraXLivePreviewViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraXLivePreviewViewModel.kt\ncom/kyc/nashidmrz/mrtd2/activity/viewmodel/scan/CameraXLivePreviewViewModel\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,756:1\n107#2:757\n79#2,22:758\n107#2:791\n79#2,22:792\n731#3,9:780\n37#4,2:789\n*S KotlinDebug\n*F\n+ 1 CameraXLivePreviewViewModel.kt\ncom/kyc/nashidmrz/mrtd2/activity/viewmodel/scan/CameraXLivePreviewViewModel\n*L\n162#1:757\n162#1:758,22\n246#1:791\n246#1:792,22\n178#1:780,9\n178#1:789,2\n*E\n"})
public final class CameraXLivePreviewViewModel
extends AndroidViewModel {
    @NotNull
    private final TextRecognizer textRecognizer;
    @NotNull
    private final ScanDocument scanDocument;
    @JvmField
    @NotNull
    public final CameraXLiveData cameraXLiveData;
    @NotNull
    private String passportMRZ;
    @NotNull
    private String name;
    @Nullable
    private MutableLiveData<ProcessCameraProvider> cameraProviderLiveData;

    public CameraXLivePreviewViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        TextRecognizer textRecognizer = TextRecognition.getClient((TextRecognizerOptionsInterface)((TextRecognizerOptionsInterface)TextRecognizerOptions.DEFAULT_OPTIONS));
        Intrinsics.checkNotNullExpressionValue((Object)textRecognizer, (String)"getClient(...)");
        this.textRecognizer = textRecognizer;
        ScanDocument scanDocument = ScanDocument.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)scanDocument, (String)"getInstance(...)");
        this.scanDocument = scanDocument;
        this.cameraXLiveData = new CameraXLiveData();
        this.passportMRZ = "";
        this.name = "";
    }

    public final void setSelectedDoc(@NotNull String selectedDoc, @NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)selectedDoc, (String)"selectedDoc");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.cameraXLiveData.setSelectedDoc(selectedDoc);
        if (StringsKt.equals((String)selectedDoc, (String)resources.getString(R.string.e_passport), (boolean)true)) {
            String string2 = resources.getString(R.string.scan_passport_top_text);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            this.cameraXLiveData.setStatusText(string2);
            String string3 = resources.getString(R.string.scan_passport_bottom);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            this.cameraXLiveData.setBottomText(string3);
        } else {
            String string4 = resources.getString(R.string.scan_id_top_text);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            this.cameraXLiveData.setStatusText(string4);
            String string5 = resources.getString(R.string.scan_id_bottom);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
            this.cameraXLiveData.setBottomText(string5);
        }
    }

    public final void processTextFromBitmap(@Nullable Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNull((Object)bitmap2);
        this.textRecognizer.process(InputImage.fromBitmap((Bitmap)bitmap2, (int)0)).addOnSuccessListener(arg_0 -> CameraXLivePreviewViewModel.processTextFromBitmap$lambda$0((Function1)new Function1<Text, Unit>(this){
            final /* synthetic */ CameraXLivePreviewViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Text text1) {
                Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
                List list = text1.getTextBlocks();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTextBlocks(...)");
                List blocks = list;
                CameraXLivePreviewViewModel.access$readPassportData(this.this$0, blocks);
                String string2 = text1.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                String text = string2;
                CameraXLivePreviewViewModel.access$readTextFromString(this.this$0, text);
            }
        }, arg_0)).addOnFailureListener(arg_0 -> CameraXLivePreviewViewModel.processTextFromBitmap$lambda$1(this, arg_0)).addOnCompleteListener(arg_0 -> CameraXLivePreviewViewModel.processTextFromBitmap$lambda$2(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void readPassportData(List<? extends Text.TextBlock> blocks) {
        if (StringsKt.equals((String)((String)Objects.requireNonNull(this.cameraXLiveData.getSelectedDoc().getValue())), (String)this.getApplication().getString(R.string.e_passport), (boolean)true)) {
            int n = blocks.size();
            for (int i = 0; i < n; ++i) {
                List lines;
                Intrinsics.checkNotNullExpressionValue((Object)blocks.get(i).getLines(), (String)"getLines(...)");
                int n2 = lines.size();
                for (int j = 0; j < n2; ++j) {
                    List elements;
                    Intrinsics.checkNotNullExpressionValue((Object)((Text.Line)lines.get(j)).getElements(), (String)"getElements(...)");
                    int n3 = elements.size();
                    for (int k = 0; k < n3; ++k) {
                        if (((Text.Element)elements.get(k)).getText().length() <= 30) continue;
                        try {
                            void $this$trim$iv;
                            String countrySubstring;
                            String string2;
                            Intrinsics.checkNotNullExpressionValue((Object)((Text.Element)elements.get(k)).getText(), (String)"getText(...)");
                            int n4 = 10;
                            int n5 = 13;
                            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n4, n5), (String)"substring(...)");
                            String newCountryCode = StringsKt.replace$default((String)countrySubstring, (String)"0", (String)"O", (boolean)false, (int)4, null);
                            String string3 = ((Text.Element)elements.get(k)).getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                            String modifiedMRZText = StringsKt.replace$default((String)string3, (String)countrySubstring, (String)newCountryCode, (boolean)false, (int)4, null);
                            modifiedMRZText = StringsKt.replace$default((String)modifiedMRZText, (String)"\u00ab", (String)"<", (boolean)false, (int)4, null);
                            Pattern patternPassportTD3Line2 = Pattern.compile("([A-Z0-9<]{9})([0-9]{1})([A-Z]{3})([0-9]{6})([0-9]{1})([M|F|X|<]{1})([0-9]{6})([0-9]{1})");
                            Pattern patternPassportTD3Line1 = Pattern.compile("(P[A-Z0-9<]{1})([A-Z]{3})([A-Z0-9<]{39})");
                            Matcher matcherPassportTD3Line2 = patternPassportTD3Line2.matcher(modifiedMRZText);
                            Matcher matcherPassportTD3Line1 = patternPassportTD3Line1.matcher(modifiedMRZText);
                            if (matcherPassportTD3Line2.find() && ((CharSequence)this.passportMRZ).length() == 0) {
                                Intrinsics.checkNotNullExpressionValue((Object)((Text.Element)elements.get(k)).getText(), (String)"getText(...)");
                                this.passportMRZ = this.passportMRZ;
                                Utility.Companion.getInstance().setMrzLine2(StringsKt.replace$default((String)this.passportMRZ, (String)"\u00ab", (String)"<", (boolean)false, (int)4, null));
                            }
                            if (!matcherPassportTD3Line1.matches() || !(((CharSequence)this.name).length() == 0)) continue;
                            String latest = this.removeKValueFromString(modifiedMRZText);
                            Utility.Companion.getInstance().setMrzLine1(latest);
                            String string4 = latest.substring(5, latest.length() - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                            String string5 = this.name = StringsKt.replace$default((String)string4, (String)"<", (String)" ", (boolean)false, (int)4, null);
                            Utility utility = Utility.Companion.getInstance();
                            boolean $i$f$trim = false;
                            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                            boolean $i$f$trim2 = false;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            utility.setName(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                            Utility utility2 = Utility.Companion.getInstance();
                            String string6 = latest.substring(2, 5);
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                            utility2.setCountry(string6);
                            Utility utility3 = Utility.Companion.getInstance();
                            String string7 = latest.substring(0, 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                            utility3.setDocumentType(string7);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private final void readTextFromString(String text) {
        try {
            List list;
            CharSequence charSequence = text;
            Regex regex = new Regex("\n");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] textAll = thisCollection$iv.toArray(new String[0]);
            if (StringsKt.equals((String)((String)Objects.requireNonNull(this.cameraXLiveData.getSelectedDoc().getValue())), (String)this.getApplication().getString(R.string.e_passport), (boolean)true)) {
                this.readAllDetailOfPassport();
            } else if (Intrinsics.areEqual((Object)this.cameraXLiveData.getIsFrontView().getValue(), (Object)false)) {
                this.readIdCardFrontView(text);
            } else {
                this.readIdCardBackView(textAll);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cameraXLiveData.setIsSuccess(false);
        }
    }

    private final void readIdCardFrontView(String originalText) {
        String text = originalText;
        String string2 = StringsKt.replace$default((String)text, (String)" ", (String)"", (boolean)false, (int)4, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        text = string3;
        string2 = StringsKt.replace$default((String)text, (String)"\n", (String)" ", (boolean)false, (int)4, null);
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
        String string4 = string2.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        text = string4;
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)"SULTANATEOFOMAN", (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)text, (CharSequence)"IDENTITY CARD", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)"RESIDENT CARD", (boolean)false, (int)2, null))) {
            this.cameraXLiveData.setIdNo(null);
            this.cameraXLiveData.setDOB(null);
            this.cameraXLiveData.setExpiryDate(null);
            this.cameraXLiveData.setIsFrontView(true);
            this.cameraXLiveData.setIdLine1(true);
            this.cameraXLiveData.setIdLine2(true);
            this.cameraXLiveData.setCaptureAnImage(true);
            this.cameraXLiveData.setIsSuccess(true);
        } else {
            this.cameraXLiveData.setIsSuccess(false);
        }
        this.cameraXLiveData.setCTimer(false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void readIdCardBackView(String[] textAll) {
        String gender = "";
        Pattern pattern1 = Pattern.compile("([A|C|I][A-Z0-9<K]{1})([A-Z]{3})([A-Z0-9<]{9})([0-9]{1})");
        Pattern pattern2 = Pattern.compile("([0-9]{6})([0-9]{1})([MFX]{1})([0-9]{6})([0-9]{1})([A-Z]{3})([A-Z0-9<]{11})([A-Z0-9<]{1})");
        Pattern pattern3 = Pattern.compile("([A-Z]+)<([A-Z<]+)");
        if (Intrinsics.areEqual((Object)this.cameraXLiveData.getAlgoHeaderDetect().getValue(), (Object)false)) {
            String string2 = String.join((CharSequence)" ", Arrays.copyOf(textAll, textAll.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
            if (OmanIdCardReaderHelper.Companion.isSimilarEnough(string2)) {
                this.cameraXLiveData.setAlgoHeaderDetect(true);
            }
        }
        if (Intrinsics.areEqual((Object)this.cameraXLiveData.getAlgoHeaderDetect().getValue(), (Object)true) && (Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine1().getValue(), (Object)true) || Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine2().getValue(), (Object)true) || Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine3().getValue(), (Object)true))) {
            for (String data : textAll) {
                Matcher matcher1;
                char lastChar;
                Object replacedString;
                StringBuilder updatedString = new StringBuilder(StringsKt.replace$default((String)data, (String)" ", (String)"", (boolean)false, (int)4, null));
                String string3 = updatedString.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                String removeKString = this.removeKValueFromString(string3);
                updatedString = new StringBuilder(StringsKt.replace$default((String)removeKString, (String)"\u00ab", (String)"<", (boolean)false, (int)4, null));
                Matcher matcher3 = pattern3.matcher(updatedString.toString());
                StringBuilder name = new StringBuilder(StringsKt.replace$default((String)StringsKt.replace$default((String)data, (String)"NAME ", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"<", (boolean)false, (int)4, null));
                if (matcher3.matches() && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine3().getValue(), (Object)true)) {
                    void $this$trim$iv;
                    Utility utility = Utility.Companion.getInstance();
                    String string4 = updatedString.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                    String string5 = StringsKt.replace$default((String)StringsKt.replace$default((String)string4, (String)"<", (String)" ", (boolean)false, (int)4, null), (String)"\u00ab", (String)" ", (boolean)false, (int)4, null);
                    Utility utility2 = utility;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    utility2.setName(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                    int length = 30 - name.length();
                    for (int i = 0; i < length; ++i) {
                        name.append("<");
                    }
                    String string6 = name.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                    String updatedName = this.removeKValueFromString(string6);
                    Utility.Companion.getInstance().setMrzLine3(StringsKt.replace$default((String)updatedName, (String)"\u00ab", (String)"<", (boolean)false, (int)4, null));
                    this.cameraXLiveData.setIdLine3(false);
                }
                int index = updatedString.indexOf("MN");
                Intrinsics.checkNotNullExpressionValue((Object)updatedString.toString(), (String)"toString(...)");
                if (index > 1 && updatedString.charAt(index - 1) == '0') {
                    String secondPart;
                    String firstPart = updatedString.substring(0, index - 1);
                    String startIndex$iv$iv = secondPart = updatedString.substring(index - 1);
                    Intrinsics.checkNotNull((Object)startIndex$iv$iv);
                    if (StringsKt.startsWith$default((String)startIndex$iv$iv, (String)"0", (boolean)false, (int)2, null)) {
                        startIndex$iv$iv = secondPart;
                        Intrinsics.checkNotNull((Object)startIndex$iv$iv);
                        secondPart = StringsKt.replace$default((String)startIndex$iv$iv, (String)"0", (String)"O", (boolean)false, (int)4, null);
                    }
                    replacedString = firstPart + secondPart;
                }
                if (Character.isLetter(lastChar = ((String)replacedString).charAt(((String)replacedString).length() - 1)) && (lastChar == 'O' || lastChar == 'o')) {
                    String string7 = ((String)replacedString).substring(0, ((String)replacedString).length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                    replacedString = string7 + "0";
                }
                if (((String)replacedString).length() >= 25) {
                    replacedString = this.addCharactersToReachLength((String)replacedString, 30);
                }
                Matcher matcher2 = pattern2.matcher(OmanIdCardReaderHelper.Companion.cleanString((String)replacedString));
                String matcherString = updatedString.toString();
                if (updatedString.length() > 15) {
                    matcherString = updatedString.substring(0, 15);
                }
                if ((matcher1 = pattern1.matcher(String.valueOf(matcherString))).matches() && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine1().getValue(), (Object)true)) {
                    int length = 30 - updatedString.length();
                    for (int i = 0; i < length; ++i) {
                        updatedString.append("<");
                    }
                    Utility.Companion.getInstance().setMrzLine1(updatedString.toString());
                    String string8 = Objects.requireNonNull(matcher1.group(3));
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"requireNonNull(...)");
                    this.cameraXLiveData.setIdNo(OmanIdCardReaderHelper.Companion.replaceAlfaWithNumber(string8));
                    String string9 = Objects.requireNonNull(matcher1.group(2));
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"requireNonNull(...)");
                    String country = OmanIdCardReaderHelper.Companion.replaceNumberWithAlfa(string9);
                    Utility.Companion.getInstance().setCountry(country);
                    Utility.Companion.getInstance().setDocumentType(matcher1.group(1));
                    this.cameraXLiveData.setIdLine1(false);
                }
                if (((String)replacedString).length() == 30 && matcher2.matches() && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine2().getValue(), (Object)true)) {
                    updatedString = new StringBuilder(OmanIdCardReaderHelper.Companion.cleanString((String)replacedString));
                    Utility.Companion.getInstance().setMrzLine2(updatedString.toString());
                    this.cameraXLiveData.setDOB(matcher2.group(1));
                    this.cameraXLiveData.setExpiryDate(matcher2.group(4));
                    String string10 = matcher2.group(3);
                    if (string10 == null || (string10 = string10.toString()) == null) {
                        string10 = "";
                    }
                    gender = string10;
                    String nationality = matcher2.group(6);
                    Utility.Companion.getInstance().setNationality(nationality);
                    this.cameraXLiveData.setIdLine2(false);
                }
                if (Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine1().getValue(), (Object)false) && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine2().getValue(), (Object)false) && Intrinsics.areEqual((Object)this.cameraXLiveData.getIdLine3().getValue(), (Object)false)) break;
            }
        }
        if (Utility.Companion.getInstance().getMrzLine1() != null && Utility.Companion.getInstance().getMrzLine2() != null && Utility.Companion.getInstance().getMrzLine3() != null) {
            if (Intrinsics.areEqual((Object)this.cameraXLiveData.getIsFrontViewScanned().getValue(), (Object)false)) {
                this.cameraXLiveData.setIdNo(null);
                this.cameraXLiveData.setDOB(null);
                this.cameraXLiveData.setExpiryDate(null);
                this.cameraXLiveData.setIdLine1(true);
                this.cameraXLiveData.setIdLine2(true);
                this.cameraXLiveData.setIdLine3(true);
                this.cameraXLiveData.setIsSuccess(false);
                return;
            }
            if (this.cameraXLiveData.getExpiryDate().getValue() != null) {
                Object object = this.cameraXLiveData.getExpiryDate().getValue();
                Intrinsics.checkNotNull((Object)object);
                if (((CharSequence)object).length() > 0) {
                    if (Intrinsics.areEqual((Object)this.cameraXLiveData.getIsFrontViewScanned().getValue(), (Object)true)) {
                        Object object2 = Objects.requireNonNull(this.cameraXLiveData.getIdNo().getValue());
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"requireNonNull(...)");
                        if (((CharSequence)object2).length() > 0) {
                            Object object3 = Objects.requireNonNull(this.cameraXLiveData.getDOB().getValue());
                            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"requireNonNull(...)");
                            if (((CharSequence)object3).length() > 0) {
                                String documentNumber = (String)this.cameraXLiveData.getIdNo().getValue();
                                String dateOfBirthDay = (String)this.cameraXLiveData.getDOB().getValue();
                                String expiryDate = (String)this.cameraXLiveData.getExpiryDate().getValue();
                                try {
                                    String string11 = expiryDate;
                                    Intrinsics.checkNotNull((Object)string11);
                                    if (((CharSequence)string11).length() > 0) {
                                        this.scanDocument.setDocuemntNo(documentNumber);
                                        this.scanDocument.setDateOfBirth(dateOfBirthDay);
                                        this.scanDocument.setExpiryDate(expiryDate);
                                        Utility.Companion.getInstance().setPassportNumber(documentNumber);
                                        Utility.Companion.getInstance().setDateOfBirth(dateOfBirthDay);
                                        Utility.Companion.getInstance().setExpiryDate(expiryDate);
                                        Utility.Companion.getInstance().setGender(gender);
                                        this.cameraXLiveData.setFlag(false);
                                        this.cameraXLiveData.setCloseAnalysisUseCase(true);
                                        this.cameraXLiveData.setIsSuccess(true);
                                        this.cameraXLiveData.setCTimer(true);
                                        this.cameraXLiveData.setCaptureAnImage(true);
                                        return;
                                    }
                                    this.cameraXLiveData.setIsSuccess(false);
                                    return;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.cameraXLiveData.setIsSuccess(false);
                                }
                                return;
                            }
                        }
                    }
                    this.cameraXLiveData.setIsSuccess(false);
                    return;
                }
            }
            this.cameraXLiveData.setIsSuccess(false);
            return;
        }
        this.cameraXLiveData.setIsSuccess(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void readAllDetailOfPassport() {
        if (((CharSequence)this.passportMRZ).length() > 0 && ((CharSequence)this.name).length() > 0) {
            String line = this.passportMRZ;
            String string2 = line.substring(0, 9);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String documentNumber = string2;
            String string3 = line.substring(10, 13);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String nationality = string3;
            String string4 = line.substring(13, 19);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String dateOfBirthDay = string4;
            String string5 = line.substring(20, 21);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String gender = string5;
            String string6 = line.substring(21, 27);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            this.cameraXLiveData.setExpiryDate(string6);
            nationality = OmanIdCardReaderHelper.Companion.replaceNumberWithAlfa(nationality);
            dateOfBirthDay = OmanIdCardReaderHelper.Companion.replaceAlfaWithNumber(dateOfBirthDay);
            gender = OmanIdCardReaderHelper.Companion.replaceNumberWithAlfa(gender);
            this.cameraXLiveData.setExpiryDate(OmanIdCardReaderHelper.Companion.replaceAlfaWithNumber(String.valueOf(this.cameraXLiveData.getExpiryDate().getValue())));
            documentNumber = StringsKt.replace$default((String)documentNumber, (String)"O", (String)"0", (boolean)false, (int)4, null);
            if (((CharSequence)documentNumber).length() > 0 && ((CharSequence)dateOfBirthDay).length() > 0) {
                Object object = this.cameraXLiveData.getExpiryDate().getValue();
                Intrinsics.checkNotNull((Object)object);
                if (((CharSequence)object).length() > 0 && ((CharSequence)nationality).length() > 0 && ((CharSequence)gender).length() > 0) {
                    this.scanDocument.setDocuemntNo(documentNumber);
                    this.scanDocument.setDateOfBirth(dateOfBirthDay);
                    this.scanDocument.setExpiryDate((String)this.cameraXLiveData.getExpiryDate().getValue());
                    Utility.Companion.getInstance().setPassportNumber(documentNumber);
                    Utility.Companion.getInstance().setDateOfBirth(dateOfBirthDay);
                    Utility.Companion.getInstance().setExpiryDate((String)this.cameraXLiveData.getExpiryDate().getValue());
                    Utility.Companion.getInstance().setNationality(nationality);
                    Utility.Companion.getInstance().setGender(gender);
                    this.cameraXLiveData.setFlag(false);
                    this.cameraXLiveData.setCloseAnalysisUseCase(true);
                    this.cameraXLiveData.setIsSuccess(true);
                    this.cameraXLiveData.setCaptureAnImage(true);
                    return;
                }
            }
            this.cameraXLiveData.setIsSuccess(false);
            return;
        }
        this.cameraXLiveData.setIsSuccess(false);
    }

    private final String removeKValueFromString(String modifiedMRZText) {
        StringBuilder latest = new StringBuilder();
        int n = modifiedMRZText.length();
        for (int l = 0; l < n; ++l) {
            if (l != 0) {
                if (modifiedMRZText.charAt(l) == 'K') {
                    if (l == modifiedMRZText.length() - 1) {
                        if (modifiedMRZText.charAt(l) == 'K') continue;
                        latest.append(modifiedMRZText.charAt(l));
                        continue;
                    }
                    if (modifiedMRZText.charAt(l - 1) != '<' && modifiedMRZText.charAt(l + 1) != '<') {
                        latest.append(modifiedMRZText.charAt(l));
                        continue;
                    }
                    if (modifiedMRZText.charAt(l - 1) == '<' && modifiedMRZText.charAt(l + 1) == '<') continue;
                    latest.append(modifiedMRZText.charAt(l));
                    continue;
                }
                latest.append(modifiedMRZText.charAt(l));
                continue;
            }
            latest.append(modifiedMRZText.charAt(l));
        }
        String string2 = latest.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("\\bK+\\b");
        String string3 = "";
        return regex.replace(charSequence, string3);
    }

    private final String addCharactersToReachLength(String input, int desiredLength) {
        if (input.length() >= desiredLength) {
            return input;
        }
        char lastChar = input.charAt(input.length() - 1);
        if (Character.isDigit(lastChar)) {
            int additionalChars = desiredLength - input.length();
            StringBuilder sb = new StringBuilder(input);
            for (int i = 0; i < additionalChars; ++i) {
                sb.insert(sb.length() - 1, '<');
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        return input;
    }

    @NotNull
    public final String printCurrentTimeInLogs() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        String currentTime = sdf.format(new Date());
        Log.d((String)CameraXLivePreviewViewModel.class.getName(), (String)("Current Time: " + currentTime));
        Intrinsics.checkNotNull((Object)currentTime);
        return currentTime;
    }

    public final void handleAnimationCompleted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.cameraXLiveData.setCTimer(true);
        Utility.Companion.getInstance().setSelectedDoc((String)this.cameraXLiveData.getSelectedDoc().getValue());
        byte[] byArray = Utility.Companion.getInstance().getScannedImage();
        Bitmap fullBitmap = BitmapFactory.decodeByteArray((byte[])Utility.Companion.getInstance().getScannedImage(), (int)0, (int)(byArray != null ? byArray.length : 0));
        if (fullBitmap != null) {
            this.detectAndCropFace(activity, fullBitmap, new OnImageProcessedListener(activity, this){
                final /* synthetic */ Activity $activity;
                final /* synthetic */ CameraXLivePreviewViewModel this$0;
                {
                    this.$activity = $activity;
                    this.this$0 = $receiver;
                }

                public void onImageProcessed(@Nullable Bitmap croppedBitmap) {
                    DocumentImages.Companion.getInstance().setScanPhoto(croppedBitmap);
                    if (StringsKt.equals((String)OtherConstant.Companion.getInstance().getAppName(), (String)this.$activity.getString(R.string.overify), (boolean)true)) {
                        CameraXLivePreviewViewModel.access$callFeatureCheck(this.this$0, this.$activity);
                    } else if (SharePreferenceUtility.getSavePreferenceData((Context)this.$activity, this.$activity.getString(R.string.sharepreference_nfc))) {
                        Intent intent = new Intent((Context)this.$activity, WaitingForNfcActivity.class);
                        intent.putExtra(this.$activity.getResources().getString(R.string.doc_key), (String)this.this$0.cameraXLiveData.getSelectedDoc().getValue());
                        this.$activity.startActivity(intent);
                        this.$activity.finish();
                    } else {
                        CameraXLivePreviewViewModel.access$openLivenessScreen(this.this$0, this.$activity);
                    }
                }
            });
        }
    }

    private final void callFeatureCheck(Activity activity) {
        this.cameraXLiveData.setUpdateCustomLoader(true);
        FeatureCheckApi featureCheckApi = new FeatureCheckApi();
        featureCheckApi.callFeatureCheck(new FeatureCheckCallback(activity, this){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ CameraXLivePreviewViewModel this$0;
            {
                this.$activity = $activity;
                this.this$0 = $receiver;
            }

            public void onFeatureCheckSuccess(@NotNull ArrayList<String> features) {
                Intrinsics.checkNotNullParameter(features, (String)"features");
                if (features.contains("NFC")) {
                    SharePreferenceUtility.savePreferenceValue((Context)this.$activity, this.$activity.getString(R.string.sharepreference_nfc), true);
                    Intent intent = new Intent((Context)this.$activity, WaitingForNfcActivity.class);
                    intent.putExtra(this.$activity.getResources().getString(R.string.doc_key), (String)this.this$0.cameraXLiveData.getSelectedDoc().getValue());
                    this.$activity.startActivity(intent);
                    this.$activity.finish();
                } else if (features.contains("Liveness") || features.contains("Face-Match")) {
                    SharePreferenceUtility.savePreferenceValue(this.$activity.getApplicationContext(), this.$activity.getString(R.string.sharepreference_nfc), false);
                    SharePreferenceUtility.savePreferenceValue(this.$activity.getApplicationContext(), this.$activity.getString(R.string.sharepreference_facila_matching), true);
                    CameraXLivePreviewViewModel.access$openLivenessScreen(this.this$0, this.$activity);
                } else {
                    Activity activity = this.$activity;
                    Intrinsics.checkNotNull((Object)activity, (String)"null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
                    PermissionAndLocationHelper.INSTANCE.requestPermissionAndLocation((FragmentActivity)activity, new PermissionAndLocationHelper.ResultCallback(this.this$0, this.$activity){
                        final /* synthetic */ CameraXLivePreviewViewModel this$0;
                        final /* synthetic */ Activity $activity;
                        {
                            this.this$0 = $receiver;
                            this.$activity = $activity;
                        }

                        public void onResult(double latitude, double longitude, @NotNull String address) {
                            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
                            CameraXLivePreviewViewModel.access$callResultCallback(this.this$0, this.$activity, latitude, longitude, address);
                        }
                    });
                }
            }

            public void onFeatureCheckFailure(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                this.$activity.finish();
            }
        });
    }

    private final void detectAndCropFace(Activity activity, Bitmap bitmap, OnImageProcessedListener listener) {
        Bitmap detectedIdFace;
        Bitmap failureBitmap = BitmapFactory.decodeResource((Resources)activity.getResources(), (int)R.drawable.face_not_found);
        FaceDetector faceDetector = new FaceDetector();
        AssetManager assetManager = activity.getAssets();
        Intrinsics.checkNotNull((Object)assetManager);
        int loadResult = faceDetector.loadModel(assetManager);
        if (loadResult != 0) {
            Log.e((String)"FaceDetector", (String)"Failed to load model");
        }
        if ((detectedIdFace = FaceDetectionUtil.Companion.cropFaceFromIDCard(bitmap)) != null) {
            OnImageProcessedListener onImageProcessedListener = listener;
            if (onImageProcessedListener != null) {
                onImageProcessedListener.onImageProcessed(detectedIdFace);
            }
        } else {
            OnImageProcessedListener onImageProcessedListener = listener;
            if (onImageProcessedListener != null) {
                onImageProcessedListener.onImageProcessed(failureBitmap);
            }
            Log.d((String)"FaceDetector", (String)"No faces detected");
        }
    }

    private final void callResultCallback(Activity activity, double latitude, double longitude, String address) {
        AMLAutoCrop.setListner(() -> CameraXLivePreviewViewModel.callResultCallback$lambda$6(activity, latitude, longitude, address, this));
        AMLAutoCrop.callAML(Utility.Companion.getInstance().getName(), Utility.Companion.getInstance().getDateOfBirth(), Utility.Companion.getInstance().getNationality(), Utility.Companion.getInstance().getPassportNumber(), Utility.Companion.getInstance().getCountry());
        AMLAutoCrop.callAutoCropAPI(activity);
    }

    private final void openLivenessScreen(Activity activity) {
        this.cameraXLiveData.setUnbindCameraProvider(true);
        Utility.Companion.getInstance().setSelectedDoc((String)this.cameraXLiveData.getSelectedDoc().getValue());
        this.validateLivenessUser(activity);
    }

    private final void validateLivenessUser(Activity activity) {
        ((APIInterface)APIClient.getClient("validationKey", OtherConstant.Companion.getInstance().getMainBaseUrl()).create(APIInterface.class)).validateKey(activity.getResources().getString(R.string.liveness_action)).enqueue((Callback)new Callback<ValidationResponse>(activity, this){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ CameraXLivePreviewViewModel this$0;
            {
                this.$activity = $activity;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call<ValidationResponse> call, @NotNull Response<ValidationResponse> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.code() != 200) {
                    Intent i = new Intent((Context)this.$activity, SelectDocumentActivity.class);
                    i.setFlags(0x10008000);
                    this.$activity.startActivity(i);
                } else {
                    Intent intent = new Intent((Context)this.$activity, SkipNFCLivenessActivity.class);
                    intent.putExtra(this.$activity.getResources().getString(R.string.doc_key), (String)this.this$0.cameraXLiveData.getSelectedDoc().getValue());
                    this.$activity.startActivity(intent);
                    this.$activity.finish();
                }
            }

            public void onFailure(@NotNull Call<ValidationResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            }
        });
    }

    @NotNull
    public final LiveData<ProcessCameraProvider> getProcessCameraProvider() {
        if (this.cameraProviderLiveData == null) {
            this.cameraProviderLiveData = new MutableLiveData();
            ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)((Context)this.getApplication()));
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getInstance(...)");
            ListenableFuture cameraProviderFuture = listenableFuture;
            cameraProviderFuture.addListener(() -> CameraXLivePreviewViewModel._get_processCameraProvider_$lambda$7(this, cameraProviderFuture), ContextCompat.getMainExecutor((Context)((Context)this.getApplication())));
        }
        MutableLiveData<ProcessCameraProvider> mutableLiveData = this.cameraProviderLiveData;
        Intrinsics.checkNotNull(mutableLiveData);
        return (LiveData)mutableLiveData;
    }

    private static final void processTextFromBitmap$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processTextFromBitmap$lambda$1(CameraXLivePreviewViewModel this$0, Exception it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cameraXLiveData.setIsSuccess(false);
    }

    private static final void processTextFromBitmap$lambda$2(CameraXLivePreviewViewModel this$0, Task it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            if (Intrinsics.areEqual((Object)this$0.cameraXLiveData.getIsSuccess().getValue(), (Object)false)) {
                this$0.cameraXLiveData.setCloseImageProxy(true);
            }
        }
        catch (Exception e) {
            this$0.cameraXLiveData.setCloseImageProxy(true);
        }
    }

    private static final void callResultCallback$lambda$6(Activity $activity, double $latitude, double $longitude, String $address, CameraXLivePreviewViewModel this$0) {
        Intrinsics.checkNotNullParameter((Object)$activity, (String)"$activity");
        Intrinsics.checkNotNullParameter((Object)$address, (String)"$address");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        SharePreferenceUtility.savePreferenceValue($activity.getApplicationContext(), $activity.getString(R.string.sharepreference_nfc), false);
        SharePreferenceUtility.savePreferenceValue($activity.getApplicationContext(), $activity.getString(R.string.sharepreference_facila_matching), false);
        JSONObject jsonObject = Result.setResultData($activity, false, false, true);
        JSONObject location = new JSONObject();
        try {
            location.put($activity.getString(R.string.location_lat), $latitude);
            location.put($activity.getString(R.string.location_longi), $longitude);
            location.put($activity.getString(R.string.location_name), (Object)$address);
            JSONObject jSONObject = jsonObject;
            if (jSONObject != null) {
                jSONObject.put($activity.getString(R.string.locationjson_title), (Object)location);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d((String)CameraXLivePreviewViewModel.class.getName(), (String)("callAMLCrop:camerax " + jsonObject));
        if (jsonObject != null) {
            CallCompanyScanAPI callCompanyScanAPI = new CallCompanyScanAPI();
            Object object = Objects.requireNonNull(this$0.cameraXLiveData.getSelectedDoc().getValue());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"requireNonNull(...)");
            callCompanyScanAPI.uploadAllImages($activity, jsonObject, (String)object, 1, new CompleteCallingCompanyScanListner($activity, jsonObject, this$0){
                final /* synthetic */ Activity $activity;
                final /* synthetic */ JSONObject $jsonObject;
                final /* synthetic */ CameraXLivePreviewViewModel this$0;
                {
                    this.$activity = $activity;
                    this.$jsonObject = $jsonObject;
                    this.this$0 = $receiver;
                }

                public void onFailure() {
                    if (NashidSDK.Companion.getInstance().getResultListener() != null) {
                        ResultListener resultListener = NashidSDK.Companion.getInstance().getResultListener();
                        Intrinsics.checkNotNull((Object)resultListener);
                        resultListener.onFailure();
                    }
                    this.$activity.finish();
                }

                public void onSuccess() {
                    if (NashidSDK.Companion.getInstance().getResultListener() != null) {
                        ResultListener resultListener = NashidSDK.Companion.getInstance().getResultListener();
                        Intrinsics.checkNotNull((Object)resultListener);
                        resultListener.onResultData(this.$jsonObject, (String)this.this$0.cameraXLiveData.getSelectedDoc().getValue());
                    }
                    this.$activity.finish();
                }
            });
        } else {
            if (NashidSDK.Companion.getInstance().getResultListener() != null) {
                ResultListener resultListener = NashidSDK.Companion.getInstance().getResultListener();
                Intrinsics.checkNotNull((Object)resultListener);
                resultListener.onFailure();
            }
            $activity.finish();
        }
    }

    private static final void _get_processCameraProvider_$lambda$7(CameraXLivePreviewViewModel this$0, ListenableFuture $cameraProviderFuture) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cameraProviderFuture, (String)"$cameraProviderFuture");
        try {
            MutableLiveData<ProcessCameraProvider> mutableLiveData = this$0.cameraProviderLiveData;
            Intrinsics.checkNotNull(mutableLiveData);
            mutableLiveData.setValue($cameraProviderFuture.get());
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ void access$readPassportData(CameraXLivePreviewViewModel $this, List blocks) {
        $this.readPassportData(blocks);
    }

    public static final /* synthetic */ void access$readTextFromString(CameraXLivePreviewViewModel $this, String text) {
        $this.readTextFromString(text);
    }

    public static final /* synthetic */ void access$callFeatureCheck(CameraXLivePreviewViewModel $this, Activity activity) {
        $this.callFeatureCheck(activity);
    }

    public static final /* synthetic */ void access$openLivenessScreen(CameraXLivePreviewViewModel $this, Activity activity) {
        $this.openLivenessScreen(activity);
    }

    public static final /* synthetic */ void access$callResultCallback(CameraXLivePreviewViewModel $this, Activity activity, double latitude, double longitude, String address) {
        $this.callResultCallback(activity, latitude, longitude, address);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/kyc/nashidmrz/mrtd2/activity/viewmodel/scan/CameraXLivePreviewViewModel$OnImageProcessedListener;", "", "onImageProcessed", "", "croppedBitmap", "Landroid/graphics/Bitmap;", "IDV_release"})
    public static interface OnImageProcessedListener {
        public void onImageProcessed(@Nullable Bitmap var1);
    }
}

