/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.mrtd2.locale;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import com.kyc.nashidmrz.utility.SharePreferenceUtility;
import java.util.Locale;

public class LocaleHelperData {
    private static final String SELECTED_LANGUAGE = "Locale.Helper.Selected.Language";

    public static Context setLocale(Context context, String language) {
        LocaleHelperData.persist(context, language);
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleHelperData.updateResources(context, language);
        }
        return LocaleHelperData.updateResourcesLegacy(context, language);
    }

    private static void persist(Context context, String language) {
        SharePreferenceUtility.saveLocalPreferenceValue(context, language);
    }

    @TargetApi(value=24)
    private static Context updateResources(Context context, String language) {
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Configuration configuration = context.getResources().getConfiguration();
        configuration.setLocale(locale);
        configuration.setLayoutDirection(locale);
        return context.createConfigurationContext(configuration);
    }

    private static Context updateResourcesLegacy(Context context, String language) {
        Locale locale = new Locale(language);
        Locale.setDefault(locale);
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        if (Build.VERSION.SDK_INT >= 17) {
            configuration.setLayoutDirection(locale);
        }
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        return context;
    }
}

