/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.networking;

import android.content.Context;
import android.util.Log;
import com.kyc.nashidmrz.Logger;
import com.kyc.nashidmrz.networking.AuthInterceptor;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class APIClient {
    private static Retrofit retrofit = null;
    private static int timeOut;
    private final Logger logger = Logger.withTag(this.getClass().getSimpleName());

    public static native String baseUrlFromJNI();

    public static native String autocropbaseUrlFromJNI();

    public static native String autoCropApiKey();

    public static native String amlAPI();

    public static native String autoCropApiSecretKey();

    public static native String baseGoogleUrlFromJNI();

    public static native String getToken();

    public static native String getAmlToken();

    public static Retrofit getClient(String identifier, String baseUrl) {
        baseUrl = APIClient.determineBaseUrl(identifier, baseUrl);
        if (identifier.equalsIgnoreCase("GoogleApi")) {
            return APIClient.getGoogleApiClient();
        }
        return APIClient.getCustomApiClient(identifier, baseUrl);
    }

    private static Retrofit getCustomApiClient(String identifier, String baseUrl) {
        OkHttpClient client = APIClient.createClient(identifier);
        return new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(client).build();
    }

    private static OkHttpClient createClient(String identifier) {
        if (identifier.equalsIgnoreCase("AML")) {
            return APIClient.createAmlClient();
        }
        if (identifier.equalsIgnoreCase("image crop")) {
            return APIClient.createImageCropClient();
        }
        return APIClient.createDefaultClient();
    }

    private static OkHttpClient createImageCropClient() {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        return new OkHttpClient.Builder().connectTimeout((long)timeOut, TimeUnit.SECONDS).readTimeout((long)timeOut, TimeUnit.SECONDS).writeTimeout((long)timeOut, TimeUnit.SECONDS).addInterceptor((Interceptor)new AuthInterceptor(APIClient.getToken())).sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]).build();
    }

    private static OkHttpClient createDefaultClient() {
        return new OkHttpClient.Builder().connectTimeout((long)timeOut, TimeUnit.SECONDS).readTimeout((long)timeOut, TimeUnit.SECONDS).writeTimeout((long)timeOut, TimeUnit.SECONDS).addInterceptor((Interceptor)new AuthInterceptor(APIClient.getToken())).build();
    }

    private static OkHttpClient createAmlClient() {
        return new OkHttpClient.Builder().connectTimeout((long)timeOut, TimeUnit.SECONDS).readTimeout((long)timeOut, TimeUnit.SECONDS).writeTimeout((long)timeOut, TimeUnit.SECONDS).addInterceptor((Interceptor)new AuthInterceptor(APIClient.getAmlToken())).build();
    }

    private static Retrofit getGoogleApiClient() {
        OkHttpClient client = APIClient.createClientWithLogging();
        return new Retrofit.Builder().baseUrl(APIClient.baseGoogleUrlFromJNI()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(client).build();
    }

    private static OkHttpClient createClientWithLogging() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return new OkHttpClient.Builder().connectTimeout((long)timeOut, TimeUnit.SECONDS).readTimeout((long)timeOut, TimeUnit.SECONDS).writeTimeout((long)timeOut, TimeUnit.SECONDS).addInterceptor((Interceptor)interceptor).build();
    }

    public static Retrofit getFeatureCheckClient(String baseUrl, String token) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout((long)timeOut, TimeUnit.SECONDS).readTimeout((long)timeOut, TimeUnit.SECONDS).writeTimeout((long)timeOut, TimeUnit.SECONDS).addInterceptor((Interceptor)new AuthInterceptor(token)).build();
        retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(okHttpClient).build();
        return retrofit;
    }

    public static Retrofit getNashidFeatureCheckClient(String baseUrl, String token) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout((long)timeOut, TimeUnit.SECONDS).readTimeout((long)timeOut, TimeUnit.SECONDS).writeTimeout((long)timeOut, TimeUnit.SECONDS).addInterceptor((Interceptor)new AuthInterceptor(token)).build();
        Log.d((String)"TAG", (String)("getNashidFeatureCheckClient: " + baseUrl + "  " + token));
        retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(okHttpClient).build();
        return retrofit;
    }

    public static Retrofit getEmployeeTkenClient(String baseUrl, String token) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout((long)timeOut, TimeUnit.SECONDS).readTimeout((long)timeOut, TimeUnit.SECONDS).writeTimeout((long)timeOut, TimeUnit.SECONDS).addInterceptor((Interceptor)new AuthInterceptor(token)).build();
        retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(okHttpClient).build();
        return retrofit;
    }

    private static String determineBaseUrl(String identifier, String baseUrl) {
        if (baseUrl.isEmpty()) {
            switch (identifier) {
                case "image crop": {
                    return APIClient.autocropbaseUrlFromJNI();
                }
                case "AML": {
                    return APIClient.amlAPI();
                }
            }
            return APIClient.baseUrlFromJNI();
        }
        return baseUrl;
    }

    public static Retrofit getClient(Context context, String baseUrl, String token) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout((long)timeOut, TimeUnit.SECONDS).readTimeout((long)timeOut, TimeUnit.SECONDS).writeTimeout((long)timeOut, TimeUnit.SECONDS).addInterceptor((Interceptor)new AuthInterceptor(token)).build();
        retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(okHttpClient).build();
        return retrofit;
    }

    static {
        System.loadLibrary("native-lib");
        timeOut = 30;
    }
}

