/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.utility;

import android.content.Context;
import android.graphics.Bitmap;
import com.kyc.nashidmrz.R;

public class ImageBrightnessDetector {
    public static String isImageTooDarkOrTooLight(Context context, Bitmap bitmap) {
        double averageIntensity = ImageBrightnessDetector.calculateAverageIntensity(bitmap);
        double darkThreshold = 50.0;
        double lightThreshold = 200.0;
        if (averageIntensity < darkThreshold) {
            return context.getString(R.string.image_light_dark);
        }
        if (averageIntensity > lightThreshold) {
            return context.getString(R.string.image_light_light);
        }
        return context.getString(R.string.image_light_normal);
    }

    private static double calculateAverageIntensity(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        long totalIntensity = 0L;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = bitmap.getPixel(x, y);
                int intensity = pixel >> 16 & 0xFF;
                totalIntensity += (long)intensity;
            }
        }
        return (double)totalIntensity / (double)(width * height);
    }
}

