/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.utility;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.NfcManager;
import com.kyc.nashidmrz.R;

public class NFCDialogUtility {
    public void openEnableNFCDialog(final Activity activity, final DialogClickListner dialogClickListner) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle((CharSequence)activity.getResources().getString(R.string.error_error)).setMessage((CharSequence)activity.getResources().getString(R.string.error_nfc_is_disabled)).setCancelable(true).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (dialogClickListner != null) {
                    dialogClickListner.OnClickNegativeButton();
                }
            }
        }).setPositiveButton((CharSequence)"enable", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (dialogClickListner != null) {
                    dialogClickListner.OnClickPositiveButton();
                }
                Intent intent = new Intent("android.settings.NFC_SETTINGS");
                activity.startActivity(intent);
            }
        }).create();
        builder.show();
    }

    public void openNotSupportedNFCDialog(final Activity activity, final DialogClickListner dialogClickListner) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setTitle((CharSequence)activity.getResources().getString(R.string.error_error)).setMessage((CharSequence)activity.getResources().getString(R.string.error_nfc_not_supported)).setCancelable(true).setPositiveButton((CharSequence)"Okay", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (dialogClickListner != null) {
                    dialogClickListner.OnClickPositiveButton();
                }
                Intent intent = new Intent("android.settings.NFC_SETTINGS");
                activity.startActivity(intent);
            }
        }).create();
        builder.show();
    }

    public int isNFCAvailable(Activity activity) {
        NfcManager manager = (NfcManager)activity.getSystemService("nfc");
        NfcAdapter adapter = manager.getDefaultAdapter();
        NFCDialogUtility dialogUtility = new NFCDialogUtility();
        if (adapter != null && adapter.isEnabled()) {
            return 1;
        }
        if (adapter != null && !adapter.isEnabled()) {
            return 0;
        }
        return 2;
    }

    public static interface DialogClickListner {
        public void OnClickNegativeButton();

        public void OnClickPositiveButton();
    }
}

