/*
 * Decompiled with CFR 0.152.
 */
package com.kyc.nashidmrz.utility;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SecureSharedPreferences
implements SharedPreferences {
    private static final int flags = 11;
    private SharedPreferences mSharedPreferences;
    private String mSharePrefrencesFilename;
    private static String prefix;
    private final String TAG = SecureSharedPreferences.class.getName();
    private Context mContext;
    private byte[] mAssociatedData;
    private SecretKey secretKey;
    private static boolean mIsLoggingEnabled;
    private final SecureRandom secureRandom = new SecureRandom();
    private final int GCM_IV_LENGTH = 12;
    private final Charset charSet = StandardCharsets.UTF_8;
    private final String algo = "AES/GCM/NoPadding";

    public SecureSharedPreferences(Context context) {
        this.init(context, null, null, null);
    }

    public SecureSharedPreferences(Context context, String password) {
        this.init(context, password, null, null);
    }

    public SecureSharedPreferences(Context context, String password, String sharedPrefFilename) {
        this.init(context, password, null, sharedPrefFilename);
    }

    public SecureSharedPreferences(Context context, String password, String salt, String sharedPrefFilename) {
        this.init(context, password, salt, sharedPrefFilename);
    }

    private void init(Context context, String password, String salt, String sharedPrefFilename) {
        this.mContext = context;
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = this.getSharedPreferenceFile(sharedPrefFilename);
        }
        this.mAssociatedData = TextUtils.isEmpty((CharSequence)salt) ? SecureSharedPreferences.sha256(SecureSharedPreferences.getUniquePsuedoID() + "." + this.mContext.getPackageName()) : salt.getBytes(this.charSet);
        byte[] mPassword = TextUtils.isEmpty((CharSequence)password) ? SecureSharedPreferences.sha256(this.mContext.getPackageName() + "." + new String(this.mAssociatedData, this.charSet)) : SecureSharedPreferences.sha256(password + "." + new String(this.mAssociatedData, this.charSet));
        this.secretKey = new SecretKeySpec(mPassword, "AES");
    }

    public void setPrefix(String p) {
        prefix = p;
    }

    public void setDebugable(boolean debugable) {
        mIsLoggingEnabled = debugable;
    }

    private static byte[] sha256(String name) {
        try {
            MessageDigest digest = null;
            try {
                digest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e1) {
                e1.printStackTrace();
            }
            assert (digest != null);
            digest.reset();
            return digest.digest(name.getBytes());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private SharedPreferences getSharedPreferenceFile(String prefFilename) {
        this.mSharePrefrencesFilename = prefFilename;
        if (TextUtils.isEmpty((CharSequence)prefFilename)) {
            return PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
        }
        return this.mContext.getSharedPreferences(prefFilename, 0);
    }

    public String keyName(String key) {
        String k = TextUtils.isEmpty((CharSequence)prefix) ? key : key + "_" + prefix;
        return Base64.encodeToString((byte[])SecureSharedPreferences.sha256(k), (int)11);
    }

    private String encrypt(String content) {
        try {
            byte[] iv = new byte[12];
            this.secureRandom.nextBytes(iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)this.secretKey, parameterSpec);
            if (this.mAssociatedData != null) {
                cipher.updateAAD(this.mAssociatedData);
            }
            byte[] cipherText = cipher.doFinal(content.getBytes(this.charSet));
            ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + cipherText.length);
            byteBuffer.put(iv);
            byteBuffer.put(cipherText);
            return Base64.encodeToString((byte[])byteBuffer.array(), (int)11);
        }
        catch (Exception e) {
            this.loge(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private String decrypt(String content) {
        try {
            byte[] cipherMessage = Base64.decode((String)content, (int)11);
            byte[] iv = new byte[12];
            System.arraycopy(cipherMessage, 0, iv, 0, 12);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmIv = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)this.secretKey, gcmIv);
            if (this.mAssociatedData != null) {
                cipher.updateAAD(this.mAssociatedData);
            }
            byte[] decrypted = cipher.doFinal(cipherMessage, 12, cipherMessage.length - 12);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.loge(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void loge(String msg) {
        if (mIsLoggingEnabled) {
            Log.e((String)this.TAG, (String)msg);
        }
    }

    public Map<String, ?> getAll() {
        Map encryptedMap = this.mSharedPreferences.getAll();
        HashMap<String, Object> decryptedMap = new HashMap<String, Object>(encryptedMap.size());
        for (Map.Entry entry : encryptedMap.entrySet()) {
            Object cipherText = entry.getValue();
            if (cipherText == null) continue;
            try {
                Set<String> stringSet = this.getDecryptedStringSet(cipherText);
                if (stringSet != null) {
                    decryptedMap.put((String)entry.getKey(), stringSet);
                    continue;
                }
                decryptedMap.put((String)entry.getKey(), this.decrypt(cipherText.toString()));
            }
            catch (Exception e) {
                this.loge(e.getMessage());
                decryptedMap.put((String)entry.getKey(), cipherText.toString());
            }
        }
        return decryptedMap;
    }

    @Nullable
    public String getString(String s, @Nullable String defaultValue) {
        String encryptedValue = this.mSharedPreferences.getString(this.keyName(s), null);
        if (encryptedValue == null) {
            return defaultValue;
        }
        String decryptedValue = this.decrypt(encryptedValue);
        if (decryptedValue != null) {
            return decryptedValue;
        }
        return defaultValue;
    }

    @TargetApi(value=11)
    public Set<String> getStringSet(String key, Set<String> defaultValues) {
        Set encryptedSet = this.mSharedPreferences.getStringSet(this.keyName(key), null);
        if (encryptedSet == null) {
            return defaultValues;
        }
        HashSet<String> decryptedSet = new HashSet<String>(encryptedSet.size());
        for (String encryptedValue : encryptedSet) {
            decryptedSet.add(this.decrypt(encryptedValue));
        }
        return decryptedSet;
    }

    public int getInt(String key, int defaultValue) {
        String encryptedValue = this.mSharedPreferences.getString(this.keyName(key), null);
        if (encryptedValue == null) {
            return defaultValue;
        }
        try {
            String s = this.decrypt(encryptedValue);
            if (s == null) {
                return defaultValue;
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException(e.getMessage());
        }
    }

    public double getDouble(String key, int defaultValue) {
        String encryptedValue = this.mSharedPreferences.getString(this.keyName(key), null);
        if (encryptedValue == null) {
            return defaultValue;
        }
        try {
            String s = this.decrypt(encryptedValue);
            if (s == null) {
                return defaultValue;
            }
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException(e.getMessage());
        }
    }

    public long getLong(String key, long defaultValue) {
        String encryptedValue = this.mSharedPreferences.getString(this.keyName(key), null);
        if (encryptedValue == null) {
            return defaultValue;
        }
        try {
            String s = this.decrypt(encryptedValue);
            if (s == null) {
                return defaultValue;
            }
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException(e.getMessage());
        }
    }

    public float getFloat(String key, float defaultValue) {
        String encryptedValue = this.mSharedPreferences.getString(this.keyName(key), null);
        if (encryptedValue == null) {
            return defaultValue;
        }
        try {
            String s = this.decrypt(encryptedValue);
            if (s == null) {
                return defaultValue;
            }
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException(e.getMessage());
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String encryptedValue = this.mSharedPreferences.getString(this.keyName(key), null);
        if (encryptedValue == null) {
            return defaultValue;
        }
        try {
            String s = this.decrypt(encryptedValue);
            if (s == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(s);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException(e.getMessage());
        }
    }

    public void setJSONObject(String key, JSONObject jsonObject) {
        this.edit().putString(key, jsonObject.toString()).apply();
    }

    public JSONObject getJSONObject(String key, JSONObject defaultValue) throws JSONException {
        String s = this.getString(key, null);
        if (TextUtils.isEmpty((CharSequence)s)) {
            return defaultValue;
        }
        assert (s != null);
        return new JSONObject(s);
    }

    public void setJSONArray(String key, JSONArray jsonArray) {
        this.edit().putString(key, jsonArray.toString()).apply();
    }

    public JSONArray getJSONArray(String key, JSONArray defaultValue) throws JSONException {
        String s = this.getString(key, null);
        if (TextUtils.isEmpty((CharSequence)s)) {
            return defaultValue;
        }
        assert (s != null);
        return new JSONArray(s);
    }

    public boolean contains(String key) {
        return this.mSharedPreferences.contains(this.keyName(key));
    }

    public Editor edit() {
        return new Editor();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mSharedPreferences.registerOnSharedPreferenceChangeListener(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mSharedPreferences.unregisterOnSharedPreferenceChangeListener(listener);
    }

    private Set<String> getDecryptedStringSet(Object cipherText) throws Exception {
        if (cipherText == null) {
            return null;
        }
        boolean isSet = cipherText instanceof Set;
        if (!isSet) {
            return null;
        }
        Set encryptedSet = (Set)cipherText;
        HashSet<String> decryptedSet = new HashSet<String>();
        for (Object object : encryptedSet) {
            if (object instanceof String) {
                decryptedSet.add(this.decrypt((String)object));
                continue;
            }
            return null;
        }
        return decryptedSet;
    }

    public static boolean isLoggingEnabled() {
        return mIsLoggingEnabled;
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        mIsLoggingEnabled = loggingEnabled;
    }

    public void changePassword(String password) {
        this.changePassword(password, null);
    }

    public void changePassword(String password, String salt) {
        Map<String, ?> oldPref = this.getAll();
        HashMap decryptedMap = new HashMap(oldPref.size());
        this.edit().clear().apply();
        this.secretKey = null;
        this.init(this.mContext, password, salt, this.mSharePrefrencesFilename);
        SharedPreferences sharedPreferences = this.getSharedPreferenceFile(this.mSharePrefrencesFilename);
        for (Map.Entry<String, ?> entry : oldPref.entrySet()) {
            Object cipherText = entry.getValue();
            if (cipherText == null) continue;
            try {
                if (cipherText instanceof HashSet) {
                    Set stringSet = (Set)cipherText;
                    HashSet<String> encryptedValues = new HashSet<String>(stringSet.size());
                    for (String value : stringSet) {
                        encryptedValues.add(this.encrypt(value));
                    }
                    sharedPreferences.edit().putStringSet(entry.getKey(), encryptedValues).apply();
                    continue;
                }
                sharedPreferences.edit().putString(entry.getKey(), this.encrypt(cipherText.toString())).apply();
            }
            catch (Exception e) {
                this.loge(e.getMessage());
                sharedPreferences.edit().putString(entry.getKey(), cipherText.toString()).apply();
            }
        }
    }

    public static String getUniquePsuedoID() {
        String m_szDevIDShort = 35 + Build.BOARD + Build.BRAND + Build.CPU_ABI + Build.DEVICE + Build.MANUFACTURER + Build.MODEL + Build.PRODUCT + Build.HARDWARE;
        String serial = null;
        try {
            serial = Objects.requireNonNull(Build.class.getField("SERIAL").get(null)).toString();
            return Base64.encodeToString((byte[])SecureSharedPreferences.sha256(new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString()), (int)11);
        }
        catch (Exception exception) {
            serial = "serial";
            return Base64.encodeToString((byte[])SecureSharedPreferences.sha256(new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString()), (int)11);
        }
    }

    public final class Editor
    implements SharedPreferences.Editor {
        private final SharedPreferences.Editor mEditor;

        private Editor() {
            this.mEditor = SecureSharedPreferences.this.mSharedPreferences.edit();
        }

        public SharedPreferences.Editor putString(String key, String value) {
            this.mEditor.putString(SecureSharedPreferences.this.keyName(key), SecureSharedPreferences.this.encrypt(value));
            return this;
        }

        public SharedPreferences.Editor putUnencryptedString(String key, String value) {
            this.mEditor.putString(SecureSharedPreferences.this.keyName(key), value);
            return this;
        }

        @TargetApi(value=11)
        public SharedPreferences.Editor putStringSet(String key, Set<String> values) {
            HashSet<String> encryptedValues = new HashSet<String>(values.size());
            for (String value : values) {
                encryptedValues.add(SecureSharedPreferences.this.encrypt(value));
            }
            this.mEditor.putStringSet(SecureSharedPreferences.this.keyName(key), encryptedValues);
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            this.mEditor.putString(SecureSharedPreferences.this.keyName(key), SecureSharedPreferences.this.encrypt(Integer.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putDouble(String key, double value) {
            this.mEditor.putString(SecureSharedPreferences.this.keyName(key), SecureSharedPreferences.this.encrypt(Double.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            this.mEditor.putString(SecureSharedPreferences.this.keyName(key), SecureSharedPreferences.this.encrypt(Long.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            this.mEditor.putString(SecureSharedPreferences.this.keyName(key), SecureSharedPreferences.this.encrypt(Float.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.mEditor.putString(SecureSharedPreferences.this.keyName(key), SecureSharedPreferences.this.encrypt(Boolean.toString(value)));
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.mEditor.remove(SecureSharedPreferences.this.keyName(key));
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.mEditor.clear();
            return this;
        }

        public boolean commit() {
            return this.mEditor.commit();
        }

        @TargetApi(value=9)
        public void apply() {
            this.mEditor.apply();
        }
    }
}

