/*
 * Decompiled with CFR 0.152.
 */
package com.mv.liveness;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.kyc.nashidmrz.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tJ\u0006\u0010\u0019\u001a\u00020\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/mv/liveness/CoverView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backColor", "borderColor", "borderPaint", "Landroid/graphics/Paint;", "horizontalPadding", "paint", "porterDuffXfermode", "Landroid/graphics/PorterDuffXfermode;", "rectF", "Landroid/graphics/RectF;", "verticalPadding", "changeColor", "", "color", "getRect", "onDraw", "canvas", "Landroid/graphics/Canvas;", "IDV_release"})
public final class CoverView
extends View {
    @NotNull
    private Paint paint;
    private int backColor;
    private int horizontalPadding;
    private int verticalPadding;
    private int borderColor;
    @NotNull
    private PorterDuffXfermode porterDuffXfermode;
    @NotNull
    private final RectF rectF;
    @NotNull
    private final Paint borderPaint;

    public CoverView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public CoverView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public CoverView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.borderColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.white);
        this.rectF = new RectF();
        this.borderPaint = new Paint();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CoverView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        this.horizontalPadding = (int)typedArray2.getDimension(R.styleable.CoverView_horizontalPadding, 80.0f);
        this.verticalPadding = (int)typedArray2.getDimension(R.styleable.CoverView_verticalPadding, 60.0f);
        this.backColor = typedArray2.getColor(R.styleable.CoverView_backgroundColor, ContextCompat.getColor((Context)context, (int)R.color.transparent));
        typedArray2.recycle();
        this.porterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT);
        this.paint = new Paint();
        this.paint.setColor(this.backColor);
        this.paint.setXfermode((Xfermode)this.porterDuffXfermode);
        this.setLayerType(1, null);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        RectF rectF;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int layerId = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
        canvas.drawColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.face_camera_back));
        RectF $this$onDraw_u24lambda_u240 = rectF = this.rectF;
        boolean bl = false;
        $this$onDraw_u24lambda_u240.left = this.horizontalPadding;
        $this$onDraw_u24lambda_u240.top = this.verticalPadding;
        $this$onDraw_u24lambda_u240.right = this.getWidth() - this.horizontalPadding;
        $this$onDraw_u24lambda_u240.bottom = this.getHeight() - this.verticalPadding;
        this.paint.setColor(0);
        this.paint.setStrokeWidth(30.0f);
        this.borderPaint.setColor(this.borderColor);
        float scale = this.getContext().getResources().getDisplayMetrics().scaledDensity;
        int desiredTextSizeInPixels = (int)((float)2 * scale + 0.5f);
        this.borderPaint.setStrokeWidth((float)desiredTextSizeInPixels);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        float[] fArray = new float[]{20.0f, 10.0f};
        this.borderPaint.setPathEffect((PathEffect)new DashPathEffect(fArray, 0.0f));
        canvas.drawOval(this.rectF, this.paint);
        canvas.drawOval(this.rectF, this.borderPaint);
        canvas.restoreToCount(layerId);
    }

    @NotNull
    public final RectF getRect() {
        return this.rectF;
    }

    public final void changeColor(int color2) {
        this.borderColor = color2;
        this.invalidate();
    }
}

