/*
 * Decompiled with CFR 0.152.
 */
package colorspace;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.ColorSpaceMapper;
import colorspace.boxes.PaletteBox;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.FacilityManager;

public class PalettizedColorSpaceMapper
extends ColorSpaceMapper {
    int[] outShiftValueArray;
    int srcChannel = 0;
    private PaletteBox pbox;

    public static BlkImgDataSrc createInstance(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws ColorSpaceException {
        return new PalettizedColorSpaceMapper(blkImgDataSrc, colorSpace);
    }

    protected PalettizedColorSpaceMapper(BlkImgDataSrc blkImgDataSrc, ColorSpace colorSpace) throws ColorSpaceException {
        super(blkImgDataSrc, colorSpace);
        this.pbox = colorSpace.getPaletteBox();
        this.initialize();
    }

    private void initialize() throws ColorSpaceException {
        if (this.ncomps != 1 && this.ncomps != 3) {
            throw new ColorSpaceException("wrong number of components (" + this.ncomps + ") for palettized image");
        }
        int n = this.getNumComps();
        this.outShiftValueArray = new int[n];
        for (int i = 0; i < n; ++i) {
            this.outShiftValueArray[i] = 1 << this.getNomRangeBits(i) - 1;
        }
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        if (this.pbox == null) {
            return this.src.getCompData(dataBlk, n);
        }
        if (this.ncomps != 1) {
            String string = "PalettizedColorSpaceMapper: color palette _not_ applied, incorrect number (" + String.valueOf(this.ncomps) + ") of components";
            FacilityManager.getMsgLogger().printmsg(2, string);
            return this.src.getCompData(dataBlk, n);
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        PalettizedColorSpaceMapper.setInternalBuffer(dataBlk);
        switch (dataBlk.getDataType()) {
            case 3: {
                PalettizedColorSpaceMapper.copyGeometry(this.inInt[0], dataBlk);
                this.inInt[0] = (DataBlkInt)this.src.getInternCompData(this.inInt[0], 0);
                this.dataInt[0] = (int[])this.inInt[0].getData();
                int[] nArray = ((DataBlkInt)dataBlk).getDataInt();
                for (int i = 0; i < dataBlk.h; ++i) {
                    n4 = this.inInt[0].offset + i * this.inInt[0].scanw;
                    n5 = n4 + this.inInt[0].w;
                    n2 = dataBlk.offset + i * dataBlk.scanw;
                    n3 = n2 + dataBlk.w;
                    n6 = n2;
                    n7 = n4;
                    while (n7 < n5) {
                        nArray[n6] = this.pbox.getEntry(n, this.dataInt[0][n7] + this.shiftValueArray[0]) - this.outShiftValueArray[n];
                        ++n7;
                        ++n6;
                    }
                }
                dataBlk.progressive = this.inInt[0].progressive;
                break;
            }
            case 4: {
                PalettizedColorSpaceMapper.copyGeometry(this.inFloat[0], dataBlk);
                this.inFloat[0] = (DataBlkFloat)this.src.getInternCompData(this.inFloat[0], 0);
                this.dataFloat[0] = (float[])this.inFloat[0].getData();
                float[] fArray = ((DataBlkFloat)dataBlk).getDataFloat();
                for (int i = 0; i < dataBlk.h; ++i) {
                    n4 = this.inFloat[0].offset + i * this.inFloat[0].scanw;
                    n5 = n4 + this.inFloat[0].w;
                    n2 = dataBlk.offset + i * dataBlk.scanw;
                    n3 = n2 + dataBlk.w;
                    n6 = n2;
                    n7 = n4;
                    while (n7 < n5) {
                        fArray[n6] = this.pbox.getEntry(n, (int)this.dataFloat[0][n7] + this.shiftValueArray[0]) - this.outShiftValueArray[n];
                        ++n7;
                        ++n6;
                    }
                }
                dataBlk.progressive = this.inFloat[0].progressive;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid source datablock type");
            }
        }
        dataBlk.offset = 0;
        dataBlk.scanw = dataBlk.w;
        return dataBlk;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[PalettizedColorSpaceMapper ");
        StringBuffer stringBuffer2 = new StringBuffer("  " + eol);
        if (this.pbox != null) {
            stringBuffer2.append("ncomps= ").append(this.getNumComps()).append(", scomp= ").append(this.srcChannel);
            for (int i = 0; i < this.getNumComps(); ++i) {
                stringBuffer2.append(eol).append("column= ").append(i).append(", ").append(this.pbox.getBitDepth(i)).append(" bit ").append(this.pbox.isSigned(i) ? "signed entry" : "unsigned entry");
            }
        } else {
            stringBuffer2.append("image does not contain a palette box");
        }
        stringBuffer.append(ColorSpace.indent("  ", stringBuffer2));
        return stringBuffer.append("]").toString();
    }

    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        return this.getCompData(dataBlk, n);
    }

    public int getNomRangeBits(int n) {
        return this.pbox == null ? this.src.getNomRangeBits(n) : (int)this.pbox.getBitDepth(n);
    }

    public int getNumComps() {
        return this.pbox == null ? this.src.getNumComps() : this.pbox.getNumColumns();
    }

    public int getCompSubsX(int n) {
        return this.imgdatasrc.getCompSubsX(this.srcChannel);
    }

    public int getCompSubsY(int n) {
        return this.imgdatasrc.getCompSubsY(this.srcChannel);
    }

    public int getTileCompWidth(int n, int n2) {
        return this.imgdatasrc.getTileCompWidth(n, this.srcChannel);
    }

    public int getTileCompHeight(int n, int n2) {
        return this.imgdatasrc.getTileCompHeight(n, this.srcChannel);
    }

    public int getCompImgWidth(int n) {
        return this.imgdatasrc.getCompImgWidth(this.srcChannel);
    }

    public int getCompImgHeight(int n) {
        return this.imgdatasrc.getCompImgHeight(this.srcChannel);
    }

    public int getCompULX(int n) {
        return this.imgdatasrc.getCompULX(this.srcChannel);
    }

    public int getCompULY(int n) {
        return this.imgdatasrc.getCompULY(this.srcChannel);
    }
}

