/*
 * Decompiled with CFR 0.152.
 */
package colorspace.boxes;

import colorspace.ColorSpaceException;
import colorspace.boxes.JP2Box;
import icc.ICCProfile;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jj2000.j2k.io.RandomAccessIO;

public final class ComponentMappingBox
extends JP2Box {
    private int nChannels;
    private Vector map = new Vector();

    public ComponentMappingBox(RandomAccessIO randomAccessIO, int n) throws IOException, ColorSpaceException {
        super(randomAccessIO, n);
        this.readBox();
    }

    void readBox() throws IOException {
        this.nChannels = (this.boxEnd - this.dataStart) / 4;
        this.in.seek(this.dataStart);
        for (int i = this.dataStart; i < this.boxEnd; i += 4) {
            byte[] byArray = new byte[4];
            this.in.readFully(byArray, 0, 4);
            this.map.addElement(byArray);
        }
    }

    public int getNChannels() {
        return this.nChannels;
    }

    public int getCMP(int n) {
        byte[] byArray = (byte[])this.map.elementAt(n);
        return ICCProfile.getShort(byArray, 0) & 0xFFFF;
    }

    public short getMTYP(int n) {
        byte[] byArray = (byte[])this.map.elementAt(n);
        return (short)(byArray[2] & 0xFF);
    }

    public short getPCOL(int n) {
        byte[] byArray = (byte[])this.map.elementAt(n);
        return (short)(byArray[3] & 0xFF);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ComponentMappingBox ").append("  ");
        stringBuffer.append("nChannels= ").append(String.valueOf(this.nChannels));
        Enumeration enumeration = this.map.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])enumeration.nextElement();
            stringBuffer.append(eol).append("  ").append("CMP= ").append(String.valueOf(this.getCMP(byArray))).append(", ");
            stringBuffer.append("MTYP= ").append(String.valueOf(this.getMTYP(byArray))).append(", ");
            stringBuffer.append("PCOL= ").append(String.valueOf(this.getPCOL(byArray)));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private int getCMP(byte[] byArray) {
        return ICCProfile.getShort(byArray, 0) & 0xFFFF;
    }

    private short getMTYP(byte[] byArray) {
        return (short)(byArray[2] & 0xFF);
    }

    private short getPCOL(byte[] byArray) {
        return (short)(byArray[3] & 0xFF);
    }

    static {
        type = 1668112752;
    }
}

