/*
 * Decompiled with CFR 0.152.
 */
package icc.lut;

import colorspace.ColorSpace;
import icc.RestrictedICCProfile;
import icc.lut.LookUpTableFP;
import icc.lut.MonochromeTransformException;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;

public class MonochromeTransformTosRGB {
    private static final String eol = System.getProperty("line.separator");
    public static final double ksRGBShadowCutoff = 0.0031308;
    public static final double ksRGBShadowSlope = 12.92;
    public static final double ksRGB8ShadowSlope = 3294.6;
    public static final double ksRGBExponent = 0.4166666666666667;
    public static final double ksRGB8ScaleAfterExp = 269.025;
    public static final double ksRGB8ReduceAfterExp = 14.025;
    private short[] lut = null;
    private int dwInputMaxValue = 0;
    private LookUpTableFP fLut = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[MonochromeTransformTosRGB ");
        StringBuffer stringBuffer2 = new StringBuffer("  ");
        stringBuffer2.append(eol).append("ksRGBShadowSlope= ").append(String.valueOf(12.92));
        stringBuffer2.append(eol).append("ksRGBShadowCutoff= ").append(String.valueOf(0.0031308));
        stringBuffer2.append(eol).append("ksRGBShadowSlope= ").append(String.valueOf(12.92));
        stringBuffer2.append(eol).append("ksRGB8ShadowSlope= ").append(String.valueOf(3294.6));
        stringBuffer2.append(eol).append("ksRGBExponent= ").append(String.valueOf(0.4166666666666667));
        stringBuffer2.append(eol).append("ksRGB8ScaleAfterExp= ").append(String.valueOf(269.025));
        stringBuffer2.append(eol).append("ksRGB8ReduceAfterExp= ").append(String.valueOf(14.025));
        stringBuffer2.append(eol).append("dwInputMaxValue= ").append(String.valueOf(this.dwInputMaxValue));
        stringBuffer2.append(eol).append("[lut = [short[" + this.lut.length + "]]]");
        stringBuffer2.append(eol).append("fLut=  " + this.fLut.toString());
        stringBuffer.append(ColorSpace.indent("  ", stringBuffer2));
        return stringBuffer.append("]").toString();
    }

    public MonochromeTransformTosRGB(RestrictedICCProfile restrictedICCProfile, int n, int n2) {
        int n3;
        if (restrictedICCProfile.getType() != 0) {
            throw new IllegalArgumentException("MonochromeTransformTosRGB: wrong type ICCProfile supplied");
        }
        this.dwInputMaxValue = n;
        this.lut = new short[n + 1];
        this.fLut = LookUpTableFP.createInstance(restrictedICCProfile.trc[0], n + 1);
        for (n3 = 0; n3 <= n && (double)this.fLut.lut[n3] <= 0.0031308; ++n3) {
            this.lut[n3] = (short)(Math.floor(3294.6 * (double)this.fLut.lut[n3] + 0.5) - (double)n2);
        }
        while (n3 <= n) {
            this.lut[n3] = (short)(Math.floor(269.025 * Math.pow(this.fLut.lut[n3], 0.4166666666666667) - 14.025 + 0.5) - (double)n2);
            ++n3;
        }
    }

    public void apply(DataBlkInt dataBlkInt, DataBlkInt dataBlkInt2) throws MonochromeTransformException {
        int[] nArray = (int[])dataBlkInt.getData();
        int[] nArray2 = (int[])dataBlkInt2.getData();
        if (nArray2 == null || nArray2.length < nArray.length) {
            nArray2 = new int[nArray.length];
            dataBlkInt2.setData(nArray2);
        }
        dataBlkInt2.uly = dataBlkInt.uly;
        dataBlkInt2.ulx = dataBlkInt.ulx;
        dataBlkInt2.h = dataBlkInt.h;
        dataBlkInt2.w = dataBlkInt.w;
        dataBlkInt2.offset = dataBlkInt.offset;
        dataBlkInt2.scanw = dataBlkInt.scanw;
        int n = dataBlkInt.offset;
        for (int i = 0; i < dataBlkInt.h * dataBlkInt.w; ++i) {
            int n2 = nArray[i];
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > this.dwInputMaxValue) {
                n2 = this.dwInputMaxValue;
            }
            nArray2[i] = this.lut[n2];
        }
    }

    public void apply(DataBlkFloat dataBlkFloat, DataBlkFloat dataBlkFloat2) throws MonochromeTransformException {
        float[] fArray = (float[])dataBlkFloat.getData();
        float[] fArray2 = (float[])dataBlkFloat2.getData();
        if (fArray2 == null || fArray2.length < fArray.length) {
            fArray2 = new float[fArray.length];
            dataBlkFloat2.setData(fArray2);
            dataBlkFloat2.uly = dataBlkFloat.uly;
            dataBlkFloat2.ulx = dataBlkFloat.ulx;
            dataBlkFloat2.h = dataBlkFloat.h;
            dataBlkFloat2.w = dataBlkFloat.w;
            dataBlkFloat2.offset = dataBlkFloat.offset;
            dataBlkFloat2.scanw = dataBlkFloat.scanw;
        }
        int n = dataBlkFloat.offset;
        for (int i = 0; i < dataBlkFloat.h * dataBlkFloat.w; ++i) {
            int n2 = (int)fArray[i];
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > this.dwInputMaxValue) {
                n2 = this.dwInputMaxValue;
            }
            fArray2[i] = this.lut[n2];
        }
    }
}

