/*
 * Decompiled with CFR 0.152.
 */
package icc.types;

import icc.ICCProfile;
import icc.types.ICCDateTime;
import icc.types.ICCProfileVersion;
import icc.types.XYZNumber;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ICCProfileHeader {
    private static final String eol = System.getProperty("line.separator");
    private byte[] header = null;
    public static int kdwProfileSignature = ICCProfile.getInt(new String("acsp").getBytes(), 0);
    public static int kdwProfileSigReverse = ICCProfile.getInt(new String("psca").getBytes(), 0);
    private static final String kdwInputProfile = "scnr";
    private static final String kdwDisplayProfile = "mntr";
    private static final String kdwRGBData = "RGB ";
    private static final String kdwGrayData = "GRAY";
    private static final String kdwXYZData = "XYZ ";
    private static final String kdwGrayTRCTag = "kTRC";
    private static final String kdwRedColorantTag = "rXYZ";
    private static final String kdwGreenColorantTag = "gXYZ";
    private static final String kdwBlueColorantTag = "bXYZ";
    private static final String kdwRedTRCTag = "rTRC";
    private static final String kdwGreenTRCTag = "gTRC";
    private static final String kdwBlueTRCTag = "bTRC";
    private static final int offProfileSize = 0;
    private static final int offCMMTypeSignature = 4;
    private static final int offProfileVersion = 8;
    private static final int offProfileClass = 12;
    private static final int offColorSpaceType = 16;
    private static final int offPCSType = 20;
    private static final int offDateTime = 24;
    private static final int offProfileSignature = 36;
    private static final int offPlatformSignature = 40;
    private static final int offCMMFlags = 44;
    private static final int offDeviceManufacturer = 48;
    private static final int offDeviceModel = 52;
    private static final int offDeviceAttributes1 = 56;
    private static final int offDeviceAttributesReserved = 60;
    private static final int offRenderingIntent = 64;
    private static final int offPCSIlluminant = 68;
    private static final int offCreatorSig = 80;
    private static final int offReserved = 84;
    public static final int size = 128;
    public int dwProfileSize;
    public int dwCMMTypeSignature;
    public int dwProfileClass;
    public int dwColorSpaceType;
    public int dwPCSType;
    public int dwProfileSignature;
    public int dwPlatformSignature;
    public int dwCMMFlags;
    public int dwDeviceManufacturer;
    public int dwDeviceModel;
    public int dwDeviceAttributes1;
    public int dwDeviceAttributesReserved;
    public int dwRenderingIntent;
    public int dwCreatorSig;
    public byte[] reserved = new byte[44];
    public ICCProfileVersion profileVersion;
    public ICCDateTime dateTime;
    public XYZNumber PCSIlluminant;

    public ICCProfileHeader() {
    }

    public ICCProfileHeader(byte[] byArray) {
        this.dwProfileSize = ICCProfile.getInt(byArray, 0);
        this.dwCMMTypeSignature = ICCProfile.getInt(byArray, 4);
        this.dwProfileClass = ICCProfile.getInt(byArray, 12);
        this.dwColorSpaceType = ICCProfile.getInt(byArray, 16);
        this.dwPCSType = ICCProfile.getInt(byArray, 20);
        this.dwProfileSignature = ICCProfile.getInt(byArray, 36);
        this.dwPlatformSignature = ICCProfile.getInt(byArray, 40);
        this.dwCMMFlags = ICCProfile.getInt(byArray, 44);
        this.dwDeviceManufacturer = ICCProfile.getInt(byArray, 48);
        this.dwDeviceModel = ICCProfile.getInt(byArray, 52);
        this.dwDeviceAttributes1 = ICCProfile.getInt(byArray, 60);
        this.dwDeviceAttributesReserved = ICCProfile.getInt(byArray, 60);
        this.dwRenderingIntent = ICCProfile.getInt(byArray, 64);
        this.dwCreatorSig = ICCProfile.getInt(byArray, 80);
        this.profileVersion = ICCProfile.getICCProfileVersion(byArray, 8);
        this.dateTime = ICCProfile.getICCDateTime(byArray, 24);
        this.PCSIlluminant = ICCProfile.getXYZNumber(byArray, 68);
        for (int i = 0; i < this.reserved.length; ++i) {
            this.reserved[i] = byArray[84 + i];
        }
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        randomAccessFile.write(this.dwProfileSize);
        randomAccessFile.seek(4L);
        randomAccessFile.write(this.dwCMMTypeSignature);
        randomAccessFile.seek(8L);
        this.profileVersion.write(randomAccessFile);
        randomAccessFile.seek(12L);
        randomAccessFile.write(this.dwProfileClass);
        randomAccessFile.seek(16L);
        randomAccessFile.write(this.dwColorSpaceType);
        randomAccessFile.seek(20L);
        randomAccessFile.write(this.dwPCSType);
        randomAccessFile.seek(24L);
        this.dateTime.write(randomAccessFile);
        randomAccessFile.seek(36L);
        randomAccessFile.write(this.dwProfileSignature);
        randomAccessFile.seek(40L);
        randomAccessFile.write(this.dwPlatformSignature);
        randomAccessFile.seek(44L);
        randomAccessFile.write(this.dwCMMFlags);
        randomAccessFile.seek(48L);
        randomAccessFile.write(this.dwDeviceManufacturer);
        randomAccessFile.seek(52L);
        randomAccessFile.write(this.dwDeviceModel);
        randomAccessFile.seek(56L);
        randomAccessFile.write(this.dwDeviceAttributes1);
        randomAccessFile.seek(60L);
        randomAccessFile.write(this.dwDeviceAttributesReserved);
        randomAccessFile.seek(64L);
        randomAccessFile.write(this.dwRenderingIntent);
        randomAccessFile.seek(68L);
        this.PCSIlluminant.write(randomAccessFile);
        randomAccessFile.seek(80L);
        randomAccessFile.write(this.dwCreatorSig);
        randomAccessFile.seek(84L);
        randomAccessFile.write(this.reserved);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ICCProfileHeader: ");
        stringBuffer.append(eol + "         ProfileSize: " + Integer.toHexString(this.dwProfileSize));
        stringBuffer.append(eol + "    CMMTypeSignature: " + Integer.toHexString(this.dwCMMTypeSignature));
        stringBuffer.append(eol + "        ProfileClass: " + Integer.toHexString(this.dwProfileClass));
        stringBuffer.append(eol + "      ColorSpaceType: " + Integer.toHexString(this.dwColorSpaceType));
        stringBuffer.append(eol + "           dwPCSType: " + Integer.toHexString(this.dwPCSType));
        stringBuffer.append(eol + "  dwProfileSignature: " + Integer.toHexString(this.dwProfileSignature));
        stringBuffer.append(eol + " dwPlatformSignature: " + Integer.toHexString(this.dwPlatformSignature));
        stringBuffer.append(eol + "          dwCMMFlags: " + Integer.toHexString(this.dwCMMFlags));
        stringBuffer.append(eol + "dwDeviceManufacturer: " + Integer.toHexString(this.dwDeviceManufacturer));
        stringBuffer.append(eol + "       dwDeviceModel: " + Integer.toHexString(this.dwDeviceModel));
        stringBuffer.append(eol + " dwDeviceAttributes1: " + Integer.toHexString(this.dwDeviceAttributes1));
        stringBuffer.append(eol + "   dwRenderingIntent: " + Integer.toHexString(this.dwRenderingIntent));
        stringBuffer.append(eol + "        dwCreatorSig: " + Integer.toHexString(this.dwCreatorSig));
        stringBuffer.append(eol + "      profileVersion: " + this.profileVersion);
        stringBuffer.append(eol + "            dateTime: " + this.dateTime);
        stringBuffer.append(eol + "       PCSIlluminant: " + this.PCSIlluminant);
        return stringBuffer.append("]").toString();
    }
}

