/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.roi;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import jj2000.j2k.roi.MaxShiftSpec;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.MultiResImgDataAdapter;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class ROIDeScaler
extends MultiResImgDataAdapter
implements CBlkQuantDataSrcDec {
    private MaxShiftSpec mss;
    public static final char OPT_PREFIX = 'R';
    private static final String[][] pinfo = new String[][]{{"Rno_roi", null, "This argument makes sure that the no ROI de-scaling is performed. Decompression is done like there is no ROI in the image", null}};
    private CBlkQuantDataSrcDec src;

    public ROIDeScaler(CBlkQuantDataSrcDec cBlkQuantDataSrcDec, MaxShiftSpec maxShiftSpec) {
        super(cBlkQuantDataSrcDec);
        this.src = cBlkQuantDataSrcDec;
        this.mss = maxShiftSpec;
    }

    public SubbandSyn getSynSubbandTree(int n, int n2) {
        return this.src.getSynSubbandTree(n, n2);
    }

    public int getCbULX() {
        return this.src.getCbULX();
    }

    public int getCbULY() {
        return this.src.getCbULY();
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public DataBlk getCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, DataBlk dataBlk) {
        return this.getInternCodeBlock(n, n2, n3, subbandSyn, dataBlk);
    }

    public DataBlk getInternCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, DataBlk dataBlk) {
        dataBlk = this.src.getInternCodeBlock(n, n2, n3, subbandSyn, dataBlk);
        boolean bl = false;
        if (this.mss == null || this.mss.getTileCompVal(this.getTileIdx(), n) == null) {
            bl = true;
        }
        if (bl || dataBlk == null) {
            return dataBlk;
        }
        int[] nArray = (int[])dataBlk.getData();
        int n4 = dataBlk.ulx;
        int n5 = dataBlk.uly;
        int n6 = dataBlk.w;
        int n7 = dataBlk.h;
        int n8 = (Integer)this.mss.getTileCompVal(this.getTileIdx(), n);
        int n9 = (1 << subbandSyn.magbits) - 1 << 31 - subbandSyn.magbits;
        int n10 = ~n9 & Integer.MAX_VALUE;
        int n11 = dataBlk.scanw - n6;
        int n12 = dataBlk.offset + dataBlk.scanw * (n7 - 1) + n6 - 1;
        for (int i = n7; i > 0; --i) {
            int n13 = n6;
            while (n13 > 0) {
                int n14 = nArray[n12];
                if ((n14 & n9) == 0) {
                    nArray[n12] = n14 & Integer.MIN_VALUE | n14 << n8;
                } else if ((n14 & n10) != 0) {
                    nArray[n12] = n14 & ~n10 | 1 << 30 - subbandSyn.magbits;
                }
                --n13;
                --n12;
            }
            n12 -= n11;
        }
        return dataBlk;
    }

    public static ROIDeScaler createInstance(CBlkQuantDataSrcDec cBlkQuantDataSrcDec, ParameterList parameterList, DecoderSpecs decoderSpecs) {
        parameterList.checkList('R', ParameterList.toNameArray(pinfo));
        String string = parameterList.getParameter("Rno_roi");
        if (string != null || decoderSpecs.rois == null) {
            return new ROIDeScaler(cBlkQuantDataSrcDec, null);
        }
        return new ROIDeScaler(cBlkQuantDataSrcDec, decoderSpecs.rois);
    }
}

