package nashid.verify.sdk.id_card.omn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class OmanCardDG11File {
    public static final Charset charset = StandardCharsets.UTF_16LE;
    public static final int TAG_COMPANY_NAME_ARABIC = 0xAB23;
    public static final int TAG_COMPANY_NAME_ENGLISH = 0xEB24;
    public static final int TAG_COMPANY_ADDRESS_ARABIC = 0xAB25;
//    public static final int TAG_COMPANY_ADDRESS_ENGLISH = 0xEB25;

    String companyNameArabic;
    String companyNameEnglish;
    String companyAddressArabic;
//    String companyAddressEnglish;

    public OmanCardDG11File(byte[] buffer) throws IOException {
        OmanCardDataInputStream omanCardDataInputStream =  new OmanCardDataInputStream(new ByteArrayInputStream(buffer));
//        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
//        byte[] buffer1 = new byte[1024];
//        int length;
//        while ((length = omanCardDataInputStream.dataInputStream.read(buffer1)) != -1) {
//            outputStream.write(buffer1, 0, length);
//        }
//
//// Convert byte array to a String
//        String content = new String(outputStream.toByteArray(), StandardCharsets.UTF_16LE);
//
////        System.out.println(content);
//         content = new String(buffer, StandardCharsets.UTF_16LE);
//
////        System.out.println(content);
//        Log.d("TAG", "setIDCardDetailOmanCardDG11File: "+content+"   ");
        companyNameArabic = new String(omanCardDataInputStream.getTagValue(TAG_COMPANY_NAME_ARABIC),charset);
        companyNameEnglish = new String(omanCardDataInputStream.getTagValue(TAG_COMPANY_NAME_ENGLISH),charset);
        companyAddressArabic = new String(omanCardDataInputStream.getTagValue(TAG_COMPANY_ADDRESS_ARABIC),charset);
//        companyAddressEnglish = new String(omanCardDataInputStream.getTagValue(TAG_COMPANY_ADDRESS_ENGLISH),charset);
    }

    public String getTagValue(int tag)
    {
        switch (tag){
            case TAG_COMPANY_NAME_ARABIC: return companyNameArabic;
            case TAG_COMPANY_NAME_ENGLISH: return companyNameEnglish;
            case TAG_COMPANY_ADDRESS_ARABIC: return companyAddressArabic;
//            case TAG_COMPANY_ADDRESS_ENGLISH: return companyAddressEnglish;
            default: break;
        }
        return null;
    }

    @Override
    public String toString() {
        return "OmanCardDG11File{" +
                ""+TAG_COMPANY_NAME_ARABIC+"='" + companyNameArabic + '\'' +
                ", "+TAG_COMPANY_NAME_ENGLISH+"='" + companyNameEnglish + '\'' +
                ", "+TAG_COMPANY_ADDRESS_ARABIC+"='" + companyAddressArabic + '\'' +
//                ", "+TAG_COMPANY_ADDRESS_ENGLISH+"='" + companyAddressEnglish + '\'' +
                '}';
    }
/* public String toString()
    {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DG11: ");
        stringBuilder.append("{\"companyNameArabic\": \"");stringBuilder.append(companyNameArabic);
        stringBuilder.append("\";\"companyNameEnglish\": \"");stringBuilder.append(companyNameEnglish);
        stringBuilder.append("\";\"companyAddressArabic\": \"");stringBuilder.append(companyAddressArabic);
        stringBuilder.append("\"}");
        return stringBuilder.toString();
    }*/

    public String getCompanyNameArabic() {
        return companyNameArabic;
    }

    public void setCompanyNameArabic(String companyNameArabic) {
        this.companyNameArabic = companyNameArabic;
    }

    public String getCompanyNameEnglish() {
        return companyNameEnglish;
    }

    public void setCompanyNameEnglish(String companyNameEnglish) {
        this.companyNameEnglish = companyNameEnglish;
    }

    public String getCompanyAddressArabic() {
        return companyAddressArabic;
    }
//    public String getCompanyAddressEnglish() {
//        return companyAddressEnglish;
//    }

    public void setCompanyAddressArabic(String companyAddressArabic) {
        this.companyAddressArabic = companyAddressArabic;
    }
}
