package nashid.verify.sdk.internetutility;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;

import nashid.verify.sdk.mrtd2.activity.TextSizeConverter;
import nashid.verify.sdk.R;
import nashid.verify.sdk.databinding.DialogNoInternetBinding;
import nashid.verify.sdk.utility.OnInternetAvailabilityListener;

import java.util.Objects;

public class ErrorUtility {

    private static final ErrorUtility errorUtility = new ErrorUtility();
    private static final String TAG = "ErrorUtility";
    private OnInternetAvailabilityListener onInternetAvailabilityListener;
    private boolean isNetworkAvailable = false;
    private TextSizeConverter textSizeConverter;
    private Dialog dialog;
    private int activeActivities = 0;
    private ConnectivityManager conMgr;

    public static ErrorUtility getInstance() {
        return errorUtility;
    }

    public void showNoInternetDialog(FragmentActivity activity, boolean isActivityRunning) {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (isActivityRunning) {
                    textSizeConverter = new TextSizeConverter(activity);
                    dialog = new Dialog(activity);
                    dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
                    DialogNoInternetBinding binding = DialogNoInternetBinding.inflate(dialog.getLayoutInflater());
                    dialog.setContentView(binding.getRoot());

                    binding.imgScanFailure.setAnimation(R.raw.failure);
                    binding.btnRetry.setVisibility(View.VISIBLE);

                    int padding = textSizeConverter.getPaddingORMarginValue(16);
                    binding.mainDialogLyt.setPadding(padding, padding, padding, padding);

                    ViewGroup.LayoutParams layoutParams2 = binding.imgScanFailure.getLayoutParams();
                    layoutParams2.width = textSizeConverter.getWidth(56);
                    layoutParams2.height = textSizeConverter.getHeight(56);
                    binding.imgScanFailure.setLayoutParams(layoutParams2);

                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) binding.imgScanFailure.getLayoutParams();
                    layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(8), 0, 0);
                    binding.imgScanFailure.setLayoutParams(layoutParams);
                    binding.txtScanCompleted.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(18));

                    layoutParams = (LinearLayout.LayoutParams) binding.txtScanCompleted.getLayoutParams();
                    layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(24), 0, textSizeConverter.getPaddingORMarginValue(24));
                    binding.txtScanCompleted.setLayoutParams(layoutParams);


                    padding = textSizeConverter.getPaddingORMarginValue(12);
                    binding.txtBtnRetry.setPadding(0, padding, 0, padding);
                    binding.txtBtnRetry.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16));
                    binding.btnRetry.setRadius(textSizeConverter.calculateRadius(8));

                    binding.btnRetry.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {

                            if (isNetworkAvailable)
                                dialog.dismiss();
                        }
                    });
                    dialog.show();
                    dialog.setCancelable(false);
                    Objects.requireNonNull(dialog.getWindow()).setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                    dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
                    dialog.getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
                    dialog.getWindow().setGravity(Gravity.BOTTOM);
                }
            }
        });

    }

    public boolean registerConnectivityManager(Activity activity, OnInternetAvailabilityListener onInternetAvailabilityListener) {
        Log.d(TAG, "registerConnectivityanager: " + activity.getLocalClassName());
        this.onInternetAvailabilityListener = onInternetAvailabilityListener;
        if (activeActivities == 0) {
            conMgr = (ConnectivityManager) activity
                    .getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkRequest networkRequest = new NetworkRequest.Builder()
                    .addCapability(NetworkCapabilities.NET_CAPABILITY_INTERNET)
                    .addTransportType(NetworkCapabilities.TRANSPORT_WIFI)
                    .addTransportType(NetworkCapabilities.TRANSPORT_CELLULAR)
                    .build();
            conMgr.requestNetwork(networkRequest, networkCallback);
        }
        activeActivities++;
        NetworkInfo netInfo = conMgr.getActiveNetworkInfo();

        return netInfo != null && netInfo.isConnectedOrConnecting() && netInfo.isAvailable();

    }

    private final ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback() {
        @Override
        public void onAvailable(@NonNull Network network) {
            super.onAvailable(network);
            if (!isNetworkAvailable) {
                Log.d(TAG, "onAvailable:connection available ");
                isNetworkAvailable = true;
                if (onInternetAvailabilityListener != null) {
                    onInternetAvailabilityListener.onAvailable();
                }
                if (dialog != null) {
                    dialog.dismiss();
                }
            }
        }

        @Override
        public void onLost(@NonNull Network network) {
            super.onLost(network);
            if (isNetworkAvailable) {
                isNetworkAvailable = false;
                Log.d(TAG, "onLost: connection lost");
                if (onInternetAvailabilityListener != null) {
                    onInternetAvailabilityListener.onLost();
                }

            }
        }

    };

    public void unregisterConnectivityManager(Activity activity) {
        activeActivities--;
        if (activeActivities == 0) {
            Log.d(TAG, "unregisterConnectivityManager: " + activity.getLocalClassName());
            ConnectivityManager connectivityManager = (ConnectivityManager) activity.getSystemService(Context.CONNECTIVITY_SERVICE);
            connectivityManager.unregisterNetworkCallback(networkCallback);
        }
    }

}
