package nashid.verify.sdk.mrtd2.activity;

import android.os.Bundle;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;

import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import nashid.verify.sdk.NashidSDK;
import nashid.verify.sdk.OtherConstant;
import nashid.verify.sdk.R;
import nashid.verify.sdk.databinding.ActivitySettingBinding;
import nashid.verify.sdk.mrtd2.rooted.RootedCheck;
import nashid.verify.sdk.networking.APIClient;
import nashid.verify.sdk.networking.APIInterface;
import nashid.verify.sdk.networking.models.nashidfeaturecheck.NashidFeatureCheck;
import nashid.verify.sdk.utility.SharePreferenceUtility;

import java.util.ArrayList;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class SettingScreenActivity extends BaseActivity {

    private ActivitySettingBinding binding;
    private boolean isNFCEnabled = true;
    private boolean isFacialMatchingEnabled = true;
    private boolean isAMLScreeningEnabled = true;
    private boolean isInstructionEnabled = true;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivitySettingBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());
        RootedCheck.getInstance().setFlag(SettingScreenActivity.this);

        if (RootedCheck.getInstance().isRootedDevice(getApplicationContext())) {
            RootedCheck.getInstance().showRootedDeviceDialog(this, getString(R.string.root_dialog), getString(R.string.root_desc), getString(R.string.root_btn));
        } else {
            setLayoutAndTextSize();
            if (OtherConstant.getInstance().getAppName().equalsIgnoreCase(getString(R.string.default_name))) {
                binding.lytAmlScreening.setVisibility(View.VISIBLE);
                binding.lytInstruction.setVisibility(View.VISIBLE);
            } else {
                binding.lytNfc.setVisibility(View.GONE);
                binding.lytFacialMatching.setVisibility(View.GONE);
                binding.lytAmlScreening.setVisibility(View.GONE);
                binding.lytInstruction.setVisibility(View.GONE);
                callNashidFeatureCheckAPI();
            }
            initClick();
        }

    }

    private void callNashidFeatureCheckAPI() {
        binding.lytLoading.setVisibility(View.VISIBLE);
        Log.d("TAG", "callNashidFeatureCheckAPI: " + NashidSDK.getInstance().getBaseURL());
        if (!NashidSDK.getInstance().getBaseURL().equalsIgnoreCase("") && !NashidSDK.getInstance().getRegisterToken().equalsIgnoreCase("")) {
            APIClient.getNashidFeatureCheckClient(NashidSDK.getInstance().getBaseURL(), NashidSDK.getInstance().getRegisterToken()).create(APIInterface.class).callNashidFeatureCheck(NashidSDK.getInstance().getCompanyUUID()).enqueue(new Callback<NashidFeatureCheck>() {
                @Override
                public void onResponse(Call<NashidFeatureCheck> call, Response<NashidFeatureCheck> response) {
                    Log.d("TAG", "openScanDocumentScreen onResponse: " + response.isSuccessful() + "\n" + response.body());
                    try {
                        if (response.isSuccessful()) {
                            NashidFeatureCheck featureCheck = response.body();
                            ArrayList<String> allFeature = featureCheck.getData().getAllFeatures();
                            ArrayList<String> feature = featureCheck.getData().getFeatures();
                            Log.d("TAG", "onResponse:feature check "+feature+"\n"+allFeature);
                            if (allFeature.contains("NFC")) {
                                binding.lytNfc.setVisibility(View.VISIBLE);
                            }else{
                                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_nfc), false);
                            }
                            if (allFeature.contains("Liveness") || allFeature.contains("Face-Match")) {
                                binding.lytFacialMatching.setVisibility(View.VISIBLE);
                            }else{
                                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_facila_matching), false);
                            }
                            if (feature.contains("NFC")) {
                                isNFCEnabled=true;
                                binding.imgNfc.setImageResource(R.drawable.toggle_on);
                                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_nfc), true);

                            } else {
                                binding.imgNfc.setImageResource(R.drawable.toggle_off);
                                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_nfc), false);
                            }
                            if (feature.contains("Liveness") || feature.contains("Face-Match")) {
                                isFacialMatchingEnabled=true;
                                binding.imgFacialMatching.setImageResource(R.drawable.toggle_on);
                                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_facila_matching), true);
                            } else {
                                binding.imgFacialMatching.setImageResource(R.drawable.toggle_off);
                                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_facila_matching), false);
                            }
                        } else {
                        }
                    } catch (Exception e) {
                    }
                    binding.lytLoading.setVisibility(View.GONE);
                    if (binding.lytNfc.getVisibility()==View.GONE && binding.lytFacialMatching.getVisibility()==View.GONE){
                        binding.btnSave.setVisibility(View.GONE);
                    }
                }

                @Override
                public void onFailure(Call<NashidFeatureCheck> call, Throwable t) {
                    binding.lytLoading.setVisibility(View.GONE);
                    Log.d("TAG", "openScanDocumentScreen onFailure: " + t.toString());
                }


            });
        }else{
            binding.lytLoading.setVisibility(View.GONE);
        }
    }
    private void callManageFeatureAPI(String features) {
        Log.d("TAG", "callNashidFeatureCheckAPI: " + NashidSDK.getInstance().getBaseURL());
        if (!NashidSDK.getInstance().getBaseURL().equalsIgnoreCase("") && !NashidSDK.getInstance().getRegisterToken().equalsIgnoreCase("")) {
           binding.lytLoading.setVisibility(View.VISIBLE);
            APIClient.getNashidFeatureCheckClient(NashidSDK.getInstance().getBaseURL(), NashidSDK.getInstance().getRegisterToken()).create(APIInterface.class).callManageFeature(features,NashidSDK.getInstance().getCompanyUUID()).enqueue(new Callback<NashidFeatureCheck>() {
                @Override
                public void onResponse(Call<NashidFeatureCheck> call, Response<NashidFeatureCheck> response) {
                    Log.d("TAG", "openScanDocumentScreen onResponse---: " + response.isSuccessful() + "\n" + response.body());
                    try {
                        if (response.isSuccessful()) {
                            NashidFeatureCheck featureCheck = response.body();
                            ArrayList<String> allFeature = featureCheck.getData().getAllFeatures();
                            ArrayList<String> feature = featureCheck.getData().getFeatures();
                            Log.d("TAG", "onResponse:mange feature "+feature+"\n"+allFeature);
                            finish();

                        } else {
                        }
                    } catch (Exception e) {
                    }
                }

                @Override
                public void onFailure(Call<NashidFeatureCheck> call, Throwable t) {
                    Log.d("TAG", "openScanDocumentScreen onFailure: " + t.toString());
                }


            });
        }else{
            binding.lytLoading.setVisibility(View.GONE);
            finish();
        }
    }

    private void initClick() {
        binding.lytHeaderMain.imgBack.setOnClickListener(view -> finish());
        binding.imgNfc.setOnClickListener(view -> {
            isNFCEnabled = !isNFCEnabled;
            enableDisableNFC();
        });
        binding.imgFacialMatching.setOnClickListener(view -> {
            isFacialMatchingEnabled = !isFacialMatchingEnabled;
            enableDisableFacialMatching();
        });
        binding.imgAmlScreening.setOnClickListener(view -> {
            isAMLScreeningEnabled = !isAMLScreeningEnabled;
            enableDisableAMLScreening();
        });
        binding.imgInstruction.setOnClickListener(view -> {
            isInstructionEnabled = !isInstructionEnabled;
            enableDisableInstruction();
        });
        binding.btnSave.setOnClickListener(view -> {
            if (OtherConstant.getInstance().getAppName().equalsIgnoreCase(getString(R.string.default_name))) {
                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_nfc), isNFCEnabled);
                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_facila_matching), isFacialMatchingEnabled);
                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_aml_screening), isAMLScreeningEnabled);
                SharePreferenceUtility.savePreferenceValue(getApplicationContext(), getString(R.string.sharepreference_verification_step), isInstructionEnabled);
                finish();
            }else{
                String feature="Scan";
                if (isNFCEnabled){
                    feature=feature+","+"NFC";
                }
                if (isFacialMatchingEnabled){
                    feature=feature+","+"Liveness";
                }
                callManageFeatureAPI(feature);
            }
        });
    }

    private void setLayoutAndTextSize() {
        TextSizeConverter textSizeConverter = new TextSizeConverter(getApplicationContext());
        textSizeConverter.changeStatusBarColor(SettingScreenActivity.this);

        ViewGroup.LayoutParams layoutParams2 = binding.lytHeaderMain.imgBack.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        binding.lytHeaderMain.imgBack.setLayoutParams(layoutParams2);

        if (getStorage().getPreferredLocale().equalsIgnoreCase("ar")) {
            binding.lytHeaderMain.imgBack.setRotation(180);
        }

        LinearLayout.LayoutParams layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(4), 0, 0);
        binding.lytHeaderMain.lytHeaderMain.setLayoutParams(layoutParams);
        binding.lytHeaderMain.txtHelp.setText(getString(R.string.setting));
        binding.lytHeaderMain.txtHelp.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(17));

        int padding = textSizeConverter.getPaddingORMarginValue(16);
        binding.lytSettingMain.setPadding(padding, padding, padding, padding);

        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(56), 0, 0);
        binding.lytNfc.setLayoutParams(layoutParams);

        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        binding.lytFacialMatching.setLayoutParams(layoutParams);

        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        binding.lytAmlScreening.setLayoutParams(layoutParams);

        layoutParams = textSizeConverter.getLinearLayoutParam();
        layoutParams.setMargins(0, textSizeConverter.getPaddingORMarginValue(16), 0, 0);
        binding.lytInstruction.setLayoutParams(layoutParams);

        binding.txtNfc.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(18));
        binding.txtFacialMatching.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(18));
        binding.txtAmlScreening.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(18));
        binding.txtInstruction.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(18));

        layoutParams2 = binding.imgNfc.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(52);
        layoutParams2.height = textSizeConverter.getHeight(24);
        binding.imgNfc.setLayoutParams(layoutParams2);

        layoutParams2 = binding.imgFacialMatching.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(52);
        layoutParams2.height = textSizeConverter.getHeight(24);
        binding.imgFacialMatching.setLayoutParams(layoutParams2);

        layoutParams2 = binding.imgAmlScreening.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(52);
        layoutParams2.height = textSizeConverter.getHeight(24);
        binding.imgAmlScreening.setLayoutParams(layoutParams2);

        layoutParams2 = binding.imgInstruction.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(52);
        layoutParams2.height = textSizeConverter.getHeight(24);
        binding.imgInstruction.setLayoutParams(layoutParams2);

        padding = textSizeConverter.getPaddingORMarginValue(12);
        binding.txtBtnSave.setPadding(0, padding, 0, padding);
        binding.txtBtnSave.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16));
        binding.btnSave.setRadius(textSizeConverter.calculateRadius(8));

        SVG back = null;
        try {
            back = SVG.getFromResource(getResources(), R.raw.back);
            binding.lytHeaderMain.imgBack.setSVG(back);
        } catch (SVGParseException e) {
        }
         layoutParams2 = binding.imgLoader.getLayoutParams();
        layoutParams2.width = textSizeConverter.getWidth(24);
        layoutParams2.height = textSizeConverter.getHeight(24);
        binding.imgLoader.setLayoutParams(layoutParams2);

        LinearLayout.LayoutParams marginLyoutParam = (LinearLayout.LayoutParams) binding.txtValidating.getLayoutParams();
        marginLyoutParam.setMargins(0, textSizeConverter.getPaddingORMarginValue(32), 0, 0);
        binding.txtValidating.setLayoutParams(marginLyoutParam);
        binding.txtValidating.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(20));

        Animation rotation = AnimationUtils.loadAnimation(SettingScreenActivity.this, R.anim.rotate);
        rotation.setFillAfter(true);
        binding.imgLoader.startAnimation(rotation);

        saveData();
    }

    private void saveData() {

        isNFCEnabled = SharePreferenceUtility.getSavePreferenceData(getApplicationContext(), getString(R.string.sharepreference_nfc));
        isFacialMatchingEnabled = SharePreferenceUtility.getSavePreferenceData(getApplicationContext(), getString(R.string.sharepreference_facila_matching));
        isAMLScreeningEnabled = SharePreferenceUtility.getSavePreferenceData(getApplicationContext(), getString(R.string.sharepreference_aml_screening));
        isInstructionEnabled = SharePreferenceUtility.getSavePreferenceData(getApplicationContext(), getString(R.string.sharepreference_verification_step));

        enableDisableNFC();
        enableDisableFacialMatching();
        enableDisableAMLScreening();
        enableDisableInstruction();
    }

    private void enableDisableNFC() {
        if (isNFCEnabled) {
            binding.imgNfc.setImageResource(R.drawable.toggle_on);
        } else {
            binding.imgNfc.setImageResource(R.drawable.toggle_off);
        }
    }

    private void enableDisableFacialMatching() {
        if (isFacialMatchingEnabled) {
            binding.imgFacialMatching.setImageResource(R.drawable.toggle_on);
        } else {
            binding.imgFacialMatching.setImageResource(R.drawable.toggle_off);
        }
    }

    private void enableDisableAMLScreening() {
        if (isAMLScreeningEnabled) {
            binding.imgAmlScreening.setImageResource(R.drawable.toggle_on);
        } else {
            binding.imgAmlScreening.setImageResource(R.drawable.toggle_off);
        }
    }

    private void enableDisableInstruction() {
        if (isInstructionEnabled) {
            binding.imgInstruction.setImageResource(R.drawable.toggle_on);
        } else {
            binding.imgInstruction.setImageResource(R.drawable.toggle_off);
        }
    }

}
